PRO dealias_ag_time_tag, header, tt_TMR, tt_data, btime, sc_id, status
;Cluster II IDL Procedure
;
;Abstract: dealias ambient GOES time tag
;
;created : Mark Chutter
;Oct. 23, 2002
;
;Modified:
;Nov. 12, 2002 MWC properly take into account the differences between
;                  BM1 and NM/BM2; added status
;
;Calling Interface:
;header   EDI_HEADER (i)   The EDI packet header
;tt_TMR  int         (i)   time tag at TMR
;tt_data int         (i)   packet time tag
;btime   P_LONG *    (i/o) BCI16 absolute time
;
;Return Value:
;
;Affected Variables:
;
;Description:
;dealias_ag_time_tag dealiases the packet time tag and then
;sets the BCI16 absolute time for the packet.  This is not a user
;level function.

COMMON pick, file_type, pick_lun

@pick_const
btime = lonarr(2)
delta = 0L
status = 1
delta = tt_data - tt_TMR
IF header.sub_mode EQ 5 THEN BEGIN
    lower = -8
    upper = 40
    IF ((delta GE lower) AND (delta LE upper)) THEN $
      delta = delta $
    ELSE IF ((delta GE lower-2048) AND (delta LE upper-2048)) THEN $
      delta = delta + 2048 $
    ELSE IF ((delta GE lower+2048) AND (delta LE upper+2048)) THEN $
      delta = delta - 2048 $
    ELSE IF ((delta GE lower-63488) AND (delta LE upper-63488)) THEN $
      delta = delta + 63488 $
    ELSE IF ((delta GE lower-65536) AND (delta LE upper-65536)) THEN $
      delta = delta + 65536 $
    ELSE BEGIN
        status = DELTA_TIME_TAG_BIG
        pick_cvt_sec_vax, header.packet_time, time_str
        print, 'delta in time tags not valid at ', time_str
    ENDELSE
ENDIF ELSE BEGIN
    lower = -264
    upper = 8
    IF ((delta GE lower) AND (delta LE upper)) THEN $
      delta = delta $
    ELSE IF ((delta GE lower+2048) AND (delta LE upper+2048)) THEN $
      delta = delta - 2048 $
    ELSE IF ((delta GE lower-2048) AND (delta LE upper-2048)) THEN $
      delta = delta + 2048 $
    ELSE IF ((delta GE lower+63488) AND (delta LE upper+63488)) THEN $
      delta = delta - 63488 $
    ELSE IF ((delta GE lower+65536) AND (delta LE upper+65536)) THEN $
      delta = delta - 65536 $
    ELSE BEGIN
        status = DELTA_TIME_TAG_BIG
        pick_cvt_sec_vax, header.packet_time, time_str
        print, 'delta in time tags not valid at ', time_str
    ENDELSE
ENDELSE


TMR_length = [5L, 152221L]
btime = sub_ctime(header.packet_time, TMR_length)
btime = add_ctime(btime, $
                  [0L, LONG(1000000. * delta / 4096.)])
btime = add_ctime(btime, $
                  [LONG(delta / 4096.), 0L])
END
