/******************************************************************************
                            hk.cpp  -  description
                             -------------------
    begin                : Tue Nov 21 11:25:00 CET 2001

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2001 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85741 Garching

    Cluster-II EDI: print EDI HK packets
******************************************************************************
$Log: hk.cpp,v $
Revision 1.2  2003/08/01 11:43:00  hav
added pid in output file name for uniqueness

Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.3  2002/05/28 07:26:29  hav
date/time and data in one line

Revision 1.2  2001/11/22 09:16:07  hav
fixed address error; addded three dummy ints in binary data structure to get a multiple of 8 for IDL

Revision 1.1  2001/11/21 14:11:46  hav
Initial revision

******************************************************************************/

static char rcsid[] = "$Id: hk.cpp,v 1.2 2003/08/01 11:43:00 hav Exp $";

/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "cl2tm.h"
#include "openfile.h"

/******************** CONSTANTS AND MACROS ***********************************/

/******************** TYPE DEFINITIONS **************************************/

/******************** FUNCTION PROTOTYPES ***********************************/

static void Usage(const char *exename);

/******************** GLOBAL STATIC DATA ***********************************/

/******************** MAIN PROGRAM ******************************************/

// ===========================================================================
   int main(int argc, char *argv[])
// ===========================================================================
{
   FILE *ofp = stdout;
   tmpacket tmpkt;
   scet *tp = &(tmpkt.hdr.sc_time);
   double ct;
   int binary = 0;
   char bin_fn[256];
   int dummy[3] = { 0, 0, 0 };

   tmpkt.pktno = 0;

   if (0) printf("%s\n", rcsid); // dummy instruction

   sprintf(bin_fn, "hk%d.bin", (int)getpid() );

   // Process command line arguments and options
   // ------------------------------------------
   int ch;
   while (1) {
      if ((ch = getopt (argc, argv, "hb")) == -1)
         break;

      switch (ch) {

      case '?':
      case 'h':
         Usage (argv[0]);
         exit (1);

      case 'b':
         binary = 1;
         break;
      }

   } // endwhile


   if (argc <= optind) {
      fprintf(stderr, "Missing input file name\n");
      Usage(argv[0]);
      exit(1);
   }


   // Open the data file
   // ------------------
   CL2TM_OpenFile (argv[optind]);

   if (binary) ofp = OpenFile(bin_fn, OPF_WB, OPF_EXIT);

   while (CL2TM_ReadPacket(&tmpkt) != -1) {

      if ( tmpkt.hdr.data_source != CL2TM_DSRC_EDI ||
           tmpkt.hdr.data_type != CL2TM_HKD_DATA      ) {
         ++tmpkt.pktno;
         continue;
      }


      if (binary) {
         ct = tp->ct; // convert from long double to double;
         fwrite(&ct, 1, sizeof(double), ofp);
         fwrite(tmpkt.data, 45, 2, ofp);
         fwrite(dummy, 3, 2, ofp);
      } else {
         // print packet time
         fprintf(ofp, "%04hd-%02hd-%02hdT%02hd:%02hd:%02hd   ",
                     tp->year, tp->month, tp->day,
                     tp->hr, tp->min, tp->sec);

         // print out hk data
         for (int i=0; i<45; ++i) {
            fprintf(ofp, "%04hx ", tmpkt.data[i]);
         }
         fprintf(ofp, "\n");
      }

      ++tmpkt.pktno;
   }

   CL2TM_CloseFile();


   if (binary) {
      fclose(ofp);
      printf("%s\n", bin_fn);
   }

   return 0;
}

// ==========================================================================
   static void Usage(const char *exename)
// ==========================================================================
{
   fprintf (stdout,
            "Usage: %s [-h] [-b] data-file-name\n"
            "\n"
            "  -h  print this help\n"
            "  -b  binary output\n"
            "\n", exename);
}





