; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: datast.inc,v 1.5 2003/10/28 19:24:32 hav Exp $
; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; definition of data structures
; ***************************************************************************

@vector.inc

hav_dummy = { WW_ORI_T, $
              ct1:0.0d, ct2:0.0d, $
              th1:0.0, ph1:0.0, th2:0.0, ph2:0.0, $
              tof1:0.0, tof2:0.0, dtof:0.0, $
              en:0, nc:0, q1:0, q2:0, $
              d14_1:0, d15_1:0, d14_2:0, d15_2:0, $
              mch1:0, mch2:0, $
              bci_idx1:0, fr_idx1:0, bci_idx2:0, fr_idx2:0, $
              mc:0, ovfl_t1:0, ovfl_t2:0, ovfl_dt:0, $
              ctype:0 }

hav_dummy = { WW_T, $
              stcnt:0, gd:0, ct:0.0d, $
              th:0.0, ph:0.0, tof:0.0, $
              en:0, nc:0, mc:0, q:0, $
              mch:0, d14:0, d15:0, $
              ctype:0, ovfl:0, $
              bci_idx:0, fr_idx:0 }

hav_dummy = { RUNEST_T,  $
              ct:0.0d, $        ; time tag (seconds since 1-Jan-1970)
              beamtime:0.0d, $  ; a copy of ct, for backwards compatibility
              gdu:0, $          ; 1 or 2 --- use this for PPQ ---
              gd:0, $           ; 12 or 21 --- use this for HAV ---
              runorder:0, $     ; 1..MAXORDER, 0 means 'check flags to find out'
              flag:intarr(6), $ ; 1 if runner probability gt P_LIM
              prob:dblarr(6), $ ; runner probabilities
              estof:fltarr(6), $ ; equivalent single runner ToFs
              sortindex:0L, $
              tg:0.0, $         ; gyro time
              tof:0.0, $        ; time of flight
              q:0, $            ; quality
              tcode:0.0, $
              tchip:0.0, $
              nc:0, $           ; correlator n
              tg0:0.0, $
              ph:0.0, $         ; phi     these three contain meaningful data
              th:0.0, $         ; theta   only when using the d,bs (hav)
              en:0 $            ; energy  passing mechanism
            }

hav_dummy = { PREP_T, $
              ct:0.0d, $             ; time tag (seconds since 1.Jan.1970)
              gd:0, $                ; 12=gun1/det2   21=gun2/det1
              ph:0.0, $              ; gun firing azimuth in GDU1 coordinates
              th:0.0, $              ; gun firing polar angle in GDU1 coordinates
              en:0, $                ; energy flag (0=1keV  1=500eV)
              tof:0.0, $             ; Time of Flight (for classA: correct estof
                       $             ;                 for classB: lowest possible order)
              q:0, $                 ; quality
              tcode:0.0, $           ; Pseudo-Noise Code period in us
              tchip:0.0, $           ; Pseudo-Noise Code chip length in us
              nc:0, $                ; correlator n
              runorder:0, $          ; runner order (0=not identified)
              flag:intarr(6), $      ; flags for runner order candidates
              prob:dblarr(6), $      ; probabilities for runner orders
              estof:fltarr(6), $     ; equivalent single runner Times of Flight
              tg:0.0, $              ; Gyro-Time in us (adjusted by runest)
              b_scs:fltarr(3), $     ; Magnetic Field data in SCS coordinates
              gf_scs:fltarr(3), $    ; gun firing vector in SCS coordinates
              gp_scs:fltarr(3), $    ; gun positions in SCS coordinates
              gyro_phase:0.0 $       ; Gun firing angle in Gyro-Plane
            }

hav_dummy = { RMT_T,  $
             avg1_ct:0.0d, $      ; time tag (t70)
             avg2_ct:0.0d, $
             en:0, $         ; energy (0=1keV)
             n1:0, n2:0, $   ; number of data points in each group
             avg1_dt:0.0, $     ; average <ToF1-Tgyro> in micro-s
             avg2_dt:0.0, $     ; average <ToF2-Tgyro> in micro-s
             avg1_tg:0.0, $      ; average Tgyro in micro-s
             avg2_tg:0.0, $
             magerr_dt:0.0, $   ; relative magnitude error (1.0 = 100%)
             avg1_dtTg:0.0,$ ; <(t1-tg)/tg>
             avg2_dtTg:0.0,$ ; <(tg-t2)/tg>
             magerr_dtTg:0.0, $  ; relative magnitude error(1.0 = 100%)
             avg1dir:{FVEC3_T}, $ ; avg drift direction for group 1
             avg2dir:{FVEC3_T} $   ; avg drift direction for group 2
           }

; -------------------------------------------------------------------------
