; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: xout.pro,v 1.6 2004/07/02 16:07:48 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; determine complementary set of indices
; ****************************************************************************

; ============================================================================
  FUNCTION Xout, NPTS, x_in
; ============================================================================
; Find the complementary set of indices into an array with NPTS elements
;
; This is a much simpler way! Sometimes it's easy to miss the obvious...
; ****************************************************************************

  x_all = lindgen(NPTS)

  x_valid = where(x_in ne -1, cnt) ; make sure we've got valid indices
  if cnt eq 0 then return, x_all   ; otherwise return all indices

  xi = x_in[x_valid]               ; pick the valid subset
  x_all[xi] = -1                   ; flag them
  x_out = where(x_all ne -1)       ; find all others
  return, x_out                    ; and return

END


; ============================================================================
  FUNCTION Xout_old, NPTS, x_in
; ============================================================================

  xout = -1L
  N_OUT = NPTS - n_elements(x_in) ; expected number of points in xout

  N_IN = n_elements(x_in)

  xin = x_in[sort(x_in)]

  if xin[0] eq -1 then return, lindgen(NPTS)
  if N_IN eq NPTS then return, -1L


  if xin[0] ne 0 then xout = [ xout, lindgen(xin[0]) ]

  if N_IN gt 1 then begin
     diff = xin[1:N_IN-1] - xin[0:N_IN-2]
     x = where(diff ne 1, cnt)
;     print, 'Xout: #(diff ne 1): ', cnt
     for i=0,cnt-1 do begin
;        print, i, 'adding points: x[i] =',x[i],'   diff[x[i]] = ',diff[x[i]], '   xin[x[i]] = ',xin[x[i]]
        xout = [ xout, lindgen(diff[x[i]]-1) + xin[x[i]] + 1 ]
     endfor
  endif

  if xin[N_IN-1] ne NPTS-1 then $
     xout = [ xout, lindgen(NPTS-1-xin[N_IN-1]) + xin[N_IN-1]+1 ]

  x = where(xout ne -1)
  if x[0] eq -1 then message, 'logical error'

  xout = xout[x]

  return, xout

END
