; ***************************************************************************
; Cluster EDI
; $Id: getcluhdr.pro,v 1.4 2003/11/12 11:59:16 hav Exp $
; ***************************************************************************

; ===========================================================================
  FUNCTION GetCluHdr,  status, msg, $
                       sc_id = sc_id, $
                       name = name, $
                       units = units, $
                       frame = frame
; ===========================================================================

header_version = 'V1.3'

if n_params() ne 2 then begin
   message, 'expecting exactly two parameters.'
endif

; header data for hav's Cluster EDI IDL data structures
; -----------------------------------------------------
cluhdr = { CLUHDR_T, $
               version:header_version, $
               status:0, $
               msg:'', $
               sc_id:0, $
               name:'?', $
               units:'?', $
               frame:'?' }

cluhdr.status = status
cluhdr.msg    = msg

if keyword_set(sc_id) then cluhdr.sc_id  = sc_id
if keyword_set(name)  then cluhdr.name = name
if keyword_set(units) then cluhdr.units  = units
if keyword_set(frame) then cluhdr.frame  = frame

return, cluhdr

END
