; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: vts_util.pro,v 1.12 2004/03/29 14:34:31 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

; ============================================================================
  PRO VTS_DEBUG, debug
; ============================================================================

@vector.inc

vts_debug = debug


END

; ============================================================================
  FUNCTION VTS_SERIES, nn, vec, ct
; ============================================================================

  @vector.inc

  out = replicate( {VTS_T}, nn )

  out.val = vec

  if n_params() eq 3 then out.ct = ct else out.ct = 0.0d

  return, out

END


; ============================================================================
  FUNCTION VTS_CHECK, vts, err_exit=err_exit
; ============================================================================

  @vector.inc

  vtype = tag_names( vts_t, /structure_name )

  dim = 0
  info = size(vts)
  if info[n_elements(info)-2] eq 8 then begin ; vts is of type 'structure'
     if tag_names( vts, /structure_name) eq vtype then begin
        if info[0] eq 1 then dim = n_elements(vts)
     endif
  endif

  if dim eq 0 and keyword_set(err_exit) then begin
     message, 'passed variable is not of type replicate('+vtype+',NN)', /cont
     help, vts
     help, /traceback
     retall
  endif

  return, dim

END

; ============================================================================
  PRO STS_CHECK, sts
; ============================================================================

  @vector.inc

  stype = tag_names( sts_t, /structure_name )

  if tag_names( sts, /structure_name) ne stype then begin
     message, 'passed structure is not of type ' + stype
  endif

END

; ============================================================================
  FUNCTION VTS_ADD,  vts1, vts2
; ============================================================================
; adds two vector time series
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts1, /err_exit)
      dummy=vts_check(vts2, /err_exit)
  endif

  ; quick and dirty : assumes time tags are equal if NV1 eq NV2

  NV1 = n_elements(vts1)
  NV2 = n_elements(vts2)

  if NV1 eq NV2 or NV2 eq 1 then begin
      vts_out = replicate( {VTS_T}, NV1 )
      vts_out.ct = vts1.ct
  endif else if  NV1 eq 1 then begin
      vts_out = replicate( {VTS_T}, NV2 )
      vts_out.ct = vts2.ct     
  endif else begin
      message, 'bad combination of vector dimentions : ' + $
               strtrim(NV1,2) + ' ' + strtrim(NV2,2)
  endelse

  vts_out.val(0) =  vts1.val(0) + vts2.val(0)
  vts_out.val(1) =  vts1.val(1) + vts2.val(1)
  vts_out.val(2) =  vts1.val(2) + vts2.val(2)

  return,  vts_out

END

; ============================================================================
  FUNCTION VTS_SUBTRACT,  vts1, vts2
; ============================================================================

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts1, /err_exit)
      dummy=vts_check(vts2, /err_exit)
  endif

  ; quick and dirty : assumes time tags are equal if NV1 eq NV2

  NV1 = n_elements(vts1)
  NV2 = n_elements(vts2)

  if NV1 eq NV2 or NV2 eq 1 then begin
      vts_out = replicate( {VTS_T}, NV1 )
      vts_out.ct = vts1.ct
  endif else if  NV1 eq 1 then begin
      vts_out = replicate( {VTS_T}, NV2 )
      vts_out.ct = vts2.ct     
  endif else begin
      message, 'bad combination of vector dimentions : ' + $
               strtrim(NV1,2) + ' ' + strtrim(NV2,2)
  endelse
   

  vts_out.val(0) =  vts1.val(0) - vts2.val(0)
  vts_out.val(1) =  vts1.val(1) - vts2.val(1)
  vts_out.val(2) =  vts1.val(2) - vts2.val(2)

  return,  vts_out

END

; ============================================================================
  FUNCTION VTS_DOTP,  vts1,  vts2
; ============================================================================

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts1, /err_exit)
      dummy=vts_check(vts2, /err_exit)
  endif


  ; quick and dirty : assumes time tags are equal if NV1 eq NV2

  NV1 = n_elements(vts1)
  NV2 = n_elements(vts2)

  if NV1 eq NV2 or NV2 eq 1 then begin
      sts_out = replicate( {STS_T}, NV1 )
      sts_out.ct = vts1.ct
  endif else if  NV1 eq 1 then begin
      sts_out = replicate( {STS_T}, NV2 )
      sts_out.ct = vts2.ct
  endif else begin
      message, 'bad combination of vector dimentions : ' + $
               strtrim(NV1,2) + ' ' + strtrim(NV2,2)
  endelse

   sts_out.val =  vts1.val(0) * vts2.val(0) + $
                  vts1.val(1) * vts2.val(1) + $
                  vts1.val(2) * vts2.val(2)

   return, sts_out

END


; ============================================================================
  FUNCTION VTS_CROSSP,  vts1,  vts2
; ============================================================================

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts1, /err_exit)
      dummy=vts_check(vts2, /err_exit)
  endif


  ; quick and dirty : assumes time tags are equal if NV1 eq NV2

  NV1 = n_elements(vts1)
  NV2 = n_elements(vts2)

  if NV1 eq NV2 or NV2 eq 1 then begin
      vts_out = replicate( {VTS_T}, NV1 )
      vts_out.ct = vts1.ct
  endif else if  NV1 eq 1 then begin
      vts_out = replicate( {VTS_T}, NV2 )
      vts_out.ct = vts2.ct
  endif else begin
      message, 'bad combination of vector dimentions : ' + $
               strtrim(NV1,2) + ' ' + strtrim(NV2,2)
  endelse

   vts_out.val[0] =  vts1.val[1] * vts2.val[2] - vts1.val[2] * vts2.val[1]
   vts_out.val[1] =  vts1.val[2] * vts2.val[0] - vts1.val[0] * vts2.val[2]
   vts_out.val[2] =  vts1.val[0] * vts2.val[1] - vts1.val[1] * vts2.val[0]

   return, vts_out

END


; ============================================================================
  FUNCTION VTS_MAG,  vts
; ============================================================================

@vector.inc

  if vts_debug ne 0 then $
    dummy=vts_check(vts, /err_exit)

  sts_out = replicate( {STS_T},  n_elements(vts) )

  sts_out.ct = vts.ct
  sts_out.val =  sqrt( vts.val(0)^2 + $
                       vts.val(1)^2 + $
                       vts.val(2)^2 )
  return,  sts_out

END


; ============================================================================
  FUNCTION VTS_XYMAG,  vts
; ============================================================================

@vector.inc

  if vts_debug ne 0 then $
    dummy=vts_check(vts, /err_exit)

  sts_out = replicate( {STS_T},  n_elements(vts) )

  sts_out.ct = vts.ct
  sts_out.val =  sqrt( vts.val(0)^2 + $
                       vts.val(1)^2 )
  return,  sts_out

END



; ============================================================================
  FUNCTION VTS_NORMALIZE, vts
; ============================================================================

@vector.inc

  if vts_debug ne 0 then $
    dummy=vts_check(vts, /err_exit)

  vts_out = replicate( {VTS_T},  n_elements(vts) )

  mag_ts = vts_mag(vts)

  vts_out.ct = vts.ct
  vts_out.val(0) =  vts.val(0) / mag_ts.val
  vts_out.val(1) =  vts.val(1) / mag_ts.val
  vts_out.val(2) =  vts.val(2) / mag_ts.val

  return,  vts_out

END

; ============================================================================
  FUNCTION VTS_MULTIPLY,  vts,  mult
; ============================================================================

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts, /err_exit)
  endif

  info = size(mult)
  NI = n_elements(info)
  if info[NI-2] eq 8 then begin
     sts = mult
     sts_check, sts
  endif else begin
     if info[0] ne 0 and info[NI-1] ne 1 then begin
        print, 'parameter <mult> is not STS_T or scalar!'
        print, 'size(mult) = ', info
        message, ''
     endif else begin
        sts = replicate( {STS_T}, 1)
        sts.val = mult
     endelse
  endelse

  ; quick and dirty : assumes time tags are equal if NV eq NS

  NV = n_elements(vts)
  NS = n_elements(mult)

  if NV eq NS or NS eq 1 then begin
      vts_out = replicate( {VTS_T},  NV )
      vts_out.ct = vts.ct
  endif else if NV eq 1 then begin
      vts_out = replicate( {VTS_T},  NS )
      vts_out.ct = sts.ct
  endif else begin
      help,  vts,  sts
      message, 'bad combination of dimensions'
  endelse

  vts_out.val(0) =  vts.val(0) * sts.val
  vts_out.val(1) =  vts.val(1) * sts.val
  vts_out.val(2) =  vts.val(2) * sts.val

  return,  vts_out

END

; ============================================================================
  FUNCTION VTS_INTERPOL, ts_in, new_times
; ============================================================================
; works for both vector and scalar time series (VTS_T, STS_T)
; ****************************************************************************
@vector.inc

  NN = n_elements(ts_in)
  ct0 = ts_in[0].ct

  ; create output data time series
  ; ------------------------------
  ts_out  =  replicate( ts_in[0], n_elements(new_times) )
  ts_out.ct = new_times

  ; interpolate to specified time tags (loop through all components of input data time series)
  ; -----------------------------------
  if NN gt 1 then begin
     for i = 0, n_elements(ts_in[0].val)-1 do begin
        ts_out.val[i] = interpol(ts_in.val[i], ts_in.ct - ct0, new_times - ct0)
     endfor
  endif else begin
     ts_out[*].val  = ts_in[0].val
  endelse

  return, ts_out

END

; ============================================================================
  FUNCTION VTS_PARA, vts1, vts2, ct_arr
; ============================================================================
; Calculates the vector projection of vts1 onto vts2
; The returned quantity is a 3D-vector !!! (not the scalar component of
; vector vts1 along vts2)
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts1, /err_exit)
      dummy=vts_check(vts2, /err_exit)
  endif

  ; check if vector time series should be interpolated first
  ; --------------------------------------------------------
  NV1 = n_elements(vts1)
  NV2 = n_elements(vts2)

  if n_params() gt 2 and NV1 gt 1 then begin
     vts1_i = vts_Interpol(vts1, ct_arr)
     NV1 = n_elements(ct_arr)
  endif else $
     vts1_i = vts1

  if n_params() gt 2 and NV2 gt 1 then begin
     vts2_i = vts_Interpol(vts2, ct_arr)
     NV2 = n_elements(ct_arr)
  endif else $
     vts2_i = vts2

  if not (NV1 eq NV2 or NV1 eq 1 or NV2 eq 1) then $
     message, 'bad dimension combination: ',  NV1, NV2

  vts2_i_hat = vts_Normalize(vts2_i)

  return, vts_Multiply( vts2_i_hat,  vts_Dotp(vts1_i, vts2_i_hat) )

END

; ============================================================================
  FUNCTION VTS_PERP,  vts1,  vts2, ct_arr
; ============================================================================
; calculates the part of vts1 which is perpendicular to vts2
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts1, /err_exit)
      dummy=vts_check(vts2, /err_exit)
  endif

  ; check if vector time series should be interpolated first
  ; --------------------------------------------------------
  NV1 = n_elements(vts1)
  NV2 = n_elements(vts2)

  if n_params() gt 2 and NV1 gt 1 then begin
     vts1_i = vts_Interpol(vts1, ct_arr)
     NV1 = n_elements(ct_arr)
  endif else $
     vts1_i = vts1

  if n_params() gt 2 and NV2 gt 1 then begin
     vts2_i = vts_Interpol(vts2, ct_arr)
     NV2 = n_elements(ct_arr)
  endif else $
     vts2_i = vts2

  if not (NV1 eq NV2 or NV1 eq 1 or NV2 eq 1) then $
     message, 'bad dimension combination: ',  NV1, NV2

;  vts2_i_hat  = vts_Normalize(vts2_i)
;  vts1_i_para = vts_Multiply(vts2_i_hat, vts_dotp(vts1_i, vts2_i_hat))

;  return, vts_Subtract(vts1_i, vts1_i_para)

goto, vts_perp_skip
; --- tmp --------
  print, 'vts_perp:'
  help, vts1, vts2, vts1_i, vts2_i
  parav = vts_para(vts1_i,vts2_i)
  help, parav
  retv = vts_subtract( vts1_i, parav )
  help, retv
  return, retv
; ----------------

vts_perp_skip:
  return, vts_Subtract( vts1_i, vts_para(vts1_i, vts2_i) )

END


; ============================================================================
  FUNCTION VTS_ANGLE,  vts1,  vts2, ct_arr
; ============================================================================
; Calculates the angle between vectors vts1 and vts2 and returns it
; as a scalar time series. The returned angle is in radians
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then begin
      dummy=vts_check(vts1, /err_exit)
      dummy=vts_check(vts2, /err_exit)
  endif

  ; check if vector time series should be interpolated first
  ; --------------------------------------------------------
  NV1 = n_elements(vts1)
  NV2 = n_elements(vts2)

  if n_params() gt 2 and NV1 gt 1 then begin
     vts1_i = vts_Interpol(vts1, ct_arr)
     NV1 = n_elements(ct_arr)
  endif else $
     vts1_i = vts1

  if n_params() gt 2 and NV2 gt 1 then begin
     vts2_i = vts_Interpol(vts2, ct_arr) 
     NV2 = n_elements(ct_arr)
  endif else $
     vts2_i = vts2
  

  if not (NV1 eq NV2 or NV1 eq 1 or NV2 eq 1) then $
     message, 'bad dimension combination: ',  NV1, NV2
  
  vts1_i_hat  = vts_Normalize(vts1_i)
  vts2_i_hat  = vts_Normalize(vts2_i)
  
  dot = vts_dotp(vts1_i_hat, vts2_i_hat)
  x = where(dot.val gt 1.0)  & if x[0] ne -1 then dot[x].val = 1.0
  x = where(dot.val lt -1.0) & if x[0] ne -1 then dot[x].val = -1.0
  angle = dot
  angle.val = acos(dot.val)

  return,  angle

END


; ============================================================================
  FUNCTION VTS_LAT,  vts
; ============================================================================
; calculates the latitude (angle between x-y plane and vector) of the
; passed vector time series
; The angle is returned as a scalar time series (STS_T). Values are in radians
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then $
    dummy=vts_check(vts, /err_exit)


  NN = n_elements(vts)
  lat = replicate( {STS_T}, NN )

  vts_hat  = vts_Normalize(vts)

  lat.ct  = vts.ct
  lat.val = asin( vts_hat.val(2) )

  return, lat

END


; ============================================================================
  FUNCTION VTS_PHI,  vts
; ============================================================================
; calculates the azimuth angle of the passed vector time series. The
; angle is returned as a scalar time series (STS_T). Values are in radians
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then $
    dummy=vts_check(vts, /err_exit)

  NN = n_elements(vts)
  phi = replicate( {STS_T}, NN )

  phi.ct  = vts.ct
  phi.val = atan( vts.val(1), vts.val(0) )

  return, phi

END

; ============================================================================
  FUNCTION VTS_ANGLE2X, sts, deg=deg
; ============================================================================
;
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then $
    sts_check, sts


  NN = n_elements(sts)
  x_arr = replicate( {STS_T}, NN )

  if keyword_set(deg) then angle_rad = sts.val * !PI/180 $
  else angle_rad = sts.val

  x_arr.ct  = sts.ct
  x_arr.val = cos( angle_rad )

  return, x_arr

END


; ============================================================================
  FUNCTION VTS_ANGLE2Y, sts, deg=deg
; ============================================================================
;
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then $
    sts_check, sts


  NN = n_elements(sts)
  y_arr = replicate( {STS_T}, NN )

  if keyword_set(deg) then angle_rad = sts.val * !PI/180 $
  else angle_rad = sts.val

  y_arr.ct  = sts.ct
  y_arr.val = sin( angle_rad )

  return, y_arr

END

; ============================================================================
  FUNCTION VTS_XY2ANGLE, xsts, ysts, deg=deg
; ============================================================================

@vector.inc

  if vts_debug ne 0 then begin
     sts_check, xsts
     sts_check, ysts
  endif

  NN = n_elements(xsts)

  if n_elements(ysts) ne NN then begin
     message, 'VTS_XY2ANGLE: incompatible dimensions', /cont
     retall
  endif

  ct_diff = xsts.ct-ysts.ct
  x=where(abs(ct_diff) gt 1.e-5, cnt)
  if cnt gt 0 then begin
     message, 'VTS2ANGLE: time tags are not equal!', /cont
     retall
  endif

  ang = replicate( {STS_T}, NN )

  ang.ct = xsts.ct
  ang.val = atan( ysts.val, xsts.val )

  if keyword_set(deg) then ang.val = ang.val * 180/!PI

  return, ang

END


; ============================================================================
  FUNCTION VTS_SMOOTH, vts, smooth_width
; ============================================================================
; smoothes a vector time series
; ****************************************************************************

@vector.inc

  if vts_debug ne 0 then $
    dummy=vts_check(vts, /err_exit)


  NN = n_elements(vts)
  out = replicate( {VTS_T}, NN )

  out.ct  = vts.ct

  for i=0,2 do begin
     out.val(i) = smooth( vts.val(i), smooth_width )
  endfor

  return, out

END


; ============================================================================
  FUNCTION VTS2ARR, vts
; ============================================================================

  @vector.inc

  vts_type = tag_names( {VTS_T}, /structure_name )
  sts_type = tag_names( {STS_T}, /structure_name )

  par_type = tag_names(vts, /structure_name)

  if par_type ne vts_type and par_type ne sts_type then begin
     message, 'passed structure is of unexpected type: ' + par_type
  endif


  NN = n_elements(vts)

  if par_type eq vts_type then outvec = fltarr(3,NN) $
  else                         outvec = fltarr(NN)

  outvec = vts.val

  return, outvec

END


; ============================================================================
  FUNCTION VTS2MAG, vts
; ============================================================================

  @vector.inc

  dummy=vts_check(vts, /err_exit)

  mag = vts_mag(vts)

  return, mag.val

END


; ============================================================================
  PRO VTS_PLOT, ts, yrange=yrange, psym=psym
; ============================================================================

  NN = n_elements(ts[0].val)

  if NN ne 1 and NN ne 3 then begin
     message, 'unexpected dimension: '+ strtrim(NN,2), /cont
     retall
  endif

  if not keyword_set(yrange) then yrange = [0,0]
  if not keyword_set(psym) then psym=0

  !p.multi = [0,0,NN,0,0]
  !p.charsize = 1.0
  if NN eq 3 then !p.charsize = 2.0

  @myct41.inc

  ax=axlabel(ts.ct)

  for i=0,NN-1 do $
     plot, ts.ct-ax.ct0, ts.val[i], yrange=yrange, psym=psym

  dummy = axlabel(/reset)

END


; ============================================================================
  FUNCTION VEC_CHECK, vec, err_exit=err_exit
; ============================================================================

  info = size(vec)

  if (info[0] eq 2 and info[1] eq 3 and info[n_elements(info)-2] eq 4) then $  ; either fltarr(3,NN)
     dim = info[2] $
  else if (info[0] eq 1 and info[1] eq 3 and info[n_elements(info)-2] eq 4) then $  ; or fltarr(3)
    dim = 1 $
  else begin
     dim = 0
     if keyword_set(err_exit) then begin
        message, 'Bad type for <vector>. Expecting fltarr(3,NN)', /cont
        help, vec
        help, /traceback
        retall
     endif
  endelse

  return, dim

END

; ============================================================================
  FUNCTION VEC2MAG, vec
; ============================================================================

   dummy = vec_check(vec, /err_exit)

   return, sqrt(total(vec^2,1))

END

; ============================================================================
  FUNCTION VEC_NORMALIZE, vec
; ============================================================================

  mag = vec2mag(vec)

  vec_out = vec

  for i=0,2 do $
     vec_out[i,*] = vec_out[i,*] / mag

  return, vec_out

END

; ============================================================================
  FUNCTION VEC_DOTP, vec1, vec2
; ============================================================================

  dim1 = vec_check(vec1, /err_exit)
  dim2 = vec_check(vec2, /err_exit)

  if dim1 ne dim2 then begin
     message, 'dimensions are not equal!'
  endif

  return, total(vec1*vec2,1)

END

; ============================================================================
  FUNCTION VEC_CROSSP, vec1, vec2
; ============================================================================

  dim1 = vec_check(vec1, /err_exit)
  dim2 = vec_check(vec2, /err_exit)

  if dim1 ne dim2 then begin
     message, 'dimensions are not equal!'
  endif

  out_vec = vec1

  for i=0,2 do begin
     i1 = (i+1) mod 3
     i2 = (i+2) mod 3
     out_vec[i,*] = vec1[i1,*] * vec2[i2,*]  -  vec1[i2,*] * vec2[i1,*]
  endfor

  return, out_vec

END
