; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: uncalspinaxis.pro,v 1.5 2004/07/06 16:50:57 hav Exp $
; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

@sc2scs.pro
@readfgmcalfile.pro
@getfgmrange.pro


; ============================================================================
  FUNCTION UnCalSpinAxis, bs, debug=debug
; ============================================================================
;
; ****************************************************************************

  if keyword_set(debug) then debug = 1 else debug = 0

  if bs.hdr.status eq 1 then begin
     message, bs.hdr.msg, /cont
     retall
  endif else if strupcase(bs.hdr.frame) ne 'SCS' then begin
     message, 'Can only handle SCS system, but data are in ' + bs.hdr.frame, /cont
     retall
  endif

  bs_out = bs

  sc = bs.hdr.sc_id

  day = -1
  ct_beg  = min(bs.data.ct, max=ct_end)
  ymd_beg = strmid(CluTimeVal2Str(ct_beg), 0, 10)
  ymd_end = strmid(CluTimeVal2Str(ct_end), 0, 10)

  repeat begin

     day = day + 1
     ymd_cur = strmid(CluTimeVal2Str(ct_beg+day*86400.d), 0, 10)
     ctr = CluTimeStr2Val(ymd_cur) + [0, 86400.d]
     if ymd_cur eq ymd_beg then ctr[0] = ct_beg
     if ymd_cur eq ymd_end then ctr[1] = ct_end

     ; read daily calfile and fgm ranges
     caldata = ReadFgmCalFile(sc, strjoin(strsplit(ymd_cur,'-',/extract)))
     fgmrng  = GetFgmRange(sc, ctr)

     ; extract fgm ranges
     idx_list = [ -1L ]
     for i=0,n_elements(fgmrng.data)-1 do begin
        if fgmrng.data[i].ct_beg lt ctr[1] or $
           fgmrng.data[i].ct_end gt ctr[0] then $
           idx_list = [ idx_list, i ]
     endfor

     if n_elements(idx_list) eq 1 then begin
        message, 'unknown range(s) during data interval!', /cont
        retall
     endif

     idx_list = idx_list[1:n_elements(idx_list)-1]

     if debug then $
        print, 'The following ranges occur within the data interval: ', $
               fgmrng.data[idx_list].range


     ; loop through list of fgm range time intervals
     for i=0,n_elements(idx_list)-1 do begin

        rng = fgmrng.data[idx_list[i]]
        rng_idx = rng.range - 2 ; range 2,3,4,5 --> indices 0-3
        spin_axis_offs = caldata[rng_idx].offs[0]

        if debug then begin
           print, 'treating range ', rng.range
        endif

        ; select B data withing current interval
        x = where(bs.data.ct ge rng.ct_beg and $
                  bs.data.ct lt rng.ct_end, cnt)

        if cnt eq 0 then begin
           if debug then print, 'no data for this fgm range time interval'
           continue
        endif

        if debug then begin
           print, CluTimeVal2Str(rng.ct_beg)
           print, CluTimeVal2Str(rng.ct_end)
           print, 'spin axis offset = ', spin_axis_offs
        endif


        ; spin up data (and switch axes), add offset, despin
        b_spin   = sc2scs(bs.data[x], /fgm, /reverse, sc_id=sc)
        b_spin.val[0] = b_spin.val[0] + spin_axis_offs
        b_out    = sc2scs(b_spin, /fgm, sc_id=sc)
        bs_out.data[x].val = b_out.val

     endfor


  endrep until ymd_cur eq ymd_end

  return, bs_out

end
