; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: myfread.pro,v 1.8 2004/06/21 09:36:17 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

; ============================================================================
  FUNCTION myfread,  filename,  fmt,  d_struct,  comment = comment, $
                     hdrlines=hdrlines, skipempty=skipempty, $
                     debug = debug,  quiet = quiet, nstruct=nstruct
; ============================================================================
; This function reads tabular ACSII data from a file.
; Parameters:
;      filename   (string)     name of the file
;      fmt        (string)     format string. May be set to '' for free
;                              format input
;      d_struct   (structure)  data structure prototype
;
; Keywords:
;      comment    ignore lines starting with the character passed in
;                 this keyword
;      hdrlines   on input: number of initial header lines to be skipped
;                 on output: contents of these lines (note: this requires
;                            the input number to be passed in a named
;                            variable)
;      skipempty  skip empty lines (lines that contain only optional spaces
;                 and an EOL character)
;      debug      be verbose
;      quiet      be quiet
;      nstruct    on input:  first guess for number of input data lines
;                 on output: number of actual data structures (note: this
;                            requires the input number to be passed in a
;                            named variable)
;
; Return:
;      an array of type d_struct  ( replicate( d_struct, NN) )
; ****************************************************************************

if not keyword_set(debug) then debug = 0 else debug = 1
if not keyword_set(quiet) then quiet = 0 else quiet = 1
if not keyword_set(comment) then comment = ''
if not keyword_set(hdrlines) then hdrlines = 0
if not keyword_Set(skipempty) then skipempty = 0 else skipempty = 1


fn = findfile(filename, count=cnt)
if cnt gt 1 then begin
   message, 'more than one candidate for <' + filename + '>', /cont
   retall
endif else if cnt eq 0 then begin
  if debug then print, filename + ' not found'
  nstruct = 0L
  return, 0
endif

if debug eq 1 then print, 'Reading data from ' + fn[0]

openr, fp, fn[0], /get_lun

; initial guess for number of data records
; ----------------------------------------
if keyword_set(nstruct) then NN = long(nstruct) $
else NN = 1000L
d_arr = replicate(d_struct, NN)

; read the data
; -------------
i = 0L
line = ''
while not eof(fp) do begin

   readf, fp, line

   if hdrlines gt 0 then begin
      if n_elements(myhdrlines) eq 0 then myhdrlines = line else myhdrlines = [ myhdrlines, line ]
      hdrlines = hdrlines - 1
      continue
   endif

   if comment ne '' then begin
      if strmid(line, 0, 1) eq comment then continue
   endif

   if skipempty then begin
      tmp = strcompress(line, /remove_all)
      if tmp eq '' then continue
   endif

   reads,  line,  format = fmt, d_struct
   d_arr[i] = d_struct
   i = i+1

   ; check if the array needs to be extended
   ; ---------------------------------------
   if i eq NN then begin
      if debug then print, 'doubling array size to ' + strtrim(NN*2, 2)
      d_arr = [ d_arr,  d_arr ]
      NN = NN*2
   endif

endwhile

free_lun, fp

; cut off unused trailing array elements
; --------------------------------------
if i eq 0 then begin
   nstruct = 0L
   return, 0
endif
d_arr = d_arr[0:i-1]

nstruct = n_elements(d_arr)

if debug eq 1 then $
   print, 'number of records: ' + strtrim(nstruct, 2)


if n_elements(myhdrlines) gt 0 then hdrlines = myhdrlines

return,  d_arr

END
