; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: hkutil.pro,v 1.7 2006/12/15 13:20:59 awe Exp $
; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

; ===========================================================================
  FUNCTION SensorAnalogParameter, hk, parname, parindex, raw=raw, x_mux=x_mux
; ===========================================================================
; x_mux is for output
; ***************************************************************************

; message, 'called with parname='+parname, /cont

  case strupcase(strmid(parname,4,1)) of
     '1' : begin & muxval = ishft(hk.data[22],-13) & wd=21 & shft=1 & end ; s1mx1
     '2' : begin & muxval = ishft(hk.data[24],-13) & wd=23 & shft=1 & end ; s2mx1
     'A' : begin & muxval = ishft(hk.data[22],-10) mod 8 & wd=21 & shft=0 & end ; s1mx2
     'B' : begin & muxval = ishft(hk.data[24],-10) mod 8 & wd=23 & shft=0 & end ; s2mx2
     else : begin
        message, 'unknown sensor analog parameter: ' + parname, /cont
        retall
     end
  endcase
  x_mux = where( muxval eq parindex, cnt )
  if cnt eq 0 then begin
     message, 'no data for required sensor mux value!', /cont
     return, { STS_T, ct:-1.0d, val:0.0 }
  endif
  ct = hk[x_mux].ct
  if shft eq 1 then $
     retval = ishft(hk[x_mux].data[wd],-8) $
  else $
     retval = (hk[x_mux].data[wd]+ 65536L) mod 256

  if parindex eq 7 then begin ; sensor temperature (used also to 'deposit' bad readings...)
     x_good = where(retval ne 255, cnt) ; filter our bad readings...
     if cnt eq 0 then begin
        message, 'temperature seems to contain only bad readings!', /cont
        x_mux = -1L
        return, { STS_T, ct:-1.0d, val:0.0 }
     endif
     ct=ct[x_good]
     retval=retval[x_good]
     x_mux = x_mux[x_good]
  endif

  ; now do conversion to physical units
  if not keyword_set(raw) then begin
     case parindex of
        0 : retval = -0.0025 * retval + 2.8187 ; 2.5V
        1 : retval = -0.25 * retval + 56.875   ; HVCR
        2 : retval = -0.025 * retval + 5.6875  ; HVER
        3 : retval = -0.0125 * retval + 2.8438 ; HVRF
        4 : retval = -0.025 * retval + 5.6875
        5 : retval = -0.01 * retval - 3.725
        6 : retval = -0.01 * retval + 6.275
        7 : retval = -0.5 * retval + 78.75
        else : begin
           message, 'Internal Error: bad value for multiplexer', /cont
           retall
        end
     endcase
  endif

  ret = replicate( {STS_T}, n_elements(retval) )
  ret.ct = ct
  ret.val = retval
  return, ret

END

; ===========================================================================
  FUNCTION GDUconv, raw_value, index
; ===========================================================================

  ; indices of parameters sorted by conversion table
  ma1  = 50 + indgen(6) ; ; I_OA, I_SR, I_SP, I_IA, I_RC, I_ET
  neg  = [ 13, 19, 24+indgen(11), 36, 37, 38, 40+indgen(8) ]
  neg5 = [ 17, 18, 20, 21, 22, 23 ]
  ma   = [ 0+indgen(12), 14, 15, 48, 49 ]
  cfq  = 56 + indgen(8)

  x = where(index eq neg, cnt)
  if cnt eq 1 then return, raw_value * 0.000625

  x = where(index eq ma, cnt)
  if cnt eq 1 then return, raw_value * 0.625 / 22

  x = where(index eq ma1, cnt)
  if cnt eq 1 then return, raw_value * 0.625 / 56

  x = where(index eq neg5, cnt)
  if cnt eq 1 then return, raw_value * 0.000625 * 5

  x = where(index eq cfq, cnt)
  if cnt eq 1 then return, abs(raw_value * 32.)

  if index eq 35 then return, raw_value * 0.625 - 273  ; GTMP

  if index eq 16 then return, raw_value * 0.000625 * 20.6 ; 28VS

  if index eq 12 then return, raw_value * 0.000625 ; I_BC (voltage! don't calculate beam current from exponential)

  if index eq 39 then return, raw_value * 0.625 / 50 ; I_CS

  message, 'conversion for some parameters not yet implemented', /cont
  retall

END

; ===========================================================================
  FUNCTION GDUParameter, hk, parname, parindex, raw=raw, x_mux=x_mux
; ===========================================================================
; x_mux is for output
; ***************************************************************************

  gdsel = ishft(ishft(hk.data[19],8),-15)  ; bit 7
  gdset = ishft(ishft(hk.data[19],2),-14) ; bits 14,13

  parset = parindex / 16
  case strmid(parname,4,1) of
     '1' : parsel = 0 ; GDU1
     '2' : parsel = 1 ; GDU2
     else : begin
        message, 'unknown GDU housekeeping parameter: ' + parname, /cont
        retall
     end
  endcase

  x_mux = where(gdsel eq parsel and gdset eq parset, cnt)

  if cnt eq 0 then begin
     message, 'no data for required GDU subcom value!', /cont
     x_mux = -1L
     return, { STS_T, ct:-1.0d, val:0.0 }
  endif

  ct = hk[x_mux].ct
  retval = hk[x_mux].data[25 + (parindex mod 16)]

  if not keyword_set(raw) then $
     retval = GDUconv(retval, parindex)

  ret = replicate( {STS_T}, n_elements(retval) )
  ret.ct = ct
  ret.val = retval
  return, ret

END


; ===========================================================================
  FUNCTION GetHkParam, hkdat, parname, raw=raw, xsel=xsel
; ===========================================================================
; hkdat is an array of structures { ct:double, data:intarr(45) 48 actually... }
; xsel is for output (indices into hkdat)
; ===========================================================================

@vector.inc

  modid = ishft(hkdat.data[6],-10)
  submo = ishft(hkdat.data[1],-12)

  x_no_good = where( modid eq 63 or submo eq 0, complement=x_good)
  if x_good[0] eq -1 then begin
     message, 'telemetry is invalid!', /cont
     return, { STS_T, ct:-1.0d, val:0.0 }
  endif
  hk = hkdat[x_good]
  ct = hk.ct
  xsel = x_good

  found = 1
  case strupcase(parname) of
     'MODID' : retval = modid[x_good]
     'SUBMO' : retval = submo[x_good]

     'EVT11' : retval = hk.data[11]
     'EVT21' : retval = hk.data[12]
     'EVT12' : retval = hk.data[13]
     'EVT22' : retval = hk.data[14]

     'BMAGN' : begin
         mag = ishft(ishft(hk.data[18],4),-4)
         rng = ishft(hk.data[18],-12)
         x = where(rng lt 2 or rng gt 5)
         if x[0] ne -1 then rng[x] =  7
         rng_factor = [ 0,  0,  1./32,  1./8,  1./2,  1./0.5,  0,  0 ]
         retval = mag * rng_factor[rng]
         end
     'BRNGE' : retval = ishft(hk.data[18],-12)
     'OPTSTATE': retval = ishft(ishft(hk.data[42],5),-13) ; bits 10-8
     else : begin
        found = 0
     end
  endcase

  if found eq 1 then begin
     ret = replicate( {STS_T}, n_elements(retval) )
     ret.ct = ct
     ret.val = retval
     return, ret
  endif

  ; see if it is a subcommutated GDU housekeeping value
  ; ---------------------------------------------------
  gdu_params = [ 'I_D1', 'I_D2', 'I_D3', 'I_D4', 'I_D5', 'I_D6', 'I_D7', 'I_D8', $
                 'I_AN', 'I_FC', 'I_CA', 'I_BW', 'I_BC', 'GNDG', 'I_EU', 'I_AU', $
                 '28VS', '5VUF', 'P5VC', 'GNDO', 'N5VC', '5VIF', '5VP1', '5VP2', $
                 'GPUX', 'GNUX', 'GPUY', 'GNUY', 'G_AN', 'G_FC', 'G_CA', 'G_BW', $
                 'O_EU', 'O_AU', 'G_BC', 'GTMP', 'REG1', 'REG2', 'N2VR', 'I_CS', $
                 'O_EL', 'O_AL', 'O_OA', 'O_SR', 'O_SP', 'O_IA', 'O_RC', 'O_ET', $
                 'I_EL', 'I_AL', 'I_OA', 'I_SR', 'I_SP', 'I_IA', 'I_RC', 'I_ET', $
                 'CFQ1', 'CFQ2', 'CFQ3', 'CFQ4', 'CFQ5', 'CFQ6', 'CFQ7', 'CFQ8' ]

  x = where( strupcase(strmid(parname,0,4)) eq gdu_params )
  if x[0] ne -1 then begin
     out = GDUParameter(hk, parname, x[0], raw=raw, x_mux=x_mux)
     if x_mux[0] ne -1L then xsel = xsel[x_mux] $
     else xsel = -1L
     return, out
  endif

  ; see if it is an analog sensor parameter
  ; ---------------------------------------
  sensor_analog_params = [ '2.5V', 'HVCR', 'HVER', 'HVRF', 'PRGN', 'N_5V', 'P_5V', 'STMP' ]
  x = where( strupcase(strmid(parname,0,4)) eq sensor_analog_params )
  if x[0] ne -1 then begin
     out = SensorAnalogParameter(hk, parname, x[0], raw=raw, x_mux=x_mux)
     if x_mux[0] ne -1L then xsel = xsel[x_mux] $
     else xsel = -1L
     return, out
  endif

  message, 'Error: parameter ' + parname + ' unknown or not yet treated!', /cont
  retall

END


