/******************************************************************************
                        hkupl.cpp  -  description
                             -------------------
    begin                : Thu Feb 14 11:40:00 CET 2002

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2002 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85741 Garching

    Cluster-II EDI: print HK information relevant during EDI uploads
                    from telemetry files (SCS, CDDS EDI HK, MSF)
******************************************************************************
$Id: hkupl.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $

******************************************************************************/

static char rcsid[] = "$Id: hkupl.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $";

/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "cl2tm.h"

/******************** GLOBAL STATIC DATA ************************************/

/******************** MAIN PROGRAM ******************************************/

// ===========================================================================
   int main(int argc, char *argv[])
// ===========================================================================
{
   FILE *ofp = stdout;
   tmpacket tmpkt;
   scet *tp = &(tmpkt.hdr.sc_time);

   tmpkt.pktno = 0;

   float conpc, gd1pc, gd2pc, bmag;
   short lastc, cxcnt;
   short modid, submo, pacmo;
   short chksu, eewrp, fgcnt;
   short range;
   short gdsel, gdset;
   float rng_f[] = { 0,    0, 1./32, 1./8,
                     1./2, 2, 0, 0,
                     0, 0, 0, 0,
                     0, 0, 0, 0 };

   char *modid_str[] = {
         "MD_0", "GEOS", "TV  ", "????",
         "????", "WW  ", "????", "????",
         "MD_8", "????", "????", "????",
         "MD_C", "MD_D", "????", "????",
         "????", "????", "????", "AMB " };


   if (0) printf("%s\n", rcsid); // dummy instruction

   if (argc!=2) {
      fprintf(stderr, "Usage: hkupl filename\n");
      exit(1);
   }

   CL2TM_OpenFile(argv[1]);


   while (CL2TM_ReadPacket(&tmpkt) != -1) {

      if (tmpkt.hdr.data_source != CL2TM_DSRC_EDI ||
          tmpkt.hdr.data_type != CL2TM_HKD_DATA) {
         ++tmpkt.pktno;
         continue;
      }

      // extract some hk parameters
      cxcnt = tmpkt.data[4];
      lastc = tmpkt.data[5];
      modid = (tmpkt.data[6] >> 10) & 0x3f;
      submo = (tmpkt.data[1] >> 12) & 0xf;
      pacmo = tmpkt.data[44] & 0x7;
      range = (tmpkt.data[18]>>12) & 0xf;
      bmag = (tmpkt.data[18] & 0xfff) * rng_f[range]; // in nT

      chksu = (tmpkt.data[17] >> 8) & 0xff;
      eewrp = (tmpkt.data[3] >> 14) & 0x1;
      fgcnt = (tmpkt.data[44] >> 8) & 0xf;

      gdsel = ((tmpkt.data[19]) >> 7) & 0x1;
      gdset = ((tmpkt.data[19]) >> 12) & 0x3;

      if (modid>19) modid=3; // to take care of indexing modid_str

      // calculate currents only if TM was not lost (LASTC != ffff)
      // and if EDI is on (SUBMO != 0)
      if (lastc!=(short)0xffff && submo!=0) {
         conpc = 0.4888 * ( (tmpkt.data[1]&0xfff) - 512 );
         gd1pc = 0.4888 * ( (tmpkt.data[2]&0xfff) + 0.716*conpc - 512 );
         gd2pc = 0.4888 * ( (tmpkt.data[3]&0xfff) + 0.716*conpc - 512 );
      } else {
         conpc = 0; gd1pc = 0; gd2pc = 0;
      }

/*
      fprintf(ofp, "%04hd-%02hd-%02hdT%02hd:%02hd:%02hd : "
                   "%4s    %d   %3u/%3u  %04hx    %02hx      %d      %d\n",
                      tp->year, tp->month, tp->day,
                   tp->hr, tp->min, tp->sec,
                   modid_str[modid], submo, (cxcnt>>8)&0xff, cxcnt&0xff,
                   lastc, chksu, eewrp, fgcnt);
*/
      fprintf(ofp, "----------------------------------------------------------------------------\n");
      fprintf(ofp, "packet time : %04hd-%02hd-%02hdT%02hd:%02hd:%02hd\n\n",
                   tp->year, tp->month, tp->day,
                   tp->hr, tp->min, tp->sec);
      fprintf(ofp, "MODID: %4s.%d  CxCNT=%3u/%3u  LASTC=%04hx  CHKSU=%02hx  EEWRP=%d   FGCNT=%d\n\n",
                   modid_str[modid], submo, (cxcnt>>8)&0xff, cxcnt&0xff,
                   lastc, chksu, eewrp, fgcnt);
      if (gdsel == 0 && gdset == 0) {
         fprintf(ofp, "  I_D11  I_D21  I_D31  I_D41  I_D51  I_D61  I_D71  I_D81\n");
         fprintf(ofp, "%7.2f%7.2f%7.2f%7.2f%7.2f%7.2f%7.2f%7.2f\n\n",
                      tmpkt.data[25] * 0.625/22, tmpkt.data[26] * 0.625/22,
                      tmpkt.data[27] * 0.625/22, tmpkt.data[28] * 0.625/22,
                      tmpkt.data[29] * 0.625/22, tmpkt.data[30] * 0.625/22,
                      tmpkt.data[31] * 0.625/22, tmpkt.data[32] * 0.625/22);
         fprintf(ofp, "  I_AN1  I_FC1  I_CA1  I_BW1                I_EU1  I_AU1\n");
         fprintf(ofp, "%7.2f%7.2f%7.2f%7.2f              %7.2f%7.2f\n\n",
                      tmpkt.data[33] * 0.625/22, tmpkt.data[34] * 0.625/22,
                      tmpkt.data[35] * 0.625/22, tmpkt.data[36] * 0.625/22,
                      tmpkt.data[39] * 0.625/22, tmpkt.data[40] * 0.625/22);
      } else if (gdsel == 0 && gdset == 1) {
         fprintf(ofp, "  GPUX1  GNUX1  GPUY1  GNUY1  G_AN1  G_FC1  G_CA1  G_BW1\n");
         fprintf(ofp, "%7.1f%7.1f%7.1f%7.1f%7.1f%7.1f%7.1f%7.1f\n\n",
                      tmpkt.data[33] * 0.000625, tmpkt.data[34] * 0.000625,
                      tmpkt.data[35] * 0.000625, tmpkt.data[36] * 0.000625,
                      tmpkt.data[37] * 0.000625, tmpkt.data[38] * 0.000625,
                      tmpkt.data[39] * 0.000625, tmpkt.data[40] * 0.000625);
      } else if (gdsel == 0 && gdset == 2) {
         fprintf(ofp, "  O_EU1  O_AU1  G_BC1         REG11  REG21         I_CS1\n");
         fprintf(ofp, "%7.1f%7.1f%7.1f       %7.1f%7.1f       %7.1f\n\n",
                      tmpkt.data[25] * 0.000625, tmpkt.data[26] * 0.000625,
                      tmpkt.data[27] * 0.000625, tmpkt.data[29] * 0.000625,
                      tmpkt.data[30] * 0.000625, tmpkt.data[32] * 0.625/50 );
      }


      ++tmpkt.pktno;
   }

   CL2TM_CloseFile();

   return 0;
}













