/******************************************************************************
                        hkmode.cpp  -  description
                             -------------------
    begin                : Wed Feb 07 16:33:00 CET 2001

    author               : Hans Vaith
    email                : hav@mpe.mpg.de
    copyright            : (C) 2001 by Max-Planck-Institut fr extra-
                           terrestrische Physik, D-85740 Garching

    Cluster-II EDI: print mode information, EDI primary currents in mA, Bmag
                    from telemetry files (SCS, CDDS EDI HK, MSF)
******************************************************************************
$Id: hkmode.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $
$Log: hkmode.cpp,v $
Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

Revision 1.7  2002/05/28 07:27:03  hav
added ambient GEOS

Revision 1.6  2001/08/10 11:28:33  hav
use ReadPacket instead of cl2dmp

******************************************************************************/

static char rcsid[] = "$Id: hkmode.cpp,v 1.1.1.1 2002/10/14 17:08:19 hav Exp $";

/******************** INCLUDE FILES ******************************************/

#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include "cl2tm.h"

/******************** GLOBAL STATIC DATA ************************************/

/******************** MAIN PROGRAM ******************************************/

// ===========================================================================
   int main(int argc, char *argv[])
// ===========================================================================
{
   FILE *ofp = stdout;
   tmpacket tmpkt;
   scet *tp = &(tmpkt.hdr.sc_time);

   tmpkt.pktno = 0;

   float conpc, gd1pc, gd2pc, bmag;
   short lastc, cxcnt;
   short modid, submo, pacmo;
   short range;
   float rng_f[] = { 0,    0, 1./32, 1./8,
                     1./2, 2, 0, 0,
                     0, 0, 0, 0,
                     0, 0, 0, 0 };

   char *modid_str[] = {
         "MD_0", "GEOS", "TV  ", "???3",
         "???4", "WW  ", "???6", "???7",
         "MD_8", "???9", "??10", "??11",
         "MD_C", "MD_D", "??14", "??15",
         "??16", "??17", "??18", "AMB ",
         "??20", "AMGE", "?>21" };


   if (0) printf("%s\n", rcsid); // dummy instruction

   if (argc!=2) {
      fprintf(stderr, "Usage: hkmode filename\n");
      exit(1);
   }

   CL2TM_OpenFile(argv[1]);

   while (CL2TM_ReadPacket(&tmpkt) != -1) {

      if (tmpkt.hdr.data_source != CL2TM_DSRC_EDI ||
          tmpkt.hdr.data_type != CL2TM_HKD_DATA) {
         ++tmpkt.pktno;
         continue;
      }

      // extract some hk parameters
      cxcnt = tmpkt.data[4];
      lastc = tmpkt.data[5];
      modid = (tmpkt.data[6] >> 10) & 0x3f;
      submo = (tmpkt.data[1] >> 12) & 0xf;
      pacmo = tmpkt.data[44] & 0x7;
      range = (tmpkt.data[18]>>12) & 0xf;
      bmag = (tmpkt.data[18] & 0xfff) * rng_f[range]; // in nT

      if (modid>21) modid=22; // to take care of indexing modid_str

      // calculate currents only if TM was not lost (LASTC != ffff)
      // and if EDI is on (SUBMO != 0)
      if (lastc!=(short)0xffff && submo!=0) {
         conpc = 0.4888 * ( (tmpkt.data[1]&0xfff) - 512 );
         gd1pc = 0.4888 * ( (tmpkt.data[2]&0xfff) + 0.716*conpc - 512 );
         gd2pc = 0.4888 * ( (tmpkt.data[3]&0xfff) + 0.716*conpc - 512 );
      } else {
         conpc = 0; gd1pc = 0; gd2pc = 0;
      }


      fprintf(ofp, "%04hd-%02hd-%02hdT%02hd:%02hd:%02hd : "
                   "%04hx %04hx   "
                   "%4s %2hx %2hx   "
                   "%7.1f %7.1f %7.1f      %7.1f  %2hd\n",
                   tp->year, tp->month, tp->day,
                   tp->hr, tp->min, tp->sec,
                   cxcnt, lastc,
                   modid_str[modid], submo, pacmo,
                   conpc, gd1pc, gd2pc, bmag, range);

      ++tmpkt.pktno;
   }

   CL2TM_CloseFile();

   return 0;
}












