/******************************************************************************
                           hkextract.h  -  description
                             -------------------
    begin                : Sep 23 22:47 CET 2002

    author               : Hans Vaith
    email                : hav@mpe.mpg.de

******************************************************************************
$Id: hkextract.h,v 1.2 2003/08/27 09:26:12 hav Exp $
******************************************************************************
$Log: hkextract.h,v $
Revision 1.2  2003/08/27 09:26:12  hav
better process synchronization between playback and start_display
CVS  ----------------------------------------------------------------------

Revision 1.1.1.1  2002/10/14 17:08:19  hav
c/c++ sources

*****************************************************************************/

#ifndef _HKEXTRACT_H_
#define _HKEXTRACT_H_

/************************ TYPE DEFINITIONS **********************************/

typedef struct {
  char *de_name;
  short wd, offs, mask;
  short raw_val;
  float cnv_val;
  char *cnv_tbl_name;
  char *cnv_units;
  char *subcom_name;
  short subcom_val;
} hk_extract_t;

typedef struct {
  short raw_val;
  float cnv_val;
} hk_val_t;

/************************ FUNCTION PROTOTYPES *******************************/
size_t HkExtractInitialize(void);
void  *HkExtractGetAddress(void);
void   SetRetrieveAddress(hk_extract_t *p);
void   hkextract(short *data);
short  GetRawVal(const char *de_name);
float  GetCnvVal(const char *de_name);

#endif
