; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: getfgmrange.pro,v 1.6 2005/03/03 15:19:01 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

@clutime.pro
@myfread.pro

; ============================================================================
  FUNCTION GetFGMrange, sc_id, ctr, debug=debug, quiet=quiet
; ============================================================================

@paths.inc

  on_error, 0  ; stop at the statement that causes an error

  if keyword_set(debug) then debug = 1 else debug = 0
  if keyword_set(quiet) then quiet = 1 else quiet = 0

  ; Check parameters
  ; ----------------
  if n_params() ne 2 then begin
      msg = 'need 2 parameters (sc_id, ctr)'
      if debug then print, msg
         return, { status:1, msg:msg }
  endif else begin

      ct_min = ctr[0]
      ct_max = ctr[1]

      if size(ct_min,/type) ne 5 then begin
         msg = 'bad type for ct_min: (' + strtrim(size(ct_min,/type),2) + $
              '). Double precision float expected.'
         if debug then print, msg
         return, { status:1, msg:msg }
      endif
      if size(ct_max,/type) ne 5 then begin
         msg = 'bad type for ct_max: (' + strtrim(size(ct_max,/type),2) + $
              '). Double precision float expected.'
         if debug then print, msg
         return, { status:1, msg:msg }
      endif
  endelse


  ; Set up path and file name
  ; -------------------------
  path     = ATT_ORB_PATH
  ct_min_str = CluTimeVal2Str(ct_min)
  ct_max_str = CluTimeVal2Str(ct_max)
  year_month_min = strmid(ct_min_str,2,2) + strmid(ct_min_str,5,2)
  year_month_max = strmid(ct_max_str,2,2) + strmid(ct_max_str,5,2)

  filename = 'C' + strtrim(sc_id,2) + '_' + year_month_min + '.log'
  NFILES = 1

  if year_month_max ne year_month_min then begin
     yr_max = fix(strmid(year_month_max,0,2))
     mo_max = fix(strmid(year_month_max,2,2))
     yr_min = fix(strmid(year_month_min,0,2))
     mo_min = fix(strmid(year_month_min,2,2))

     delta_year  = yr_max - yr_min
     delta_month = (mo_max - mo_min + 12) mod 12
     if (delta_month ne 1 or delta_year lt 0 or delta_year gt 1) then begin
        msg = 'time interval may not span more than two months!'
         if debug then print, msg
         return, { status:1, msg:msg }
     endif

     filename = [ filename, $
                  'C' + strtrim(sc_id,2) + '_' + year_month_max + '.log' ]
     NFILES = 2
  endif


  prototype = { day:0, dummy1:0, range:0, dummy2:0, dummy3:0, $
                dummy4:'', hms_beg:'', dummy5:'', hms_end:'' }
  fmt = '(I4,3(I3),I4,A2,A12,A2,A12)'


  data = myfread(path + '/' + filename[0], fmt, prototype, $
                 hdrlines=1, quiet=quiet, nstruct=nstruct1)
  N1 = n_elements(data)

  if NFILES eq 2 then begin
     data2 = myfread(path + '/' + filename[1], fmt, prototype, hdrlines=1, nstruct=nstruct2)
     data = [ data, data2 ]
  endif

  if nstruct1 eq 0 then begin
     if NFILES eq 1 then nstruct2 = 0L
     if nstruct2 eq 0 then begin
        ret = { status:1, msg:'no fgm range info file found ('+path+'/'+filename+')' }
        return, ret
     endif
  endif

  NN = n_elements(data)

  ct_beg = dblarr(NN)
  ct_end = dblarr(NN)


  ct0 = CluTimeStr2Val( strmid(ct_min_str, 0, 8) + '01' )

  for i=0L,NN-1 do begin
     hour = fix(strmid(data[i].hms_beg, 0,2))
     minu = fix(strmid(data[i].hms_beg, 3,2))
     seco = fix(strmid(data[i].hms_beg, 6,2))
     msec = fix(strmid(data[i].hms_beg, 9,3))
     ct_beg[i] = ct0 + (data[i].day - 1) * 86400. + hour*3600. + minu*60. + $
              seco + 1.e-3*msec
     
     ; !!! if begin time is closer to midnight (end of day) than 30 seconds 
     ; then it is actually from previous day
     if hour eq 23 and minu eq 59 and seco gt 30 then begin
        if debug then message, 'begin time is from previous day!', /cont
        ct_beg[i] = ct_beg[i] - 86400.
     endif

     hour = fix(strmid(data[i].hms_end, 0,2))
     minu  = fix(strmid(data[i].hms_end, 3,2))
     seco  = fix(strmid(data[i].hms_end, 6,2))
     msec = fix(strmid(data[i].hms_end, 9,3))
     ct_end[i] = ct0 + (data[i].day - 1) * 86400. + hour*3600. + minu*60. + $
              seco + 1.e-3*msec

; this was the solution previously used for begin dates from previous day
; It did not work for e.g. C2 2001-09-22 where the difference was still positive!
;     if ct_end[i] lt ct_beg[i] then ct_beg[i] = ct_beg[i] - 86400.
  endfor

  ; fix ctime for
  if NFILES gt 1 then begin
     ct1 = CluTimeStr2Val( strmid(ct_max_str, 0, 8) + '01' )
     if NN-N1 gt 0 then begin
        ct_beg[N1:NN-1] = ct_beg[N1:NN-1] - ct0 + ct1
        ct_end[N1:NN-1] = ct_end[N1:NN-1] - ct0 + ct1
     endif
  endif


  x = where( ct_end gt ct_min and ct_beg lt ct_max)
  if x[0] eq -1 then begin
     msg = 'no fgm range information found for specified interval'
     if debug then print, msg
     return, { status:1, msg:msg }
  endif


  ; join adjacent intervals with equal ranges
  ; -----------------------------------------
  range  = data[x].range
  ct_beg = ct_beg[x]
  ct_end = ct_end[x]

  NR = n_elements(range)

  if debug then begin
      print, 'initial intervals'
      for cnt=0L,NR-1 do $
        print, range[cnt], '  ', $
        strmid(clutimeval2str(ct_beg[cnt]),0,21), '  ', $
        strmid(clutimeval2str(ct_end[cnt]),0,21)
  endif

  i = 0L
  while i le NR-2 do begin
     if debug then begin
         print, '-------------------------'
         print, 'i / NR  = ', i, NR
     endif
     if range[i] eq range[i+1] and $
        (ct_beg[i+1] - ct_end[i]) lt 1800 then begin

        new_range     = range[0:i]
        new_ct_beg    = ct_beg[0:i]
        new_ct_end    = ct_end[0:i]
        new_ct_end[i] = ct_end[i+1]
        if i lt NR-2 then begin
           range  = [ new_range,  range[i+2:NR-1]  ]
           ct_beg = [ new_ct_beg, ct_beg[i+2:NR-1] ]
           ct_end = [ new_ct_end, ct_end[i+2:NR-1] ]
       endif else begin
           range = new_range
           ct_beg = new_ct_beg
           ct_end = new_ct_end
       endelse
       NR = n_elements(range)
       i=i-1

       if debug then begin
           print, 'intervals after join:', i+1, i+2
           for cnt=0L,NR-1 do $
             print, range[cnt], '  ', $
             strmid(clutimeval2str(ct_beg[cnt]),0,21), '  ', $
             strmid(clutimeval2str(ct_end[cnt]),0,21)
       endif

     endif else if debug then print, 'no modification this time'

     i=i+1

  endwhile


  ; copy data to final return structure
  ; -----------------------------------
  re_data = { range:0, ct_beg:0.0d, ct_end:0.0d }
  re_data = replicate( re_data, NR )

  re_data.range  = range
  re_data.ct_beg = ct_beg
  re_data.ct_end = ct_end

  ret = { status:0, msg:'ok', data:re_data }

  if debug then begin

     print, 'number of ranges : ', NR

     ; print the range intervals
     ; -------------------------
     for i=0,NR-1 do $
        print, ret.data[i].range, '  ', $
        CluTimeVal2Str(ret.data[i].ct_beg), '  ', $
        CluTimeVal2Str(ret.data[i].ct_end)

  endif


  return, ret

END
















































































