; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: gaps.pro,v 1.3 2004/06/25 15:30:07 hav Exp $
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


@clutime.pro
@xout.pro

; ============================================================================
  FUNCTION GetGaps, ct_arr, gap_spec, debug = debug
; ============================================================================
; Find gaps in the time tag array 'ct_arr' (time tag deltas larger than
; gap_spec)
; Returns an array of time intervals identifying all gaps
; ****************************************************************************

  if keyword_set(debug) then debug = 1 else debug = 0

  ret_gap = { IV_T70_T, ct_beg:-1.0d, ct_end:-1.0d } ; define return type

  if n_elements(ct_arr) eq 1 then return, ret_gap

  ; find gaps in reference time tag array
  ; -------------------------------------
  sortindex = sort(ct_arr)
  ct_arr_sorted = ct_arr[sortindex]
  NN = n_elements(ct_arr_sorted)
  ct_diff = ct_arr_sorted[1:NN-1] - ct_arr_sorted[0:NN-2]
  x_gap = where(ct_diff gt gap_spec, gap_cnt)

  if debug then message, strtrim(gap_cnt,2) + ' gap(s) detected', /cont

  if gap_cnt eq 0 then return, ret_gap

  ret_gap = replicate( {IV_T70_T}, gap_cnt )

  ; set up the return array of gap intervals
  ; ----------------------------------------
  for i=0,gap_cnt-1 do begin
     ret_gap[i].ct_beg = ct_arr_sorted[x_gap[i]]
     ret_gap[i].ct_end = ct_arr_sorted[x_gap[i]+1]
     if debug then print, '   ' + $
                   strmid(CluTimeVal2Str(ret_gap[i].ct_beg),0,19) + '  -  ' + $
                   strmid(CluTimeVal2Str(ret_gap[i].ct_end),0,19)
  endfor

  return, ret_gap

END


; ============================================================================
  FUNCTION MergeIntervals, iv_arr1, iv_arr2, debug=debug
; ============================================================================

  if keyword_set(debug) then debug = 1 else debug = 0

  ; Concatenate intervals and sort according to interval start times
  iv_arr = [ iv_arr1, iv_arr2 ]
  sortindex = sort(iv_arr.ct_beg)
  iv_arr = iv_arr[sortindex]

  x = where(iv_arr.ct_beg gt 0, cnt)
  if cnt eq 0 then return, iv_arr1 ; no valid intervals --> nothing to do
  iv_arr = iv_arr[x]

  ; Make sure there are no bad intervals (end earlier than begin)
  x = where(iv_arr.ct_end lt iv_arr.ct_beg, cnt)
  if cnt gt 0 then begin
     message, 'Bad Intervals (end before begin)!'
  endif

  remaining = iv_arr
  new = 1

  repeat begin
     NN = n_elements(remaining)
     if debug then begin
        print, 'Loop: Nremain = ', NN
        for i=0,NN-1 do print, strmid(clutimeval2str(remaining[i].ct_beg),0,23) + '  -  ' + $
                               strmid(clutimeval2str(remaining[i].ct_end),0,23)
     endif
     if new then begin
        current = remaining[0]
        remaining = remaining[1:NN-1]
        new = 0
     endif

     if debug then print, 'current: ' + strmid(clutimeval2str(current.ct_beg),0,23) + '  -  ' + $
                                        strmid(clutimeval2str(current.ct_end),0,23)

     ; find all intervals for which the begin is inside the
     ; current interval and join them
     ; ----------------------------------------------------
     x = where(remaining.ct_beg lt current.ct_end, overlap_cnt, $
               complement=xrem, ncomplement=rem_cnt)
     if debug then print, cnt, ' overlapping intervals found'
     if overlap_cnt gt 0 then $
        current.ct_end = max([remaining[x].ct_end,current.ct_end])

     if overlap_cnt eq 0 or rem_cnt eq 0 then begin
        if n_elements(out) eq 0 then out = current $
        else                         out = [ out, current ]
        new = 1
     endif

     if debug then if rem_cnt eq 0 then print, 'no elements remaining. Leaving loop...'
     if rem_cnt eq 0 then break

     remaining = remaining[xrem]
     if rem_cnt eq 1 and new eq 1 then begin
        out = [ out, remaining ]
        break
     endif

  endrep until 1 eq 0

  if debug then begin
     message, '', /cont
     print, 'number of intervals out : ', n_elements(out)
     for i=0,n_elements(out)-1 do $
        print, clutimeval2str(out[i].ct_beg) + '   ' + clutimeval2str(out[i].ct_end)
  endif

  return, out

END

; ============================================================================
  FUNCTION MergeIntervalsOld, iv_arr1, iv_arr2, debug=debug
; ============================================================================
; Merges overlapping intervals
; Example:
;
; --------------------------------------------> time axis
; Interval 1 :   [       ]
; Interval 2 :       [         ]
; Merged     :   [             ]
; ****************************************************************************

  fname = 'MergeIntervals: '

  if not keyword_set(debug) then debug = 0

  gap_iv_arr = [ iv_arr1, iv_arr2 ]

  ; sort gap array
  ; --------------
;  sortindex = sort(gap_iv_arr.ct_beg)
;  gap_iv_arr = gap_iv_arr[sortindex]

  x = where(gap_iv_arr.ct_beg ge 0)
  if x[0] eq -1 then return, iv_arr1[0]

  gap_iv_arr = gap_iv_arr[x]
  N_GAPS = n_elements(gap_iv_arr)

  if debug gt 0 then begin
     print, fname + '#intervals before gap joining : ', N_GAPS
     for i=0,N_GAPS-1 do $
        print, strmid(CluTimeVal2Str(gap_iv_arr[i].ct_beg),0,23) + '  -  ' + $
               strmid(CluTimeVal2Str(gap_iv_arr[i].ct_end),0,23)
  endif

  ; merge overlapping intervals
  ; ---------------------------
  ct_beg = gap_iv_arr.ct_beg
  ct_end = gap_iv_arr.ct_end

  i = 0L
  while 1 eq 1 do begin
     ; find all intervals overlapping current interval
     x = where(ct_beg le ct_end[0] and ct_end ge ct_beg[0], complement=xleft)
     if x[0] eq -1 then begin
        message, fname + 'logical error! end[0] < begin[0] ?', /cont
        retall
     endif

     iv = [ min(ct_beg[x]), max(ct_end[x]) ] ; merged overlapping intervals

     gap_iv_arr[i].ct_beg = iv[0]  ; store
     gap_iv_arr[i].ct_end = iv[1]

     if xleft[0] eq -1 then break

     if n_elements(x) gt 1 then begin      ; there may be intervals which overlap with
        ct_beg = [ iv[0], ct_beg[xleft] ]  ; the new merged interval
        ct_end = [ iv[1], ct_end[xleft] ]
     endif else begin
        ct_beg = ct_beg[xleft]             ; no more overlapping intervals
        ct_end = ct_end[xleft]
        i = i + 1
     endelse

     if debug gt 1 then begin
        print, 'x     = ', x
        print, 'xleft = ', xleft
        for j=0,n_elements(ct_beg)-1 do $
           print, strmid(CluTimeVal2Str(ct_beg[j]),0,23) + '  -  ' + $
                  strmid(CluTimeVal2Str(ct_end[j]),0,23)
     endif

  endwhile

  N_GAPS = i+1
  gap_iv_arr = gap_iv_arr[0:N_GAPS-1]

;  gap_iv_arr = replicate( gap_iv_arr[0], N_GAPS )
;  gap_iv_arr.ct_beg = ct_beg_out
;  gap_iv_arr.ct_end = ct_end_out

  if debug gt 0 then begin
     print, fname + '#intervals after gap joining : ', N_GAPS
     for i=0,N_GAPS-1 do $
        print, strtrim(i,2) + '   ' + $
               strmid(CluTimeVal2Str(gap_iv_arr[i].ct_beg),0,23) + '  -  ' + $
               strmid(CluTimeVal2Str(gap_iv_arr[i].ct_end),0,23)
  endif

  return, gap_iv_arr

END

; ============================================================================
  FUNCTION RemoveGaps, ctarr, gap_iv_arr, debug=debug
; ============================================================================
; This function examines the reference time tag array <ct_ref> for gaps
; (time tag differences larger than <gap_spec>) and returns the indices of
; all data that lie outside of the gaps
;
; Parameters
;
; Return
; ****************************************************************************

  fname = 'RemoveGaps : '

  if not keyword_set(debug) then debug = 0

  if gap_iv_arr[0].ct_beg lt 0 then return, lindgen(n_elements(ctarr))

  ; find indices of all data points that lie withing gaps
  ; -----------------------------------------------------
  x_in_gap = -1L
  for i=0,n_elements(gap_iv_arr)-1 do begin

     gap = gap_iv_arr[i]

     x_in_gap = [ x_in_gap, where(ctarr gt gap.ct_beg and $
                                  ctarr lt gap.ct_end, remove_cnt) ]

     if debug gt 0 then begin
        print, fname + strtrim(i,2) + '  ' + $
               strmid(CluTimeVal2Str(gap.ct_beg),11,12) + '  -  ' + $
               strmid(CluTimeVal2Str(gap.ct_end),11,12) + ' : ' + $
               strtrim(remove_cnt,2) + ' point(s) removed'
     endif

  endfor

  x = where(x_in_gap ne -1, cnt)
  if cnt eq 0 then return, lindgen(n_elements(ctarr))

  x_in_gap = x_in_gap[x]

;  help, ctarr, x_in_gap
;  print, x_in_gap
  x_outside_gaps = xout(n_elements(ctarr), x_in_gap)

  return, x_outside_gaps

END
