; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: edianomalylist.pro,v 1.1 2006/02/28 03:16:29 hav Exp $
; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

@clutime.pro

; ===========================================================================
  FUNCTION GetEdiAnomalyList
; ===========================================================================
; This function turns the ISO-format time strings of the anomaly time
; intervals into ctime format (seconds since Jan 1970) and returns the
; resulting structure array
; ***************************************************************************

@edianomalylist.inc

  NN = n_elements(edi_anomaly_list)
  dummy = { sc:0, ctr:dblarr(2), ww_gun:0, ww_det:0, ag_det:0, msg:'' }
  out = replicate( dummy, NN )

  out.sc     = edi_anomaly_list.sc
  out.ww_gun = edi_anomaly_list.ww_gun
  out.ww_det = edi_anomaly_list.ww_det
  out.ag_det = edi_anomaly_list.ag_det
  out.msg    = edi_anomaly_list.msg

  for i=0L,NN-1 do begin
     out[i].ctr[0] = str2ct(edi_anomaly_list[i].iv[0])
     out[i].ctr[1] = str2ct(edi_anomaly_list[i].iv[1])
  endfor

  return, out

END

