; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; $Id: edianomalylist.inc,v 1.10 2007/04/04 21:43:57 awe Exp $
; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; EDI Anomaly List
; ***************************************************************************


; --------------------------------------------------------------------------
; The variable edi_anomaly_list is an array of intervals during which
; anomalies occurred that affected the data in some way. The structure
; members are:
;
;    sc  : spacecraft identifier (1 to 4)
;    iv  : time interval, given in ISO format (yyyy-mm-ddthh:mm:ss])
;    ww_gun, ww_det, ag_det : gun/detector anomaly specifiers for
;                             Windshield Wiper mode (ww) and ambient
;                             GEOS mode (ag)
;    msg : a string that holds some details about the anomaly
;
; where the anomaly specifiers (ww_gun, ww_det, ag_det) are integers
; in the range 0 to 3. The values have the following meaning:
;
;   0 = data ok
;   1 = GDU1 data not ok
;   2 = GDU2 data not ok
;   3 = data from both GDUs not ok
;

edi_anomaly_list = [ $
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 1  2001 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; no SC 1 anomalies in 2001 that would affect existing data
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 1  2002 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2002-06-27t07:00:00','2002-06-28t07:00:00'], $
     ww_gun:1, ww_det:3, ag_det:0, $
     msg:'Unusually high number of q=1 beams. Gun1 on by mistake.' }, $
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2002-10-18t09:00:00','2002-10-23t11:20:00'], $
     ww_gun:2, ww_det:2, ag_det:0, $
     msg:'PGA2 corruption in GDU2' }, $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 1  2003 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2003-01-24t06:34:00','2003-01-29t03:00:00'], $
     ww_gun:2, ww_det:2, ag_det:0, $
     msg:'PGA2 corruption in GDU2 (GD217=$ffff)' }, $
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2003-06-03t19:00:00','2003-06-11t07:10:00'], $
     ww_gun:2, ww_det:1, ag_det:0, $
     msg:'too many q=1 hits in detector 1 (PGA2 corruption?)' }, $
   ;
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 1  2004 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ;  no SC 1 anomalies in 2004 that would affect existing data
   ;  (there is one occurrence of a counts ratio drop in ambient GEOS,
   ;  however)
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 1  2005 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2005-02-09t16:00:03.100','2005-02-11t09:00:00'], $
     ww_gun:0, ww_det:1, ag_det:1, $
     msg:'PGA1 corruption in GDU1; bad GDU HK and drop of' + $
         ' ambient GEOS event rates.'}, $
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2005-09-25t22:26:03.600','2005-09-27t15:30:00'], $
     ww_gun:0, ww_det:0, ag_det:2, $
     msg:'Loss of GDU2 data; presumably SEU in PGA1.' }, $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 1  2006 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; 2006 anomalies not finished yet
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2006-05-02t08:07:56.900','2006-05-10t12:48:00'], $
     ww_gun:3, ww_det:3, ag_det:3, $
     msg:'PGA corruption in both GDUs'}, $
   ;
   { EDI_ANOMALY_LIST_T, sc:1, $
     iv:['2006-05-23t20:00:00','2006-06-01t11:10:00'], $
     ww_gun:3, ww_det:3, ag_det:0, $
     msg:'low success rate (quality) in Windshield Wiper mode'}, $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 1  2007 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; 2007 anomalies not yet done
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 2  2001 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:2, $
     iv:['2001-04-02t22:00:00','2001-04-26t17:30:00'], $
     ww_gun:0, ww_det:1, ag_det:0, $
     msg:'GDU1 correlator problem (SEU?) affecting DATA word 14, ' + $
         'causing most WW data to be of quality 3' }, $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 2  2002 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:2, $
     iv:['2002-10-18t10:00:00','2002-10-24t09:00:00'], $
     ww_gun:1, ww_det:1, ag_det:0, $
     msg:'PGA2 corruption in GDU1 (GD117)' }, $
   ;
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 2  2003 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:2, $
     iv:['2003-06-18t17:40:00','2003-06-20t11:40:00'], $
     ww_gun:0, ww_det:3, ag_det:0, $
     msg:'false hits (WW) in both detectors' }, $
   ;
   { EDI_ANOMALY_LIST_T, sc:2, $
     iv:['2003-06-20t23:00:00','2003-06-21t01:30:00'], $
     ww_gun:2, ww_det:2, ag_det:2, $
     msg:'PGA1 corruption in GDU2' }, $
   ;
   { EDI_ANOMALY_LIST_T, sc:2, $
     iv:['2003-12-09t11:00:00','2003-12-10t05:00:00'], $
     ww_gun:0, ww_det:3, ag_det:0, $
     msg:'false hits (WW) in both detectors' }, $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 2  2004 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; no SC 2 anomalies in 2004 that would affect existing data
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 2  2005 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:2, $
     iv:['2005-06-27t17:17:10','2005-07-01t04:00:00'], $
     ww_gun:0, ww_det:1, ag_det:1, $
     msg:'GDU1 DATA29 and DATA30 counts problem (SEU in PGA1?). ' + $
         'maxaddr and maxcounts of GDU1 in HK TM seem also fixed.' }, $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 2  2006 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; 2006 anomalies not yet done
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 2  2007 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; 2007 anomalies not yet done
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 3  2001 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; no SC 3 anomalies in 2001 that would affect existing data
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 3  2002 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; no SC 3 anomalies in 2002 that would affect existing data
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 3  2003 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   { EDI_ANOMALY_LIST_T, sc:3, $
     iv:['2003-09-03t12:00:00','2003-09-03t14:00:00'], $
     ww_gun:0, ww_det:2, ag_det:0, $
     msg:'false hits in detector 2 (WW)' }, $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 3  2004 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; no SC 3 anomalies in 2004 that would affect existing data
   ; (there are six occurrences of count rate ratio drops in ambient GEOS,
   ;  however)
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 3  2005 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; (there are ten occurrences of count rate ratio drops in ambient GEOS,
   ;  in addition)
   ;
   { EDI_ANOMALY_LIST_T, sc:3, $
     iv:['2005-01-20t08:00:00','2005-01-25t14:00:00'], $
     ww_gun:0, ww_det:2, ag_det:2, $
     msg:'Sensor 2 stops counting and sensor mux stops cycling. ' + $
         'PGA2 seems also affected (bad CMD17 mirror)' }, $
   ;
   { EDI_ANOMALY_LIST_T, sc:3, $
     iv:['2005-10-23t05:42:35.800','2005-10-27t13:30:00'], $
     ww_gun:0, ww_det:1, ag_det:0, $
     msg:'SEU in PGA2 of GDU1 (-->no q=23 hits in WW)' } $
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 3  2006 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; 2006 anomalies not yet done
   ;
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ; +----------------------| Spacecraft 3  2007 |--------------------------+
   ; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   ;
   ; 2007 anomalies not yet done
   ;
]
