C $Id: test_rtn_to_gse.f,v 1.3 1999/03/12 18:26:30 asc Exp $
C Test code for the transfromation from rtn to gse and gsm
c
       program test_rtn_to_gse
C
       implicit none
C
       integer*4 time(2), VELOCITY_REQ, istatus
       real*8 TRANSFORM_MATRIX(3,3), DERIV_MATRIX(3,3)
       real*8 GCI(3), RTN(3), GSE(3), GSM(3)
       real*8 spacecraft_pos(3) 
C
       OPEN(UNIT=6,STATUS='NEW',file='data.dat')
C
       time(1)=1997181
       time(2)=54466181
       write(6,*) ' AT time =',time
C
C      This is the spacecraft position in J2000 GCI, needed as input
       spacecraft_pos(1) =  7.4545669885d+5
       spacecraft_pos(2) = -1.1366004289d+6
       spacecraft_pos(3) = -4.6248674225d+5
       write(6,*) ' j2000 pos =',spacecraft_pos
C
C      RTN vector to be transformed to GSE or GSM
       RTN(1) =-9.8791186723D-1
       RTN(2) =-1.5214958272D-1
       RTN(3) = 2.9675698320D-2
       write(6,*) ' RTN att =',RTN
       write(6,*)
C
C CONVERT FROM RTN TO GCI
C
       VELOCITY_REQ = 0    ! Have not completed the derivative path
       call  IC_RTN_TO_GCI (TIME,spacecraft_pos, 
     1                      TRANSFORM_MATRIX,DERIV_MATRIX,
     2                      VELOCITY_REQ,ISTATUS)
       call MULMAT(TRANSFORM_MATRIX,RTN,3,3,1,GCI)
       WRITE (6,*) ' GCI =',GCI
C
C CONVERT FROM GCI TO GSE
C
       call  IC_GCI_TO_GSE (TIME, 
     1                      TRANSFORM_MATRIX,DERIV_MATRIX,
     2                      VELOCITY_REQ,
     3                      ISTATUS)
       call MULMAT(TRANSFORM_MATRIX,GCI,3,3,1,GSE)
       WRITE (6,*) ' GSE =',GSE
C
C CONVERT FROM GCI TO GSM
C
       call IC_GCI_TO_GSM (TIME, 
     1                     TRANSFORM_MATRIX,
     2                     DERIV_MATRIX,
     3                     VELOCITY_REQ,
     4                     ISTATUS)
       call MULMAT(TRANSFORM_MATRIX,GCI,3,3,1,GSM)
       WRITE (6,*) ' GSM =',GSM
C
       STOP
       END








