C $Id: icss_cnvt_from_rp.f,v 1.2 1998/07/24 21:54:40 asc Exp $
C   Unit Name:
C       ICSS_CNVT_FROM_RP
C   
C   Purpose:
C       Convert a vector in the spacecraft rotating coordinate frame to 
C       a fixed payload coordinate frame
C
C   Unit Type: 
C       FORTRAN subroutine
C
C   Invocation Method:
C       CALL ICSS_CNVT_FROM_RP (spin_phase, sc_vector, 
C      1                        payload_vector, matrix)
C
C   Argument List:
C       Name                  Type  Use   Description
C       --------------------  ----  ---   --------------------------------------
C       spin_phase            R*4   I     The spin phase angle in radians
C       sc_vector(3)          R*4   I     The XYZ vector in the spacecraft
C                                          rotating coordinate frame
C       payload_vector(3)     R*4   O     The XYZ vector in the fixed payload
C                                          coordinate frame
C       matrix(9)             R*8   O     The transformation matrix used in
C                                          converting the vector; the values
C                                          are in the order
C                                          (1,1), (2,1), (3,1),
C                                          (1,2), (2,2), (3,2),
C                                          (1,3), (2,3), (3,3)
C
C   File / Record References:
C       none
C
C   External Variables:
C       none
C
C   External References:
C       none
C
C   Abnormal Termination Conditions:
C       none
C
C   Assumptions, Constraints and Restrictions:
C       none
C
C   Development History:
C   
C       Author         Change ID  Release  Date       Description of Change
C       -------------  ---------  -------  ---------  --------------------------
C       Paul Paluzzi   CCR 88     B5R3.0   1993Feb23  Initial implementation
C
C   Notes:
C
C   PDL:
C        Calculate the transformation matrix using the spin phase angle
C        Multiply the transformation matrix by the vector in the spacecraft
C         frame to get the vector in the payload frame
C        RETURN
C-------------------------------------------------------------------------------

      SUBROUTINE ICSS_CNVT_FROM_RP (spin_phase, sc_vector, 
     1                              payload_vector, matrix)

      IMPLICIT NONE
      REAL*4    spin_phase, sc_vector(3), payload_vector(3)
      REAL*8    matrix(9)

C     Calulate the transformation matrix

      matrix(1) = DCOS (DBLE (spin_phase))
      matrix(2) = DSIN (DBLE (spin_phase))
      matrix(3) = 0.0D0
      matrix(4) = -matrix(2)
      matrix(5) =  matrix(1)
      matrix(6) = 0.0D0
      matrix(7) = 0.0D0
      matrix(8) = 0.0D0
      matrix(9) = 1.0D0

C     Calculate the payload vector

      payload_vector(1) = sc_vector(1) * matrix(1) +
     1                    sc_vector(2) * matrix(4)
      payload_vector(2) = sc_vector(1) * matrix(2) +
     1                    sc_vector(2) * matrix(5)
      payload_vector(3) = sc_vector(3)

      RETURN
      END
