C $Id: ic_vector_to_angles.f,v 1.2 1998/07/24 21:54:39 asc Exp $
CCCC
C
C  IC_VECTOR_TO_ANGLES - convert a unit vector to right ascension and
C                        declination angles
C 
C  PURPOSE:  convert a unit vector to angles of right ascension 
C            and declination.
C
C  UNIT TYPE:  SUBROUTINE
C
C  INVOCATION METHOD:  CALL IC_ANGLES_TO_VECTOR (att_pos_vect, 
C                                                att_pos)
C
C  ARGUMENT LIST:
C
C  NAME	                  TYPE   USE  DESCRIPTION
C  ----                   ----   ---  -----------
C  ATT_POS_VECT(3)        R*8    I    ATT POS IN UNIT VECTOR FORM
C  ATT_POS(3)             R*8    O    ATT POSITION (SPIN, RT ASC, DECL)
C
C  FILE/RECORD REFERENCES:  NONE
C
C  EXTERNAL VARIABLES:  NONE
C
C  EXTERNAL REFERENCES:  NONE
C
C  ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:  NONE
C
C  ASSUMPTIONS, CONSTRAINTS, RESTRICTIONS:  NONE
C
C  DEVELOPMENT HISTORY
C
C  AUTHOR	CHANGE ID	RELEASE	  DATE	    DESCRIPTION OF CHANGE
C  ------	---------	-------   ----	    ---------------------
C  J. LUBELCZYK                 B1R1      12/06/90  INITIAL PDL
C  J. LUBELCZYK                 B1R1      12/12/90  CODING
C  J. LUBELCZYK ICCR #83, CCR #'S 130, 137 11/91    B3 update
C
C  NOTES:
C    The magnitude of the position vector (x, y, z) is 1
C
CCCC
C
C  PDL:
C
C  Calculate the declination angle
C
C**  Calculate the right ascension angle  **
C  X equals the absolute value of ATT_POS_VECT(1)
C  Y equals the absolute value of ATT_POS_VECT(2)
C
C  docase POLARITY OF ATT_POS_VECT(1) [xaxis]
C  case 1 (ATT_POS_VECT(1) equals 0.0)  !Avoid dividing by zero
C
C     do case POLARITY OF ATT_POS_VECT(2) [yaxis]
C     case 1 (ATT_POS_VECT(2) equals 0.0)
C        RT_ASCENS = 0  !meaningless
C     case 2 (ATT_POS_VECT(2) is greater than 0.0)
C        RT_ASCENS = PI/2
C     case 3 (ATT_POS_VECT(2) is less than 0.0)
C        RT_ASCENS = 3 PI/2
C     enddo
C
C  case 2 (ATT_POS_VECT(1) is greater than 0.0)
C
C     do case POLARITY OF ATT_POS_VECT(2) [yaxis]
C     case 1 (ATT_POS_VECT(2) equals 0.0)
C        RT_ASCENS = 0
C     case 2 (ATT_POS_VECT(2) is greater than 0.0)
C        RT_ASCENS = datan(Y/X)
C     case 3 (ATT_POS_VECT(2) is less than 0.0)
C        RT_ASCENS = 2 PI - (datan(Y/X))
C     enddo
C
C  case 3 (ATT_POS_VECT(1) is less than 0.0
C
C     do case POLARITY OF ATT_POS_VECT(2) [yaxis]
C     case 1 (ATT_POS_VECT(2) equals 0.0)
C        RT_ASCENS = PI
C     case 2 (ATT_POS_VECT(2) is greater than 0.0)
C        RT_ASCENS = PI - (datan(Y/X))
C     case 3 (ATT_POS_VECT(3) is less than 0.0)
C        RT_ASCENS = PI + (datan(Y/X))
C     enddo
C
C  enddo
C
C  Place right ascension and declination angles in ATT_POS
C
C  RETURN
C
CCCC
	subroutine IC_VECTOR_TO_ANGLES (ATT_POS_VECT, ATT_POS)
C
	implicit none
C
C*  Calling Parameters
C
	real*8	ATT_POS_VECT(3) !Att pos in vector format
	real*8	ATT_POS(3) ! Att pos. converted to 
C*                         ! spin stabilized format (SPIN, RT ASC, DECL)
C
C*  Other variables
C
	real*8	RT_ASCENS   !right ascension angle in radians
	real*8  DECLIN	    !declination angle in radians
	real*8	X,Y	    !absolute values of x and y in ATT_POS_VECT
	real*8	PI	    !pi
	real*8  ONE /1.0D0/ !1.0
C
C*  Begin executable code
C
	PI = 4.*datan(ONE)
C
C*  Calculate the declination angle
C
	DECLIN = dasin(ATT_POS_VECT(3))
C
C*  Calculate the right ascension angle
C
	X = dabs(ATT_POS_VECT(1))
	Y = dabs(ATT_POS_VECT(2))
C
	if (ATT_POS_VECT(1) .eq. 0.0D0) then    !Avoid dividing by zero
C
	   if (ATT_POS_VECT(2) .eq. 0.0D0) then
	      RT_ASCENS = 0  !meaningless
	   else if (ATT_POS_VECT(2) .gt. 0.0D0) then
	      RT_ASCENS = PI/2.0D0
	   else
	      RT_ASCENS = 3.0D0*PI/2.0D0
	   endif
C
	else if (ATT_POS_VECT(1) .gt. 0.0D0) then
C
	   if (ATT_POS_VECT(2) .eq. 0.0D0) then
	      RT_ASCENS = 0.0D0
	   else if (ATT_POS_VECT(2) .gt. 0.0) then
	      RT_ASCENS = datan(Y/X)
	   else
	      RT_ASCENS = 2.0D0*PI - (datan(Y/X))
	   endif
C
	else
C
	   if (ATT_POS_VECT(2) .eq. 0.0D0) then
	      RT_ASCENS = PI
	   else if (ATT_POS_VECT(2) .gt. 0.0D0) then
	      RT_ASCENS = PI - (datan(Y/X))
	   else
	      RT_ASCENS = PI + (datan(Y/X))
	   endif
C
	endif
C
C*  Place right ascension and declination angles in ATT_POS
C
	ATT_POS(2) = RT_ASCENS
	ATT_POS(3) = DECLIN
C
	RETURN
C
	END
