C $Id: ic_get_time_diff.f,v 1.2 1998/07/24 21:54:31 asc Exp $
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CC                                                  |  SYSTEM: ISTP CDHF
CC     MODULE NAME: IC_GET_TIME_DIFF                |  HARDWARE: DEC VAX
CC                                                  |  OPERATING SYSTEM: VMS 5.4
CC                                                  ---------------------------
CC
CC     PURPOSE: TO OBTAIN THE DIFFERENCES BETWEEN THE UTC, UT1, AND A.1 
CC              TIME SYSTEMS
CC
CC     INVOCATION METHOD:  CALL GET_TIME_DIFF(UNIT,JULIAN_DATE,TIME-DIFF,IOERR)
CC   	
CC     CALLING SEQUENCE ARGUMENTS:
CC
CC      NAME     TYPE        USE      DESCRIPTION
CC     --------------------------------------------------------------------------
CC      UNIT      I*4         I       HOLDS FORTRAN LOGICAL UNIT NUMBER FOR THE
CC                                     TIMING COEFFICIENTS FILE
CC      JULIAN_   R*8         I       FULL JULIAN DATE FOR TIME REQUESTED
CC      DATE 
CC   
CC      TIME_     R*8         O       VECTOR WHICH CONTAINS THE TIME SYSTEM 
CC      DIFF(2)                        DIFFERENCES IN SECONDS AT THE REQUEST 
CC                                     TIME.  THE 2 COMPONENTS ARE:
CC                                     TIME_DIFF(1) = A.1-UTC TIME DIFF. 
CC                                                    THIS NUMBER IS POSITIVE
CC                                                    AND HAS THE SENSE OF 
CC                                                    A.1 (MINUS) UTC.
CC                                     TIME_DIFF(2) = UT1-UTC TIME DIFFERENCE
CC                                                    THIS NUMBER CAN BE OF
CC                                                    EITHER SIGN, HAS THE
CC                                                    SENSE OF UT1(MINUS)UTC,
CC                                                    AND SHOULD NEVER EXCEED
CC                                                    0.9 SECONDS.
CC
CC      IOERR     I*4          O       ERROR INDICATOR.
CC
CC     FILE/RECORD REFERENCES:
CC      NAME                    USE      DESCRIPTION
CC     ---------------------------------------------------------------------
CC      TIMING COEFFICIENTS     NONE     
CC
CC     EXTERNAL VARIABLES:
CC 
C      ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:
C       If an error occurs, IERR will be returned as the following:
C	  Error status returned by IC_FETCH_TCC_REC
C
CC      NONE
CC 
CC     ASSUMPTIONS, CONSTRAINTS, LIMITATIONS:
CC 
CC      NONE
CC
CC     EXTERNAL REFERENCES:
CC
CC      IC_FETCH_TCC_REC
CC
CC     DEVELOPMENT HISTORY:
CC     AUTHOR       CHANGE ID    RELEASE     DATE      CHANGE DESCRIPTION
CC    --------------------------------------------------------------------------
CC     C. RAYMOND      N/A       BUILD 3     9/1991    ORIGINAL DESIGN, CODE  
CC     J. LUBELCZYK    N/A       B3          9/1991    ADD ERROR HANDLING
CC     J. LUBELCZYK ICCR #83, CCR #'S 130, 137 11/91    B3 update
CC B. SAMUELSON SPOF PORT    NONE           04/11/94   Change: required to port
CC   (CSC)     (see notes)                               icss routines to SPOF
CC
CC NOTES:
CC
CC    1.  The changes recorded under ID SPOF-PORT are required to make the
CC        ICSS coordinate conversion routines, originally developed under
CC        VAX-VMS 5.4 run on the UNIX-based workstations of the SPOF.  (Sun
CC        SPARCstations and DEC DECstations).  The changes are as follows:
CC           a.  Delete references to ICSS_INC
CC           b.  Define Message texts or files to correspond to the messages
CC               ICSS_SUCCESSFUL, etc. which are embedded in the error handling.
CC           c.  Remove references to the NAG routines F01CRF and F01CKF (matrix
CC               transposition and matrix multiplication routines).
CC    2.  In addition, to successfully run the software packages, copies of the
CC        Solar/Lunar/Planetary (SLP) file and timing coefficients file (TCC)
CC        must be ported onto the SPOF.
CC
CC 
CC     NOTES:
CC
CC     1. THIS UNIT COMPUTES THE TIME DIFFERENCES AND IS DEPENDENT ON THE
CC        TIME COEFFICIENTS FILE.
CC
CC*****************************************************************************
CC ****  START PDL *****
CC 
CC    INTITALIZE IOERR, DATE, MJD
CC
CC    IF ( DATE .NE. OLD_DATE )
CC
CC    THEN
CC   
CC       CALL FETCH_TCC_REC TO GET APPROPRIATE RECORD
CC       IF ERROR GETTING APPROPRIATE RECORD ABORT TO 999
CC
CC       SEARCH FOR APPROPRIATE COEFFICIENT PAIRS
CC
CC    ENDIF
CC
CC    EVALUATE TIME DIFFERENCES
CC
CC    RESET OLD_DATE
CC
CC999 CONTINUE
CC
CC    RETURN
CC
CC ****** END PDL **********
CC*************************************************************************
      SUBROUTINE IC_GET_TIME_DIFF(UNIT,JULIAN_DATE,TIME_DIFF,IOERR)
      IMPLICIT REAL*8 (A-H,O-Z)
      integer*4 unit,jar,ioerr
      real*8 julian_date
      DIMENSION TIME_DIFF(2)
      COMMON /ORTCF/ COEF(5,6), JARG(6), LJD, IA1
      SAVE /ORTCF/
      
C
      DATE = JULIAN_DATE - 2430000.50D00                                       
      MJD=DATE                                  ! INTEGERIZE THE MOD. JUL. 
      IF (MJD .NE. LJD) THEN                                        
         CALL IC_FETCH_TCC_REC(UNIT,MJD,COEF,JARG,JAR,IOERR)
	 IF (IOERR .ne. 0) GOTO 999
         IA1=1                                                             
   12    IF((MJD.GE.JARG(IA1)).AND.(MJD.LT.JARG(IA1+1))) GO TO 50          
   10    IF(MJD.GT.JARG(IA1)) THEN
            IA1 = IA1 + 1
            GO TO 12
         ENDIF
         IF(JAR.EQ.1.AND.IA1.EQ.1) GO TO 50                                
         IA1=IA1-1                                                         
         GO TO 12                                                          
      ENDIF                                                          
   50 CONTINUE                                                          
C
C     COMPUTE ARGUMENT OF INTERPOLATION                                 
C                                                                       
      DATE=DATE-DFLOAT(JARG(IA1))+1.0D0                                 
      TIME_DIFF(1) = 0.0D0                                                      
      TIME_DIFF(1)=COEF(IA1,1)+COEF(IA1,2)*DATE+COEF(IA1,3)*DATE*DATE        
      A1UT1=COEF(IA1,4)+COEF(IA1,5)*DATE+COEF(IA1,6)*DATE*DATE       
      TIME_DIFF(2) = A1UT1 - TIME_DIFF(1)
      LJD = MJD                                                         
999   CONTINUE
      RETURN                                                            
      END                                                               
