C $Id: ic_gci_to_rtn.f,v 1.2 1998/07/24 21:54:30 asc Exp $
	subroutine IC_GCI_TO_RTN (ORB_POS_TIME,spacecraft_pos, 
     1                            TRANSFORM_MATRIX,DERIV_MATRIX,
     2                            VELOCITY_REQ,
     3                            STATUS)
C
	implicit none
C
C*  Calling parameters
C
	integer*4   ORB_POS_TIME(2) !time or orb vector, YYYYDDD, milli of day
	real*8	    TRANSFORM_MATRIX(3,3) !transformation matrix
	real*8      DERIV_MATRIX(3,3) !time derivative of transformation matrix
	integer*4   VELOCITY_REQ !flag to compute derivative matrix
	integer*4   STATUS  !Status of getting the transformation matrix
C
C*  Other variables
C
        integer*4   ii
        real*8      sun_pos_vel(6)
        real*8      spacecraft_pos(3), spin(3)
        real*8      R(3), rl(3), T(3), tl(3), N(3)
C
C*  START EXECUTABLE
C
C     GET THE LOCATION OF THE SUN IN GCI
C
       call ic_pos_vel_of_sun(ORB_POS_TIME,sun_pos_vel,status)
C
C     GET THE SOLAR SPIN VECTOR IN GCI (NEARLY FIXED FOR ACE)
C
       call solar_spin_gci (ORB_POS_TIME, SPIN,STATUS)
C
C     SUBTRACT SUN POSITION FROM SPACECRAFT POSTION
C
       do ii = 1,3
         rl(ii) = spacecraft_pos(ii) - sun_pos_vel(ii)
       enddo
C
C     GET THE RTN axies in gci (j2000)
C
       call UNIT_VEC(rl,R)
       call IC_CROSS_PRODUCT(spin,R,tl)
       call UNIT_VEC(tl,T)
       call IC_CROSS_PRODUCT(R,T,N)
C
C     PUT INTO A MATRIX
C
       TRANSFORM_MATRIX(1,1) = R(1)
       TRANSFORM_MATRIX(1,2) = R(2)
       TRANSFORM_MATRIX(1,3) = R(3)
       TRANSFORM_MATRIX(2,1) = T(1)
       TRANSFORM_MATRIX(2,2) = T(2)
       TRANSFORM_MATRIX(2,3) = T(3)
       TRANSFORM_MATRIX(3,1) = N(1)
       TRANSFORM_MATRIX(3,2) = N(2)
       TRANSFORM_MATRIX(3,3) = N(3)
C
       RETURN
       END











