C $Id: ic_angles_to_vector.f,v 1.2 1998/07/24 21:54:26 asc Exp $
CCCC
C
C  IC_ANGLES_TO_VECTOR - convert angles to unit vector form
C 
C  PURPOSE:  convert the angles of right ascension and declination into
C            unit vector form.
C
C  UNIT TYPE:  SUBROUTINE
C
C  INVOCATION METHOD:  CALL IC_ANGLES_TO_VECTOR (att_pos, 
C                                                att_pos_vect)
C
C  ARGUMENT LIST:
C
C  NAME	                  TYPE   USE  DESCRIPTION
C  ----                   ----   ---  -----------
C  ATT_POS(3)             R*8    I    ATT POSITION (SPIN, RT ASC, DECL)
C  ATT_POS_VECT(3)        R*8    O    ATT_POS CONVERTED TO A VECTOR
C
C  FILE/RECORD REFERENCES:  NONE
C
C  EXTERNAL VARIABLES:  NONE
C
C  EXTERNAL REFERENCES:  NONE
C
C  ABNORMAL TERMINATION CONDITIONS, ERROR MESSAGES:  NONE
C
C  ASSUMPTIONS, CONSTRAINTS, RESTRICTIONS:  NONE
C
C  DEVELOPMENT HISTORY
C
C  AUTHOR	CHANGE ID	RELEASE	  DATE	    DESCRIPTION OF CHANGE
C  ------	---------	-------   ----	    ---------------------
C  J. LUBELCZYK                 B1R1      12/05/90  INITIAL PDL
C  J. LUBELCZYK                 B1R1      12/12/90  CODING
C  J. LUBELCZYK ICCR #83, CCR #'S 130, 137 11/91    B3 update
C
C  NOTES:
C    The magnitude of the position vector is 1
C
CCCC
C
C  PDL:
C
C  Obtain right ascension and declination angles from ATT_POS
C  Project vector using the declination angle onto XY plane
C  Calculate X and Y using projection and right ascension angle
C  Calculate Z using the declination angle
C
C  RETURN
C
CCCC
	subroutine IC_ANGLES_TO_VECTOR (ATT_POS, ATT_POS_VECT)
C
	implicit none
C
C*  Calling Parameters
C
	real*8	ATT_POS(3) ! Att position. Spin stabilized (SPIN, RT ASC, DECL)
	real*8	ATT_POS_VECT(3) !Att pos converted to vector format
C
C*  The right ascension and declination angles are given in radians.
C
C*  Other variables
C
	real*8	RT_ASCENS   !right ascension angle in radians
	real*8  DECLIN	    !declination angle in radians
C
C*  Begin executable code
C
C*  Obtain right ascension and declination angles from ATT_POS
C
	RT_ASCENS = ATT_POS(2)
	DECLIN = ATT_POS(3)
C
C*  Project vector using the declination angle onto XY plane
C*  Calculate X and Y using projection and right ascension angle
C
	ATT_POS_VECT(1) = dcos(DECLIN)*dcos(RT_ASCENS)
	ATT_POS_VECT(2)	= dcos(DECLIN)*dsin(RT_ASCENS)
C
C*  Calculate Z using the declination angle
C
	ATT_POS_VECT(3) = dsin(DECLIN)
C
	RETURN
C
	END
