#include <stdio.h>
#include <string.h>

#include "s3_cmonitor.h"
#include "df.h"

void main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SD_id;
  struct cmonitor testdata;
  int ii,jj,kk,retval;

  if (argc!=2)
    {
      printf("Usage: %s hdf_file\n",argv[0]);
      exit(1);
    }

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL)
    {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);
  if ((SD_id=SDstart(argv[1], DFACC_RDONLY))==FAIL)
    {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
    }

  if( init_rd_s3_cmonitor(hdf_fp, SD_id, "r") <= 0) {
    fprintf(stderr,"No swics s3 cmonitor data\n");
    exit(-1);
  }

  /* read and print data */
  ii=0;
  while((retval=read_s3_cmonitor(&testdata,ii))!=-1) {
    printf("ii=%5d %10u %10u %8d\n", 
	    ii++, testdata.sctime_readout, testdata.sctime_collection, testdata.QAC);
    for (jj=0;jj<CMON_CYC;jj++) {
       for (kk=0;kk<CMON_CSZ;kk++)
            printf("XXX ");
/*          printf("%3u ",testdata.MONITOR[jj][kk]); */
       printf("\n");
    }
  }

  /* all done, close HDF interface */

  close_rd_s3_cmonitor();
  Vend(hdf_fp);
  SDend(SD_id);
  if (Hclose(hdf_fp)==FAIL)
    {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }
  exit(0);
}
    
