/* $Id: swepam_masks.h,v 1.5 1998/12/02 01:47:56 asc Exp $ */

#ifndef MASKS_H
#define MASKS_H

/* the energy steps for the ssti mode.  Not needed for BROWSE/RTSW routines */

                            
  static int ie_ssti[40] = {0,5,10,15,20,25,30,35,40,45,50,55,60,65,70,
	                    75,79,83,87,91,95,99,103,107,111,115,119,123,
			    127,131,135,139,143,147,151,155,159,163,167,171};

/* The polar CEM angles in degrees */
  static float polar[16]={21.25,16.25,11.25,6.25,1.25,-3.75,-8.75,-13.75,
		  -18.75,-23.75,-28.75,-33.75,
                  -38.75,-43.75,-48.75,-53.75};

/* The calibrated ACE G-factors (in units of 10^-6 cm^2 sr.) */

/* old ones derived by John */
/*     static float g6[16]={7.62,7.42,9.23,8.67,8.50,6.01,5.07,1.63,
       0.92,1.59,2.86,4.69,16.67,15.20,20.77,14.88};  
*/
/* new ones derived by Bill */
/* ...But do not include coordinate xform sin_theta_prime/sin_theta factor */
     static float g6[16]={ 7.6208,  6.7408, 12.346,  9.9450,	/*  0- 3 */
			   9.8600, 11.274,  13.503, 11.207,	/*  4- 7 */
			   17.833, 11.235,  20.086,  9.2860,	/*  8-11 */
			   22.10,  21.32,   20.37,  19.27};	/* 12-15 */

/* New ones derived by Bill including the sin(th_p)/sin(th) correction */
/*     static float g6[16]={3.7137,2.4369,3.0560,1.3557,0.41464,0.56270,
			  1.9244,2.6366,5.7912,4.4487,9.8102,5.3904,
			  44.618,39.502,39.593,43.039};  */

/* New ones derived by uk2 from data 
static float g6[16] = {0.25,0.375,1.5,4.2857,6.25,7.5,7.5,7.5,7.5,7.5,7.5,7.5,0,0,0,0}; */

/* For testing with original simulation code use the following 
     rough values 
  float g6[16]={1.48,1.71,1.79,1.75,1.84,1.80,1.89,1.92,
                1.85,1.89,1.96,1.91}; */

/* Energy for each ESA level.
   Final version of code array of values
   Old version built based on approximate steps. 
   Use rough voltage algorithm and fixed energy-to-voltage 
   ratio of 17.1. 0.0246926 is ln(1.025) for 2.5% stepping.
   15.29 is voltage for step 0.
   121 is highest start allowed.

   for (k=0; k < 200; ++k) {
      energy[k]=17.1*15.295*exp((float)k * 0.0246926);
   } */

     static float g_fac[12] = {17.2,17.17,17.2,17.23,17.27,17.38,17.41,
			       17.41,17.44,17.5,17.5,17.5};
                               

/* Correction to energy levels because of count suppression observered 
   in the approx. 500 eV to 1 keV energy range 
   Only CEMs 5 through 11 are modified.  These parameters were obtained
   by fitting y = A0 * exp(-(x-A1)^2/A2) + 1.0 to data > Jan 10, 1998, 
   for each CEM > 4 (0-11 nomenclature). */
     static float A0[7] = { 122.5784, 117.0021, 82.7003, 98.5474, 
			     42.0714,  -3.3461, 95.1852 };
     static float A1[7] = {  0.4466, 0.4384, 0.4494, 0.4255, 
			     0.3742, 0.4209, 0.4618 };
     static float A2[7] = { 0.0227, 0.0262, 0.0075, 0.0040,
			    0.0207, 0.0035, 0.0044 };

     static int imask[1152] = { 
            1,1,1,1,1,1,2,2,2,2,2,
	    2,3,3,3,4,4,7,7,8,8,8,9,9,9,9,10,10,10,11,11,12,12,1,1,1,2,2,2,2,
	    3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,7,7,
	    7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,12,12,1,1,2,2,2,
	    2,3,3,3,3,4,4,4,4,5,5,6,6,7,7,7,7,8,8,8,8,9,9,9,10,10,11,11,1,1,1,
	    2,2,2,2,2,2,2,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5,5,6,6,6,
	    6,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,9,9,9,10,10,10,11,11,12,12,12,1,1,
	    2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,8,8,8,9,9,10,1,
	    1,1,2,2,2,2,2,3,3,3,3,3,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,
	    7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,10,10,10,10,11,11,11,11,
	    12,2,2,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,8,
	    8,9,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,6,6,6,
	    6,6,6,7,7,7,7,7,7,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,10,10,10,
	    11,11,2,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,
	    8,8,8,1,1,1,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,5,
	    5,6,6,6,6,6,6,7,7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,10,10,10,10,
	    10,10,2,2,3,3,3,3,4,4,4,4,4,4,5,5,5,5,5,5,6,6,6,6,6,6,6,7,7,7,7,7,
	    8,8,9,1,1,1,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,4,4,4,4,4,5,5,5,5,5,5,6,
	    6,6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,10,10,
	    10,10,1,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,5,6,6,6,6,6,7,7,7,7,7,8,8,8,
	    8,9,9,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,5,5,5,
	    6,6,6,6,6,7,7,7,7,7,7,7,7,8,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,
	    11,11,11,1,2,2,3,3,3,3,4,4,4,5,5,5,6,6,6,7,7,7,7,7,8,8,8,8,8,9,9,
	    9,9,10,10,10,1,1,1,1,2,2,2,2,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,5,5,
	    5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,7,7,8,8,8,8,8,9,9,9,9,10,10,10,11,
	    11,11,11,12,12,12,12,1,1,1,1,2,2,2,3,3,4,7,7,7,7,8,8,8,8,9,9,9,9,
	    9,10,10,10,10,10,11,11,11,12,12,1,1,1,2,2,2,2,3,3,3,3,3,3,4,4,4,4,
	    4,4,4,4,5,5,5,5,5,5,5,5,5,5,6,6,6,6,6,6,6,6,6,6,7,7,7,7,8,8,8,8,9,
	    9,9,9,9,10,10,10,11,11,11,12,12,12,1,1,1,1,2,2,2,3,3,7,7,8,8,8,9,
	    9,9,9,9,10,10,10,10,10,10,11,11,11,11,12,12,12,12,1,1,1,1,1,1,2,2,
	    2,2,2,3,3,3,3,3,4,4,4,4,4,5,5,5,5,5,6,6,6,6,6,6,7,7,7,7,8,8,8,8,8,
	    8,8,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,11,12,12,12,1,1,1,
	    1,1,2,2,2,8,8,8,8,9,9,9,9,9,10,10,10,10,10,10,11,11,11,11,11,11,
	    12,12,12,12,1,1,1,1,1,2,2,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,7,7,7,
	    7,7,7,7,8,8,8,8,8,8,9,9,9,9,9,9,10,10,10,10,10,10,10,11,11,11,11,
	    11,11,11,12,12,12,12,12,12,1,1,1,1,1,2,2,9,9,9,9,10,10,10,10,10,
	    10,11,11,11,11,11,12,12,12,12,12,12,12,12,12,12,12,1,1,1,1,1,1,1,
	    1,1,2,2,2,2,2,2,2,2,2,3,3,3,3,3,8,8,8,8,8,8,8,8,9,9,9,9,9,9,9,9,9,
	    10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,11,11,12,12,12,
	    12 };
	    
     static int jmask[1152] = { 
            -7,-4,-2,2,4,7,-6,-3,
	    -1,1,3,6,-4,2,7,-3,3,-1,3,-6,0,8,-4,-1,1,3,-5,0,5,-1,1,-2,2,-11,0,
	    11,-13,-9,9,13,-16,-11,7,-2,4,11,15,-19,-14,-9,-5,0,8,13,19,-26,
	    -18,-10,-3,1,9,17,25,-26,-18,-11,-5,2,10,18,26,-15,-9,-5,7,12,17,
	    -14,-10,-3,4,14,-12,-8,7,12,-10,-2,2,10,-10,-4,4,7,-6,6,-3,1,-7,
	    -2,0,4,-6,-1,1,6,-9,-2,2,9,-10,7,-5,6,-8,-3,2,8,-10,-2,3,10,-7,-1,
	    4,0,5,-3,2,-8,6,12,-16,-11,-4,2,7,11,16,-21,-15,-10,-3,3,10,15,
	    -25,-19,-14,-5,5,14,20,27,-28,-22,-16,-4,0,13,19,25,-26,-19,-12,1,
	    13,19,25,-28,-21,-14,15,22,-16,-5,0,6,16,-12,-4,1,7,13,-10,-5,11,
	    -9,9,-6,0,6,-6,6,-2,3,-9,-3,0,4,11,-13,-4,1,9,20,-21,-10,2,12,24,
	    -16,-6,3,13,26,-9,-1,5,-6,1,8,0,5,1,-13,0,13,-14,-8,9,14,21,-28,
	    -21,-14,-5,-1,2,7,17,24,-25,-19,-8,5,14,27,-28,-15,-5,7,18,-29,
	    -23,-10,-2,8,19,-22,-15,-5,2,9,15,22,29,-26,-29,-12,-2,4,13,19,26,
	    -17,-10,-5,11,-12,-6,7,13,-9,-3,3,9,0,-3,2,-15,-8,4,10,16,-20,-9,
	    -2,0,5,14,25,-23,-11,-1,3,13,24,-22,-12,-2,8,20,-19,-9,1,11,22,-2,
	    4,2,-19,-12,-6,0,6,13,-24,-17,-10,8,14,21,27,-29,-22,-1,23,-27,
	    -14,-5,2,9,19,-29,-17,-6,8,18,-28,-17,-7,3,14,26,-24,-14,-4,6,17,
	    28,-29,-22,-15,-8,10,16,23,29,-27,-19,-11,-4,8,14,21,28,-14,-7,0,
	    6,13,-4,3,-1,-24,-10,9,21,-21,-11,-1,4,16,27,-25,-15,-6,0,5,12,23,
	    -28,-16,-7,2,11,19,28,-26,-14,-3,9,21,-15,-1,13,-27,-19,-11,0,9,
	    16,24,-29,-22,-15,-8,6,15,23,-17,-3,2,14,28,-26,-16,-6,10,22,-20,
	    -9,-2,2,8,17,26,-22,-11,-2,6,14,23,-20,-9,3,15,27,-29,-22,-8,6,20,
	    26,-27,-21,-14,-7,0,7,14,21,29,-25,-16,-6,3,12,22,-2,5,-12,-5,2,8,
	    -25,-13,-4,3,14,28,-27,-18,-7,0,9,20,-23,-12,-5,0,6,14,24,-24,-9,
	    -1,4,13,-6,2,0,-29,-21,-14,-7,0,7,14,21,-23,-16,-9,12,19,26,-26,
	    -19,16,23,-19,-8,-1,8,21,-22,-12,-3,4,14,27,-29,-17,-8,-2,3,10,19,
	    -18,-13,-5,1,8,18,23,29,-24,-18,-12,8,14,21,28,-26,-19,-13,-7,6,
	    12,19,26,-11,-4,3,10,0,-4,2,8,-6,-1,4,9,-14,-4,3,12,-24,-12,0,10,
	    22,-17,-11,-5,6,12,-8,-2,0,4,11,-10,-5,0,5,-6,1,-12,-6,6,12,-23,
	    -16,-10,14,20,26,-29,-23,-17,-11,2,15,21,27,-26,-20,-8,0,7,18,24,
	    -18,-6,4,16,28,-29,-23,0,18,24,-26,-20,-14,2,7,16,21,27,-27,-21,
	    -15,10,15,20,26,-17,-11,-1,6,11,16,-9,-3,2,8,-7,0,6,0,-3,3,-5,-1,
	    2,6,-7,-2,3,-4,2,8,-7,-1,4,-7,-3,1,5,9,-5,-2,0,2,5,-4,-1,1,3,-2,0,
	    4,-10,-5,5,10,-17,-12,-7,0,7,12,17,-20,-15,-10,11,16,22,-24,-17,
	    -12,8,13,18,25,-28,-22,-16,-10,14,20,26,-29,-20,-13,10,16,22,-23,
	    -16,-11,14,20,27,-19,-14,-9,10,16,-13,-8,7,12,-11,-6,9,-8,-3,2,7,
	    -7,-2,0,4,-4,0,3,6,-4,1,5,-1,3,1,-6,-1,1,6,-8,-4,0,4,-6,-3,0,2,5,
	    -5,-2,1,3,6,-4,-1,2,-2,0,-12,-8,10,-11,-7,9,13,-14,-9,-5,7,11,16,
	    -19,-13,-8,-3,5,10,15,21,-29,-24,-18,-12,-6,0,6,12,18,24,-26,-20,
	    -14,-8,-2,3,9,15,21,27,-16,-11,11,16,-13,-1,9,14,-14,-10,-1,8,12,
	    -12,-8,10,-7,5,8,-6,3,6,-4,-1,1,5,-3,0,3,-2,2,-2,0,-5,-1,2,-6,-4,
	    1,3,5,-5,-2,0,2,4,6,-4,-2,0,2,-3,-1,1,3,-10,-7,0,2,8,11,-12,-9,-6,
	    6,10,-10,-5,5,9,13,-12,-6,0,6,12,-29,-17,-5,7,19,-15,-8,-1,3,9,15,
	    -12,-7,5,10,-11,-8,-3,4,6,9,12,-12,-9,-2,7,10,-10,-7,-3,-1,1,8,9,
	    -9,-5,4,6,8,-7,-5,5,-4,-2,0,2,4,-3,1,5,-4,-2,0,2,-4,-1,1,3,5,-5,
	    -3,-1,0,2,3,-6,-4,-2,0,2,4,-3,-1,1,4,-9,-5,1,5,7,-8,-5,-1,3,7,10,
	    -7,-4,-2,0,2,4,7,9,-6,-3,0,3,6,-8,-5,-2,0,3,6,9,-9,-6,4,6,8,10,
	    -10,-8,-6,-2,7,9,-9,-7,-4,-2,1,5,7,-8,-3,-1,1,3,6,8,-7,-5,-2,0,2,
	    6,-5,-3,-1,1,3,-1,1,-4,-2,0,2,-5,-3,-1,1,3,5,-4,-2,0,2,4,-5,-4,-3,
	    -2,-1,0,1,2,3,4,5,-7,-4,-2,0,2,4,5,6,8,-6,-4,-3,-2,0,2,3,4,6,-4,
	    -2,0,2,4,-7,-5,-3,-1,0,2,4,6,-7,-5,-3,-1,1,3,4,5,7,-8,-6,-4,-2,0,
	    2,4,6,8,-8,-6,-5,-3,-1,1,3,5,6,7,-7,-6,6,7 };

#endif
