/* $Id: swepam_i.h,v 1.6 2005/06/17 17:55:07 ad Exp $  */
/* Structure definition for SWI moments */

#ifndef	SWEPAM_I_H
#define	SWEPAM_I_H 1

#include "hdfi.h"
#include "swepam.h"

#include "swepam_dcali.h"
#include "swepam_dengi.h"
#include "swepam_dhskpi.h"
#include "swepam_dloadi.h"
#include "swepam_drawi.h"
#include "swepam_dssti.h"
#include "swepam_dsti.h"
#include "swepam_dsti2.h"
#include "swepam_dswi.h"
#include "swepam_bri.h"

#define DATA_SIZE_RTSW 1344 /* # of bytes in 1 RTSW mode */
#define DATA_SIZE_SWI  4352 /* # of bytes in 1 SWI mode */
#define I_SPEC 5            /* # of spectral segments */
#define I_ANGLE 33          /* # of pixels in RTSW data set */
#define I_ANGLE_TOT 96      /* # of pixels in SWI data set */
#define I_ESTEP 8           /* # of E steps per angle/seg */
#define I_ETOT 40           /* total # of energy steps */
#define I_COUNT_RTSW 1320   /* # of counts in 1 RTSW mode */
#define I_COUNT_SWI 3840    /* # of counts in 1 SWI mode */
#define I_MFHDR   4         /* Major frame header */
#define I_RTMFHDR 4         /* Real Time Major frame header */
#define I_SSSHDR  5         /* Spectral Segment Header */
#define I_DSHDR  2          /* Data Set Header */
#define I_CEM 12          /* # of CEMs used in SWI mode */
#define I_PHI 61          /* # of phi angles */

struct swepam_i {
  uint16   year;	/* Full four-digit year, eg, 1998	*/
  uint16   yday;	/* Day of year, 1-365 (or -366)		*/
  uint8    mon;		/* Month, 1-12				*/
  uint8    mday;	/* Day of month, 1-31			*/
  uint8    hour;	/* Hour, 0-23				*/
  uint8    min;		/* Minutes past the hour, 0-59		*/
  uint8    sec;		/* Seconds, 0-59			*/
  uint32   sct;		/* Spacecraft clock			*/

  float32  np;		/* Proton density, cm-3			*/
  float32  na;		/* Alpha density, cm-3			*/
  float32  np_bound;	/* Proton density, bounded		*/
  float32  na_bound;	/* Alpha density, bounded		*/

  float32  he_ratio;	/* Na / Np				*/

  float32  vp;		/* Proton speed, km/s			*/

  /* PROTON temperatures */
  float32  Tp[3][3];	   /* Proton temperature tensor		 */
  float32  Tp_bound[3][3]; /* Proton temperature tensor, bounded */
  float32  Tp_rr_bound;	   /* Proton radial temperature, bounded */

  /* ALPHA temperatures */
  float32  Ta[3][3];	   /* Alpha temperature tensor		*/
  float32  Ta_bound[3][3]; /* Alpha temperature tensor, bounded */
  float32  Ta_rr_bound;	   /* Alpha radial temperature, bounded	*/

  float32  Tp_para;	/* Proton parallel temp, diagonalized coords */
  float32  Tp_perp[2];	/* Proton perpendicular temp, diagonalized coords   */

  float32  Tp_para_bound;    /*  Proton parallel temp, diagonalized, bounded */
  float32  Tp_perp_bound[2]; /*  Proton perp. temp, diagonalized, bounded */

  /* PROTON temperatures, in magnetic field (B) */
  float32  Tp_para_B;	        /* Proton temp, parallel to magnetic field */
  float32  Tp_perp_B[2];        /* Proton temp, perp.    to magnetic field */
  float32  Tp_para_B_bound;	/* Proton temp, parallel to B, bounded     */
  float32  Tp_perp_B_bound[2];  /* Proton temp, perp.    to B, bounded     */

  /* ALPHA temperatures, in magnetic field (B) */
  float32  Ta_para_B;	        /* Alpha temp, parallel to magnetic field */
  float32  Ta_perp_B[2];        /* Alpha temp, perp.    to magnetic field */
  float32  Ta_para_B_bound;	/* Alpha temp, parallel to B, bounded     */
  float32  Ta_perp_B_bound[2];  /* Alpha temp, perp.    to B, bounded     */

  float32  Tp_theta;	/* Proton temperature theta component, radians */
  float32  Tp_phi;	/* Proton temperature phi   component, radians */

  /* Engineering and housekeeping values */
  uint32   limit;	/* Azimuthal sector number (?) */
  uint32   lmx;		/* ESA level with max count rate, 0-199	*/
  float32  spin;	/* Spacecraft spin rate			*/
  uint32   flag3d;	/* bitmask flagging "suspect" data	*/
  float32  rtsw_counts;
  float32  rtsw_pc;
  float32  total_counts;
  int32    cem_max;	/* CEM holding max counts		*/
  uint8    imax[I_SPEC];
  uint8    jmax[I_SPEC];
  uint8    kmax[I_SPEC];

  uint8	   peak_p;	/* Proton peak, index into dist_fun_1d	*/
  uint8    break_p_a;	/* Break between protons and alphas	*/
  uint8    peak_a;	/* Alpha peak, index into dist_fun_1d	*/
  float32  vel_p_rtn[3]; /* RTN components of proton speeds	*/
  float32  vel_a_rtn[3]; /* RTN components of alpha speeds	*/

  float32  vel_p_gse[3]; /* GSE components of proton speeds	*/
  float32  vel_a_gse[3]; /* GSE components of alpha speeds	*/

  float32  sc_pos_gse[3]; /* Spacecraft position at this time, GSE coords */

  /* Dist Fun */
  float32  dist_fun_1d[I_ETOT];	/* 1-D Distribution function		*/
  float32  flux_1d[I_ETOT];	/* 1-D corrected flux		*/
  uint32   counts[I_ETOT];	/* uncorrected counts, over phi & theta	*/
/*  uint32   counts_per_cem[12][I_ETOT]; */		/* ESM ESM ESM */
/*  uint16   counts_xxx[12][72][I_ETOT]; */		/* ESM ESM ESM */
/*  float32  phase; */				/* ESM ESM ESM */

  /* MAG (obtained from the nearest point) */
  float32  Bmag;		/* B, absolute magnitude	*/
  float32  Brtn[3];		/* B components, RTN		*/
  float32  Bgse[3];		/* B components, GSE		*/
  float32  delta;		/* B latitude, degrees		*/
  float32  lambda;		/* B longitude, degrees		*/
  float32  dBrms;		/* B RMS fluctuation over 16s avg */
};

#endif	/* SWEPAM_I_H */

