/* $Id: L1CrisEventBlockState.h,v 1.3 2010/01/14 22:06:47 ad Exp $ */

/* $Source: /users/asc/aceprog/include/RCS/L1CrisEventBlockState.h,v $ */
/* $Author: ad $ */
/* $Date: 2010/01/14 22:06:47 $ */
/* $Revision: 1.3 $ */

#define NAGE        MAX_CRIS_EVT_AGE
#define NBLOCK      MAX_CRIS_EVT_AGE + SIZE_CRIS_CYCLE_QUEUE
#define NMNF        NUM_CRIS_MNFS_PER_CYCLE
#define NTELEMETRY  NUM_CRIS_TELEMETRY_BYTES

#define NARRAY      NTELEMETRY*NMNF
#define NEVENT      NMNF*MAX_NUM_CRIS_EVENTS_PER_MNF

struct L1CrisEventBlock {
   uint32 ClockCycle;
   uint32 CycleNumber;
   uint32 ResetNumber;
   uint32 NumberVotes[NAGE];
   uint16 NumberEventBytes;
   uint16 NumberEvents[NAGE];
   uint16 NumberEventsTotal;
   uint16 EventIndex[NEVENT];
   uint8  EventArray[NARRAY];
   uint8  EventAge[NEVENT];
   uint8  EventMnf[NEVENT];
   uint8  EventLocation[NEVENT];
   uint8  EventNullStat[NEVENT];
   uint8  NumberBorrowedBytes;
};


struct L1CrisEventBlockState {
   uint32 NumberEventBlocks;
   struct L1CrisEventBlock block[NBLOCK];
   uint32 NumberEventCycles;
};

#undef NAGE
#undef NBLOCK
#undef NMNF
#undef NTELEMETRY

#undef NARRAY
#undef NEVENT
