#! /bin/sh
#

srcdir=.


# Determine whether the szip library is available
USE_COMP_SZIP="no"
SZIP_HAS_ENCODER="no"

TESTNAME=hrepack
EXIT_SUCCESS=0
EXIT_FAILURE=1

HREPACK='./hrepack'               # The tool name
HREPACK_BIN="${TESTS_ENVIRONMENT} "`pwd`/$HREPACK    # The path of the tool binary

HDIFF='../hdiff/hdiff'         # The hdiff tool name 
HDIFF_BIN="${TESTS_ENVIRONMENT} "`pwd`/$HDIFF        # The path of the hdiff tool binary

HDP='../dumper/hdp'               # The dumper tool name
HDP_BIN="${TESTS_ENVIRONMENT} "`pwd`/$HDP        # The path of the tool binary

RM='rm -f'
DIFF=diff
CMP='cmp -s'
nerrors=0       # number of errors (0)
quitonerr=0     # quit on error (not)
noclean=0       # no cleaning temp. files (yes)
only=""         # dumper sub-command to test only
except=""       # dumper sub-command to test not

# Print a $* message left justified in a field of 70 characters
#
MESSAGE() {
   SPACES="                                                               "
   echo "$* $SPACES" | cut -c1-70 | tr -d '\012'
}

# Print a line-line message left justified in a field of 70 characters
# beginning with the word "Testing".
#
TESTING() {
    MESSAGE "Testing $*"
}

# Print a line-line message left justified in a field of 70 characters
# beginning with the word "Verifying".
#
VERIFY() {
    MESSAGE "Verifying $*"
}

# Print a message that a test has been skipped (because a required filter
# was unavailable)
SKIP() {
    TESTING $HREPACK $@
    echo " -SKIP-"
}

# Call the hdiff tool
#
DIFFTEST() 
{
    VERIFY hdiff output $@
    (
        $RUNSERIAL $HDIFF_BIN  "$@" 
    )
    RET=$?
    if [ $RET != 0 ] ; then
         echo "*FAILED*"
         nerrors="`expr $nerrors + 1`"
    else
         echo " PASSED"
    fi
        
}

# Call hrepack
#


# call TOOLTEST_MAIN and delete $output file
TOOLTEST() 
{
    infile=$2
    outfile=out-$1.$2
    shift
    shift

    # Run test.
    TESTING $HREPACK $@
    (
        $RUNSERIAL $HREPACK_BIN -v -i $infile -o $outfile "$@"
    )
    RET=$?
    if [ $RET != 0 ] ; then
        echo "*FAILED*"
        nerrors="`expr $nerrors + 1`"
    else
        echo " PASSED"
        DIFFTEST $infile $outfile
    fi
    rm -f $outfile
}

# ADD_HELP_TEST
TOOLTEST_HELP() {

    expect="$1"
    actual="`basename $1 .txt`.out"
    actual_err="`basename $1 .txt`.err"
    shift

    # Run test.
    TESTING $HREPACK $@
    (
      $RUNSERIAL $HREPACK_BIN "$@"
    ) >$actual 2>$actual_err
    cat $actual_err >> $actual

    if [ ! -f $expect ]; then
    # Create the expect data file if it doesn't yet exist.
      echo " CREATED"
      cp $actual $expect-CREATED
    elif cmp -s $expect $actual; then
      echo " PASSED"
    else
      echo "*FAILED*"
      echo "    Expected output (*.txt) differs from actual output (*.out)"
      nerrors="`expr $nerrors + 1`"
    fi
    
    # Clean up output file
    if test -z "$HDF_NOCLEANUP"; then
     rm -f $actual $actual_err
    fi

}

# This is different from $srcdir/../../bin/output_filter.sh
STDOUT_FILTER() {
    result_file=$1
    tmp_file=/tmp/htest_tmp_$$
    # Filter name of files.
    cp $result_file $tmp_file
    sed -e '/^Opening file/d' -e '/^Making file/d' \
    < $tmp_file > $result_file
    # cleanup
    rm -f $tmp_file
}

#
# The tests
# We use the files generated by test_hrepack
# Each run generates "<file>.out.hdf" and the tool hdiff is used to
# compare the input and output files
#
# the tests are the same as the program hrepacktst, but run from the CLI 
#

##############################################################################
###			  T H E   T E S T S                               
##############################################################################
# prepare for test

#TOOLTEST_HELP hrepack-help.txt -h

   #-------------------------------------------------------------------------
   # test1:  
   # HUFF
   #-------------------------------------------------------------------------
   #
    TOOLTEST HUFF hrepacktst1.hdf -t "dset7:HUFF 1" -c dset7:10x8x6
    
#    if ( sds_verifiy_comp("dset7",COMP_CODE_SKPHUFF, 1) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset7",HDF_CHUNK|HDF_COMP,3,in_chunk_lengths) == -1) 
#        goto out;
    
    
   #-------------------------------------------------------------------------
   # test2: 
   # RLE
   #-------------------------------------------------------------------------
   #
    TOOLTEST RLE hrepacktst1.hdf -t dset4:RLE -c dset4:10x8
    
#    if ( sds_verifiy_comp("dset4",COMP_CODE_RLE, 0) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset4",HDF_CHUNK|HDF_COMP,2,in_chunk_lengths) == -1) 
#        goto out;
    
   #-------------------------------------------------------------------------
   # test3:  
   # SDS SELECTED with GZIP, chunking SELECTED
   #-------------------------------------------------------------------------
   #
    TOOLTEST SDSGZIP_CHUNK hrepacktst1.hdf -t "dset4:GZIP 6" -c dset4:10x8
    
#    if ( sds_verifiy_comp("dset4",COMP_CODE_DEFLATE, 6) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset4",HDF_CHUNK|HDF_COMP,2,in_chunk_lengths) == -1) 
#        goto out;
    
    
   #-------------------------------------------------------------------------
   # test4:  
   # SDS SELECTED with SZIP, chunking SELECTED
   #-------------------------------------------------------------------------
   #
    if test $SZIP_HAS_ENCODER != "yes"; then
        SKIP SDSSZIP_CHUNK hrepacktst1.hdf -c dset4:10x8
    else
        TOOLTEST SDSSZIP_CHUNK hrepacktst1.hdf -t "dset4:SZIP 8,EC" -c dset4:10x8
    fi
#if defined (H4_HAVE_LIBSZ)
#    if (SZ_encoder_enabled()) 
#    {
#        
#        if ( sds_verifiy_comp("dset4",COMP_CODE_SZIP, 0) == -1) 
#            goto out;
#        if ( sds_verifiy_chunk("dset4",HDF_CHUNK|HDF_COMP,2,in_chunk_lengths) == -1) 
#            goto out;
    
   #-------------------------------------------------------------------------
   # test4:  
   # SDS SELECTED with NONE, chunking SELECTED NONE
   #-------------------------------------------------------------------------
   #
    TOOLTEST SDSNONE_CHUNKNONE hrepacktst1.hdf -t dset_chunk_comp:NONE -t dset_chunk:NONE -c dset_chunk_comp:NONE -c dset_chunk:NONE
    
#    if ( sds_verifiy_comp("dset_chunk_comp",COMP_CODE_NONE, 0) == -1) 
#        goto out;
#    if ( sds_verifiy_comp("dset_chunk",COMP_CODE_NONE, 0) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset_chunk_comp",HDF_NONE,0,0) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset_chunk",HDF_NONE,0,0) == -1) 
#        goto out;
    
    
   #-------------------------------------------------------------------------
   # test5:
   # SDS SELECTED with all types, chunking SELECTED
   #-------------------------------------------------------------------------
   #
    if test $SZIP_HAS_ENCODER != "yes"; then
        TOOLTEST SDS_CHUNK hrepacktst1.hdf -t "dset4:GZIP 9" -t dset5:RLE -t "dset6:HUFF 2" -c dset4:10x8 -c dset5:10x8 -c dset6:10x8
    else
        TOOLTEST SDS_CHUNK hrepacktst1.hdf -t "dset4:GZIP 9" -t dset5:RLE -t "dset6:HUFF 2" -t "dset7:SZIP 8,EC" -c dset4:10x8 -c dset5:10x8 -c dset6:10x8
    fi
    
#    if ( sds_verifiy_comp("dset4",COMP_CODE_DEFLATE, 9) == -1) 
#        goto out;
#    if ( sds_verifiy_comp("dset5",COMP_CODE_RLE, 0) == -1) 
#        goto out;
#    if ( sds_verifiy_comp("dset6",COMP_CODE_SKPHUFF, 2) == -1) 
#        goto out;
#if defined (H4_HAVE_LIBSZ)
#    if (SZ_encoder_enabled()) {
#        if ( sds_verifiy_comp("dset7",COMP_CODE_SZIP, 0) == -1) 
#            goto out;
#    }
#endif
#    if ( sds_verifiy_chunk("dset4",HDF_CHUNK|HDF_COMP,2,in_chunk_lengths) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset5",HDF_CHUNK|HDF_COMP,2,in_chunk_lengths) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset6",HDF_CHUNK|HDF_COMP,2,in_chunk_lengths) == -1) 
#        goto out;
    
    
   #-------------------------------------------------------------------------
   # test6: 
   # SDS SELECTED with all types, no chunking
   #-------------------------------------------------------------------------
   #
    if test $SZIP_HAS_ENCODER != "yes"; then
        TOOLTEST SEL_NOCHUNK hrepacktst1.hdf -t "dset4:GZIP 9" -t dset5:RLE -t "dset6:HUFF 2"
    else
        TOOLTEST SEL_NOCHUNK hrepacktst1.hdf -t "dset4:GZIP 9" -t dset5:RLE -t "dset6:HUFF 2" -t "dset7:SZIP 4,EC"
    fi
    
#    if ( sds_verifiy_comp("dset4",COMP_CODE_DEFLATE, 9) == -1) 
#        goto out;
#    if ( sds_verifiy_comp("dset5",COMP_CODE_RLE, 0) == -1) 
#        goto out;
#    if ( sds_verifiy_comp("dset6",COMP_CODE_SKPHUFF, 2) == -1) 
#        goto out;
#if defined (H4_HAVE_LIBSZ)
#    if (SZ_encoder_enabled()) {
#        if ( sds_verifiy_comp("dset7",COMP_CODE_SZIP, 0) == -1) 
#            goto out;
#    }
#endif
    
    
   #-------------------------------------------------------------------------
   # test7:  
   # compressing SDS ALL, chunking SELECTED NONE
   #-------------------------------------------------------------------------
   #
    TOOLTEST COMPALL_CHUNKNONE hrepacktst1.hdf -t "*:GZIP 1" -c dset_chunk_comp:NONE -c dset_chunk:NONE
    
#    if ( sds_verifiy_comp_all(COMP_CODE_DEFLATE, 1) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset_chunk_comp",HDF_NONE,0,0) == -1) 
#        goto out;
#    if ( sds_verifiy_chunk("dset_chunk",HDF_NONE,0,0) == -1) 
#        goto out;
    
   #-------------------------------------------------------------------------
   # test8:
   # no compressing, chunking ALL
   #-------------------------------------------------------------------------
   #
    TOOLTEST NOCOMP_CHUNKALL hrepacktst1.hdf -c *:10x8
    
#    if ( sds_verifiy_chunk_all(HDF_CHUNK,2,in_chunk_lengths,"dset7") == -1) 
#        goto out;
    
    
   #-------------------------------------------------------------------------
   # test9: 
   # compressing SDS ALL with GZIP
   #-------------------------------------------------------------------------
   #
    TOOLTEST GZIP hrepacktst1.hdf -t "*:GZIP 1"
    
#    if ( sds_verifiy_comp_all(COMP_CODE_DEFLATE, 1) == -1) 
#        goto out;
    
    
   #-------------------------------------------------------------------------
   # test10: 
   # repack a big file using hyperslab reading/writing
   #-------------------------------------------------------------------------
   #
    TOOLTEST HYPERSLAB hrepacktst2.hdf
    
   #-------------------------------------------------------------------------
   # test11: 
   # repack a file with vgroups
   #-------------------------------------------------------------------------
   #
    TOOLTEST VGROUP hrepacktst3.hdf


if test $nerrors -eq 0 ; then
    echo "All $TESTNAME tests passed."
    exit $EXIT_SUCCESS
else
    echo "$TESTNAME tests failed with $nerrors errors."
    exit $EXIT_FAILURE
fi

