#! /bin/sh
# Tests for the Fortran interfaces

srcdir=.
TEST_FORTRAN_NETCDF="yes"
CMP='cmp -s'
DIFF='diff -c'

nerrors=0
verbose=yes

# Print message with formats according to message level ($1)
MESG() {
  level=$1
  shift
  case $level in
    0)
      echo '============================='
      echo $*
      echo '============================='
      ;;
    3)
      echo '-----------------------------'
      echo $*
      echo '-----------------------------'
      ;;
    6)
      echo "*** $* ***"
      ;;
    *)
      echo "MESG(): Unknown level ($level)"
      exit 1
      ;;
  esac
}


# Report the result and exit
FINISH()
{
    if [ $nerrors -eq 0 ]
    then
        MESG 0 "All Fortran interfaces tests passed"
    else
        MESG 0 "Fortran interfaces tests failed: $nerrors"
    fi
    exit $nerrors
}

# Print a line-line message left justified in a field of 70 characters
# beginning with the word "Testing".
#
TESTING() {
   SPACES="                                                               "
   echo "Testing $* $SPACES" | cut -c1-70 | tr -d '\012'
}

# Run a test and print PASS or *FAIL*.  If a test fails then increment
# the `nerrors' global variable
#
RUN() {
   # Run test.

   MESG 0 "HDF-SD Fortran interfaces tests"
   ${TESTS_ENVIRONMENT} ./hdftest
   RET=$?
   if [ $RET -eq 1 ]; then
      echo "*FAILED*"
      nerrors="`expr $nerrors + 1`"
   fi

   ${TESTS_ENVIRONMENT} ./hdftest1
   RET=$?
   if [ $RET -eq 1 ]; then
      echo "*FAILED*"
      nerrors="`expr $nerrors + 1`"
   fi

   if test $TEST_FORTRAN_NETCDF = "yes"; then
      MESG 0 "HDF-NetCDF Fortran interfaces tests"
      ${TESTS_ENVIRONMENT} ./ftest
      RET=$?
      if [ $RET -eq 1 ]; then
         echo "*FAILED*"
         nerrors="`expr $nerrors + 1`"
      fi
   else
      MESG 0 "HDF-NetCDF Fortran interfaces are disabled when library is built with --disable-netcdf"
   fi

   MESG 0 "SZIP Fortran interfaces tests"
   ${TESTS_ENVIRONMENT} ./tszip
   RET=$?
   if [ $RET -eq 1 ]; then
      echo "*FAILED*"
      nerrors="`expr $nerrors + 1`"
   fi
}

##############################################################################
###                       T H E   T E S T S                                ###
##############################################################################

# Print a beginning banner
MESG 0 "Running Fortran interfaces tests"

# compare output
RUN

# End of test, return exit code
FINISH
    
