#! /bin/sh
#
# Copyright by The HDF Group.
# Copyright by the Board of Trustees of the University of Illinois.
# All rights reserved.
#
# This file is part of HDF Java Products. The full HDF Java copyright
# notice, including terms governing use, modification, and redistribution,
# is contained in the file, COPYING.  COPYING can be found at the root of
# the source code distribution tree. You can also access it online  at
# http://www.hdfgroup.org/products/licenses.html.  If you do not have
# access to the file, you may request a copy from help@hdfgroup.org.
#

top_builddir=../..
top_srcdir=../..
srcdir=.

TESTNAME=JUnitInterface
EXIT_SUCCESS=0
EXIT_FAILURE=1

# Set up default variable values if not supplied by the user.
RM='rm -rf'
CMP='cmp'
DIFF='diff -c'
CP='cp'
DIRNAME='dirname'
LS='ls'
AWK='awk'

nerrors=0
verbose=yes

# setup my machine information.
myos=`uname -s`

# where the libs exist
HDFLIB_HOME="$top_srcdir/java/lib"
BLDLIBDIR="$top_builddir/java/lib"
BLDDIR="."
HDFTEST_HOME="$top_srcdir/java/test"
JARFILE=jarhdf-4.2.13.jar
TESTJARFILE=jarhdftest.jar
test -d $BLDLIBDIR || mkdir -p $BLDLIBDIR

######################################################################
# library files
# --------------------------------------------------------------------
# All the library files copy from source directory to test directory
# NOTE: Keep this framework to add/remove test files.
#       This list are also used for checking exist.
#       Comment '#' without space can be used.
# --------------------------------------------------------------------
LIST_LIBRARY_FILES="
$HDFLIB_HOME/hamcrest-core.jar
$HDFLIB_HOME/junit.jar
$HDFLIB_HOME/slf4j-api-1.7.5.jar
$HDFLIB_HOME/ext/slf4j-simple-1.7.5.jar
$top_builddir/hdf/src/.libs/libdf.*
$top_builddir/mfhdf/libsrc/.libs/libmfhdf.*
$top_builddir/java/src/jni/.libs/libhdf_java.*
$top_builddir/java/src/$JARFILE
"
LIST_DATA_FILES="
$HDFTEST_HOME/JUnit-interface.txt
$HDFTEST_HOME/JUnit-interface.ert
"

expect="JUnit-interface.txt"
actual="JUnit-interface.out"
actual_err="JUnit-interface.err"
actual_ext="JUnit-interface.ext"

#
# copy files from source dirs to test dir
#
COPY_LIBFILES="$LIST_LIBRARY_FILES"

COPY_LIBFILES_TO_BLDLIBDIR()
{
    # copy test files. Used -f to make sure get a new copy
    for tstfile in $COPY_LIBFILES
    do
        # ignore '#' comment
        echo $tstfile | tr -d ' ' | grep '^#' > /dev/null
        RET=$?
        if [ $RET -eq 1 ]; then
            # skip cp if srcdir is same as destdir
            # this occurs when build/test performed in source dir and
            # make cp fail
            SDIR=`$DIRNAME $tstfile`
            INODE_SDIR=`$LS -i -d $SDIR | $AWK -F' ' '{print $1}'`
            INODE_DDIR=`$LS -i -d $BLDLIBDIR | $AWK -F' ' '{print $1}'`
            if [ "$INODE_SDIR" != "$INODE_DDIR" ]; then
                $CP -f $tstfile $BLDLIBDIR
                if [ $? -ne 0 ]; then
                    echo "Error: FAILED to copy $tstfile ."

                    # Comment out this to CREATE expected file
                    exit $EXIT_FAILURE
                fi
            fi
        fi
    done
}

CLEAN_LIBFILES_AND_BLDLIBDIR()
{
    # skip rm if srcdir is same as destdir
    # this occurs when build/test performed in source dir and
    # make cp fail
    SDIR=`$DIRNAME $HDFLIB_HOME/junit.jar`
    INODE_SDIR=`$LS -i -d $SDIR | $AWK -F' ' '{print $1}'`
    INODE_DDIR=`$LS -i -d $BLDLIBDIR | $AWK -F' ' '{print $1}'`
    if [ "$INODE_SDIR" != "$INODE_DDIR" ]; then
        $RM $BLDLIBDIR
    fi
}

COPY_DATAFILES="$LIST_DATA_FILES"

COPY_DATAFILES_TO_BLDDIR()
{
    # copy test files. Used -f to make sure get a new copy
    for tstfile in $COPY_DATAFILES
    do
        # ignore '#' comment
        echo $tstfile | tr -d ' ' | grep '^#' > /dev/null
        RET=$?
        if [ $RET -eq 1 ]; then
            # skip cp if srcdir is same as destdir
            # this occurs when build/test performed in source dir and
            # make cp fail
            SDIR=`$DIRNAME $tstfile`
            INODE_SDIR=`$LS -i -d $SDIR | $AWK -F' ' '{print $1}'`
            INODE_DDIR=`$LS -i -d $BLDDIR | $AWK -F' ' '{print $1}'`
            if [ "$INODE_SDIR" != "$INODE_DDIR" ]; then
                $CP -f $tstfile $BLDDIR
                if [ $? -ne 0 ]; then
                    echo "Error: FAILED to copy $tstfile ."

                    # Comment out this to CREATE expected file
                    exit $EXIT_FAILURE
                fi
            fi
        fi
    done
}

CLEAN_DATAFILES_AND_BLDDIR()
{
        $RM $BLDDIR/JUnit-interface.out
        $RM $BLDDIR/JUnit-interface.err
        $RM $BLDDIR/JUnit-interface.ext
        $RM $BLDDIR/JUnit-interface.txt
}

# Print a line-line message left justified in a field of 70 characters
# beginning with the word "Testing".
#
TESTING() {
   SPACES="                                                               "
   echo "Testing $* $SPACES" | cut -c1-70 | tr -d '\012'
}

# where Java is installed (requires jdk1.7.x)
JAVAEXE=
JAVAEXEFLAGS=

###############################################################################
#            DO NOT MODIFY BELOW THIS LINE
###############################################################################

# prepare for test
COPY_LIBFILES_TO_BLDLIBDIR
COPY_DATAFILES_TO_BLDDIR

CPATH=".:"$BLDLIBDIR"/"$JARFILE":"$BLDLIBDIR"/junit.jar:"$BLDLIBDIR"/hamcrest-core.jar:"$BLDLIBDIR"/slf4j-api-1.7.5.jar:"$BLDLIBDIR"/slf4j-simple-1.7.5.jar:"$TESTJARFILE""

TEST=/usr/bin/test
if [ ! -x /usr/bin/test ]
then
TEST=`which test`
fi

if $TEST -z "$CLASSPATH"; then
        CLASSPATH=""
fi
CLASSPATH=$CPATH":"$CLASSPATH
export CLASSPATH

if $TEST -n "$JAVAPATH" ; then
        PATH=$JAVAPATH":"$PATH
        export PATH
fi

if $TEST -e /bin/uname; then
   os_name=`/bin/uname -s`
elif $TEST -e /usr/bin/uname; then
   os_name=`/usr/bin/uname -s`
else
   os_name=unknown
fi

if $TEST -z "$LD_LIBRARY_PATH" ; then
        LD_LIBRARY_PATH=""
fi

case  $os_name in
    Darwin)
    DYLD_LIBRARY_PATH=$BLDLIBDIR:$DYLD_LIBRARY_PATH
    export DYLD_LIBRARY_PATH
    LD_LIBRARY_PATH=$DYLD_LIBRARY_PATH
    ;;
    *)
    LD_LIBRARY_PATH=$BLDLIBDIR:$LD_LIBRARY_PATH
    ;;
esac

export LD_LIBRARY_PATH

echo "$JAVAEXE $JAVAEXEFLAGS -Xmx1024M -Dorg.slf4j.simpleLogger.defaultLog=trace -Djava.library.path=$BLDLIBDIR -cp $CLASSPATH -ea org.junit.runner.JUnitCore test.TestAll"
($JAVAEXE $JAVAEXEFLAGS -Xmx1024M -Dorg.slf4j.simpleLogger.defaultLog=trace -Djava.library.path=$BLDLIBDIR -cp $CLASSPATH -ea org.junit.runner.JUnitCore test.TestAll 1>$actual_ext 2>$actual_err)

# Extract file name, line number, version and thread IDs because they may be different
sed -e 's/thread [0-9]*/thread (IDs)/' -e 's/: .*\.c /: (file name) /' \
    -e 's/line [0-9]*/line (number)/' \
    -e 's/Time: [0-9]*\.[0-9]*/Time:  XXXX/' \
    -e 's/v[1-9]*\.[0-9]*\./version (number)\./' \
    -e 's/[1-9]*\.[0-9]*\.[0-9]*[^)]*/version (number)/' \
    $actual_ext > $actual

# SunOS does not support this. Skip it.
if [ $myos = SunOS ]; then
    echo " SKIPPED"
else
    if $CMP $expect $actual; then
        echo " PASSED"
    else
        echo "*FAILED*"
        echo "    Expected result differs from actual result"
        nerrors="`expr $nerrors + 1`"
        test yes = "$verbose" && $DIFF $expect $actual |sed 's/^/    /'
    fi
fi


# Clean up temporary files/directories
CLEAN_LIBFILES_AND_BLDLIBDIR
CLEAN_DATAFILES_AND_BLDDIR

# Report test results and exit
if test $nerrors -eq 0 ; then
    echo "All $TESTNAME tests passed."
    exit $EXIT_SUCCESS
else
    echo "$TESTNAME tests failed with $nerrors errors."
    exit $EXIT_FAILURE
fi
