; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
;+
; NAME:
;     GET_FIELDSTRUCT
;
; IDENT:
;     $Id: get_fieldstruct_hdf.pro,v 1.1 2003/02/14 20:18:57 glennh Exp $
;
; PURPOSE:
;     Given a fieldinfo struct (see GET_FIELDINFO.PRO), build a data
;     structure of the right type.
;
; AUTHOR:
;     Ed Santiago
;
; CALLING SEQUENCE:
;     data = GET_FIELDSTRUCT( fieldinfo )
;
; INPUTS:
;     fieldinfo    - data structure returned by GET_FIELDINFO()
;
; OUTPUTS:
;     a structure template
;
; SIDE EFFECTS:
;
; EXAMPLE:
;
;-
FUNCTION get_fieldstruct, fieldinfo
  mystruct = create_struct( 'dnum', 0D )

  FOR i=0, N_Elements(fieldinfo)-1 DO BEGIN
    type  = fieldinfo[i].type		; String describing the type
    ndims = fieldinfo[i].ndims		; Number of array dims (eg, 1, 2, 3)
    dims  = fieldinfo[i].dims		; The dimensions themselves (eg, [9x3])

    ; Sigh.  Rather than give us something *USEFUL*, such as its internal
    ; data type number (float=4,int=2,etc), IDL gives us a string.  It's
    ; up to us to convert that to a real data type.  We do so in a gross
    ; CASE statement, converting each string descriptor to a variable
    ; of the correct IDL type.
    ;
    ; To make things worse, with the introduction of unsigned types
    ; in 5.2, IDL has added the 'UINT' and 'ULONG' strings.  Piece
    ; o' cake to add those, along with their respective definitions
    ; as "0U" and "0UL", right?  Well, no.  IDL <5.2 gives a compile-
    ; time error with those, so we can't do that if we want to remain
    ; compatible with 5.1.  The solution is to define the type as a
    ; string, then EXECUTE() it.  This way we don't get the compilation
    ; errors, nor will EXECUTE() fail, since UINT/ULONG don't exist in <5.2.
    CASE type OF 
      'BYTE':   t = '0B'
      'INT':    t = '0'
      'UINT':	t = '0U'
      'LONG':   t = '0L'
      'ULONG':  t = '0UL'
      'FLOAT':  t = '0.0'
      'DOUBLE': t = '0.0D'
    ENDCASE

    r = execute('xxx = ' + t)

    ; If field is an array, make it so.
    IF ndims NE 0 THEN $
        xxx = Make_Array(size=[ndims, dims[0:ndims-1], (size(xxx))[1], 0])

    ; Append this new field to the Master Data Structure
    mystruct = create_struct( mystruct, fieldinfo[i].name, xxx)
  ENDFOR

  RETURN, mystruct
END
