#include <stdio.h>
#include <string.h>

#include "ss_level2_data_1hr.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, sd_id;
  struct SS_data_1hr *testdata;
  int ii,jj,retval;
  int read_first_line;
  int32 numrec;
  float32 seconds;

  if ( argc!=2 && argc!=3 ){
      printf("Usage: swics_L2_1hr_rd hdf_file (optional: read_1st_line equals 1 means only read first line of file \n");
      exit(1);
    }

  read_first_line = (int)argv[2]; /* =1 means to read only first line of file */

  testdata=malloc(sizeof(struct SS_data_1hr));

  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
    }
  Vstart(hdf_fp);

  if ((sd_id=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
	  fprintf(stderr, "SDstart: could not open hdf file\n");
	  exit(-1);
	}

  numrec=init_rd_ss_level2_data_1hr(hdf_fp, sd_id, "r");

  if( numrec<=0) {
    fprintf(stderr,"No swics level2 1hr data\n");
    exit(-1);
  }

  ii=0;
  while((retval= read_ss_level2_data_1hr(testdata,ii))!=-1) {

          seconds = (int)(testdata->hr * 3600 + testdata->min * 60 + testdata->sec);

	  printf( "%4d %3d %12.2f ",
		 testdata->year,
		 testdata->day,
		  testdata->ACEepoch ); /* unique # for this record */

	  printf( "%9.2f %9.2f %9.2f %9.2f %9.2f %9.2f ", 
		 testdata->nHe2,  testdata->nHe2_err,
		 testdata->vHe2, testdata->vthHe2,
		 testdata->vO6, testdata->vthO6 );

	  printf( "%9.2f %9.2f ",
		 testdata->vFe10, testdata->vthFe10 );

	  printf( "%9.2f %9.2f %5d %9.2f %9.2f %5d ",
		 testdata->C6to4, testdata->C6to4_err, testdata->qf_C6to4,
		 testdata->O7to6, testdata->O7to6_err, testdata->qf_O7to6 );

	  printf( "%9.2f %9.2f %5d %9.2f %9.2f %5d %9.2f %9.2f %5d", 
		 testdata->avqC,   testdata->avqC_err, testdata->qf_avqC,
                 testdata->avqO,   testdata->avqO_err, testdata->qf_avqO,
                 testdata->FetoO,   testdata->FetoO_err, testdata->qf_FetoO);


	  printf( "\n" );

	  if ( read_first_line ) {
fprintf( stderr, "swics_L2_1hr_rd: %4d %3d %9.3f ",
		 testdata->year,
		 testdata->day,
		 seconds ); 
	    break; /* Read ONLY 1st line */
	  }
	  ii++;
  }

  /* all done, close HDF file */

  close_rd_ss_level2_data_1hr();
  Vend(hdf_fp);
  if (SDend(sd_id)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
    }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
    }

  exit(0);
}


