#include <stdio.h>
#include <string.h>
#include <time.h>


#include "level2_record_doy.h"
#include "sis_level2_factors_energy_levels.h"
#include "df.h"
#include "mfhdf.h"

int main(argc, argv)
int argc;
char *argv[];
{
  int32 hdf_fp, SDid;
  int ii,jj,d,retval,i;
  int elem[NUMBER_OF_ELEMENTS]={2,6,7,8,10,11,12,13,14,16,18,20,26,28};
  int32 numrec;
  time_t tloc;
  char timestr[80];
  struct SIS_factors_energy_levels *data;

  float32 range_lower[NUMBER_OF_ELEMENTS][NUMBER_OF_ENERGY_BANDS];
  float32 range_upper[NUMBER_OF_ELEMENTS][NUMBER_OF_ENERGY_BANDS];
  float32 factors[NUMBER_OF_ELEMENTS][NUMBER_OF_ENERGY_BANDS];
  
  int32 init_rd_sis_level2_factors_energy_levels();
  int32 read_sis_level2_factors_energy_levels();
  void close_rd_sis_level2_factors_energy_levels();

  if (argc!=2) {
      printf("Usage: sis_l2_factor_rd hdf_file\n");
      exit(1);
  }

  if((data=malloc(sizeof(struct SIS_factors_energy_levels)))==NULL) {
    fprintf(stderr,"Allocation error SIS_factors_energy_levels - exit");
    exit(-1);
  }
  
  /* open hdf input file */

  if ((hdf_fp=Hopen(argv[1], DFACC_RDONLY, 0))==FAIL) {
      fprintf(stderr, "Hopen: could not open hdf file\n");
      exit(-1);
  }
  Vstart(hdf_fp);

  if ((SDid=SDstart(argv[1], DFACC_RDONLY))==FAIL) {
      fprintf(stderr, "SDstart: could not open hdf file\n");
      exit(-1);
  }

  
/**********************************************************************/

  if((d=init_rd_sis_level2_factors_energy_levels(hdf_fp,SDid,"r"))<=0) {
    fprintf(stderr,"\nNo sis data_256s second; Error# = %d\n",d);
    exit(-1);
  }
  for(ii=0;ii<NUMBER_OF_ELEMENTS;ii++) {
    if(read_sis_level2_factors_energy_levels(data,ii) == FAIL){
      fprintf(stderr,"\nError reading sis factors_energy_levels");
      exit(-1);
    }
    for(i=0;i<NUMBER_OF_ENERGY_BANDS;i++) {
      range_lower[ii][i]=data->range_lower[i];
      range_upper[ii][i]=data->range_upper[i];
      factors[ii][i]=data->factors[i];
      printf("%d %5.1f %5.1f\n", elem[ii],
	     range_lower[ii][i],range_upper[ii][i]);
    }
  }
  close_rd_sis_level2_factors_energy_levels();




  /* all done, close HDF file */
  Vend(hdf_fp);
  if (SDend(SDid)==FAIL) {
      fprintf(stderr, "SDend: could not close hdf file\n");
      exit(-1);
  }
  if (Hclose(hdf_fp)==FAIL) {
      fprintf(stderr, "Hclose: could not close hdf file\n");
      exit(-1);
  }
  exit(0);
}


