/* $Id: mag_level2_data_1hr.h,v 1.2 2002/06/11 17:57:45 asc Exp $ */

#include "hdfi.h"

struct MAG_data_1hr {

  /* UT time at the start of the periods */
  int32   year;                        /* integer year */
  int32   day;                         /* integer day of year */
  int32   hr;                          /* hour of day */
  int32   min;                         /* min of hour */
  float32 sec;                         /* seconds */
  float64 fp_year;                     /* floating point year */
  float64 fp_doy;                      /* floating point Day of YearDOY */ 
  float64 ACEepoch;                    /* UT time in sec since 1/1/96 */

  /* ACE frame count */
  uint32 SCclock;
      
  /* mag average data */
  float32 Br;                          /* R-component of mag. field in RTN (nT) */
  float32 Bt;                          /* T-component of mag. field in RTN (nT) */
  float32 Bn;                          /* N-component of mag. field in RTN (nT) */

  float32 Bmag;                        /* <|B|> magnetic field magnitude (nT) */
  float32 Delta;                       /* RTN latitude */
  float32 Lambda;                      /* RTN longitude */

  float32 Bgse_x;                      /* X-component of mag. field in GSE (nT) */
  float32 Bgse_y;
  float32 Bgse_z;

  float32 Bgsm_x;                      /* X-component of mag. field in GSM (nT) */
  float32 Bgsm_y;
  float32 Bgsm_z;

  float32 dBrms;                       /* RMS values of underlying high-resolution measurements (nT) */
  float32 sigma_B;                     /* Variance of |B|, i.e. sqrt(<(|B|-<|B|>)^2>) (nT) */

  float32 fraction_good;               /* Fraction of the timing period for which there was data available */
  int32   N_vectors;                   /* Number of hi-res (16-sec) measurements included in the average */

  /* data quality for period; data types 1 and 2 have been excised */
  int32  Quality;                      /* =0 Normal; */
                                       /* =1 Maneuver & subsequent nutation damping period */
				       /* =2 Bad data */
 
 /* Sensor Position in gse coordinates */
  float32 pos_gse_x;
  float32 pos_gse_y;
  float32 pos_gse_z;

  /* Sensor Position in gsm coordinates */
  float32 pos_gsm_x;
  float32 pos_gsm_y;
  float32 pos_gsm_z;

};


