/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

/* The include file used to create this file is: */
/* $Id:  */

#include "sweswi_level2_data_12min.h"
#include "df.h"

int32 vgrp_id_sweswi_level2_data_12min;
static int32 vdata_id_sweswi_level2_data_12min;

  /* 2468 is the size of sweswi_level2_data_12min.h + 1 added line */
char Vgrp_descrp_SWESWI_data_12min[2468];

/****----  init create function  ----****/

int32 init_cr_sweswi_level2_data_12min(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_sweswi_level2_data_12min();

  void print_sweswi_level2_data_12min_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_sweswi_level2_data_12min = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_sweswi_level2_data_12min, "VG_SWESWI_data_12min"); 
  Vsetclass(vgrp_id_sweswi_level2_data_12min, "VG_SWESWI_LEVEL2_DATA_12MIN");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SWESWI_data_12min" )) ==FAIL) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_sweswi_level2_data_12min(Vgrp_descrp_SWESWI_data_12min);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SWESWI_data_12min, sizeof(Vgrp_descrp_SWESWI_data_12min))) ==FAIL) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_sweswi_level2_data_12min = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_sweswi_level2_data_12min, "SWESWI_data_12min");
  VSsetclass(vdata_id_sweswi_level2_data_12min, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_sweswi_level2_data_12min, vdata_id_sweswi_level2_data_12min)) ==FAIL) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "year", DFNT_INT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "day", DFNT_INT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "hr", DFNT_INT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "min", DFNT_INT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "sec", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "fp_year", DFNT_FLOAT64, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "proton_density", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define proton_density");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "proton_temp", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define proton_temp");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "He4toprotons", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define He4toprotons");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "proton_speed", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define proton_speed");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "x_dot_GSE", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define x_dot_GSE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "y_dot_GSE", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define y_dot_GSE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "z_dot_GSE", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define z_dot_GSE");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "x_dot_RTN", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define x_dot_RTN");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "y_dot_RTN", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define y_dot_RTN");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "z_dot_RTN", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define z_dot_RTN");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "x_dot_GSM", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define x_dot_GSM");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "y_dot_GSM", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define y_dot_GSM");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "z_dot_GSM", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define z_dot_GSM");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "pos_gse_x", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define pos_gse_x");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "pos_gse_y", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define pos_gse_y");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "pos_gse_z", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define pos_gse_z");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "pos_gsm_x", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define pos_gsm_x");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "pos_gsm_y", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define pos_gsm_y");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "pos_gsm_z", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define pos_gsm_z");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "N_swe64", DFNT_INT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define N_swe64");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "SWICS_flag", DFNT_INT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define SWICS_flag");
    retval = -1;
  }
  if (VSfdefine(vdata_id_sweswi_level2_data_12min, "SWICS_n_err", DFNT_FLOAT32, (1) )) {
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSfdefine: Couldn't define SWICS_n_err");
    retval = -1;
  }

  if (VSsetfields(vdata_id_sweswi_level2_data_12min,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, proton_density, proton_temp, He4toprotons, proton_speed, x_dot_GSE, y_dot_GSE, z_dot_GSE, x_dot_RTN, y_dot_RTN, z_dot_RTN, x_dot_GSM, y_dot_GSM, z_dot_GSM, pos_gse_x, pos_gse_y, pos_gse_z, pos_gsm_x, pos_gsm_y, pos_gsm_z, N_swe64, SWICS_flag, SWICS_n_err")){
    print_sweswi_level2_data_12min_error("init_cr_sweswi_level2_data_12min -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_sweswi_level2_data_12min(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_sweswi_level2_data_12min(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_sweswi_level2_data_12min(struct SWESWI_data_12min SWESWI_data_12min_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_sweswi_level2_data_12min_error();
void pack_sweswi_level2_data_12min();

  odata = (uint8 *) malloc(sizeof(struct SWESWI_data_12min));
  pack_sweswi_level2_data_12min(odata, &SWESWI_data_12min_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_sweswi_level2_data_12min, recnum)==-1) {
		print_sweswi_level2_data_12min_error("write_sweswi_level2_data_12min -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_sweswi_level2_data_12min, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_sweswi_level2_data_12min_error("write_sweswi_level2_data_12min -> VSwrite: Couldn't write data.");

  memset(&SWESWI_data_12min_struc, 0, sizeof(struct SWESWI_data_12min));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_sweswi_level2_data_12min()
{
  VSdetach(vdata_id_sweswi_level2_data_12min);
  Vdetach(vgrp_id_sweswi_level2_data_12min);
}

/*----     init access function    ----*/

int32 init_acc_sweswi_level2_data_12min(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_sweswi_level2_data_12min_error();


  if ((vdata_ref = VSfind(hdf_fp, "SWESWI_data_12min")) <= 0 ) {
    print_sweswi_level2_data_12min_error("init_acc_sweswi_level2_data_12min -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_sweswi_level2_data_12min = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_sweswi_level2_data_12min_error("init_acc_sweswi_level2_data_12min -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_sweswi_level2_data_12min, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_sweswi_level2_data_12min,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, proton_density, proton_temp, He4toprotons, proton_speed, x_dot_GSE, y_dot_GSE, z_dot_GSE, x_dot_RTN, y_dot_RTN, z_dot_RTN, x_dot_GSM, y_dot_GSM, z_dot_GSM, pos_gse_x, pos_gse_y, pos_gse_z, pos_gsm_x, pos_gsm_y, pos_gsm_z, N_swe64, SWICS_flag, SWICS_n_err")) {
      print_sweswi_level2_data_12min_error("init_acc_sweswi_level2_data_12min -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_sweswi_level2_data_12min(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_sweswi_level2_data_12min(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_sweswi_level2_data_12min(struct SWESWI_data_12min *SWESWI_data_12min_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_sweswi_level2_data_12min_error();
void unpack_sweswi_level2_data_12min();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SWESWI_data_12min));
  VSinquire(vdata_id_sweswi_level2_data_12min, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_sweswi_level2_data_12min, recnum_rd)==FAIL) {
          print_sweswi_level2_data_12min_error("read_sweswi_level2_data_12min -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_sweswi_level2_data_12min, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_sweswi_level2_data_12min_error("read_sweswi_level2_data_12min -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_sweswi_level2_data_12min(odata, SWESWI_data_12min_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_sweswi_level2_data_12min()
{
  VSdetach(vdata_id_sweswi_level2_data_12min);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_sweswi_level2_data_12min(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_sweswi_level2_data_12min_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SWESWI_data_12min" )) ==FAIL)
    print_sweswi_level2_data_12min_error("rd_Vgrp_sweswi_level2_data_12min -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_sweswi_level2_data_12min_error("rd_Vgrp_sweswi_level2_data_12min -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_sweswi_level2_data_12min_error("rd_Vgrp_sweswi_level2_data_12min -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_sweswi_level2_data_12min_error("rd_Vgrp_sweswi_level2_data_12min -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SWESWI_data_12min, HDstrlen(Vgrp_descrp_SWESWI_data_12min)) ==FAIL)
    print_sweswi_level2_data_12min_error("rd_Vgrp_sweswi_level2_data_12min -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SWESWI_data_12min);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_sweswi_level2_data_12min_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_sweswi_level2_data_12min.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_sweswi_level2_data_12min(uint8 *data, struct SWESWI_data_12min *SWESWI_data_12min_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SWESWI_data_12min_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->proton_density, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->proton_temp, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->He4toprotons, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->proton_speed, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->x_dot_GSE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->y_dot_GSE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->z_dot_GSE, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->x_dot_RTN, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->y_dot_RTN, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->z_dot_RTN, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->x_dot_GSM, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->y_dot_GSM, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->z_dot_GSM, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->pos_gse_x, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->pos_gse_y, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->pos_gse_z, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->pos_gsm_x, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->pos_gsm_y, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->pos_gsm_z, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->N_swe64, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->SWICS_flag, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SWESWI_data_12min_ptr->SWICS_n_err, ((4)*(1)) );
   ptr+= ((4)*(1));
}

/*----   unpack function    ----*/

void unpack_sweswi_level2_data_12min(uint8 *data, struct SWESWI_data_12min *SWESWI_data_12min_ptr)
{
int32 ptr=0;

   memcpy(&SWESWI_data_12min_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWESWI_data_12min_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWESWI_data_12min_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SWESWI_data_12min_ptr->proton_density, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->proton_temp, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->He4toprotons, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->proton_speed, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->x_dot_GSE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->y_dot_GSE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->z_dot_GSE, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->x_dot_RTN, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->y_dot_RTN, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->z_dot_RTN, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->x_dot_GSM, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->y_dot_GSM, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->z_dot_GSM, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->pos_gse_x, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->pos_gse_y, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->pos_gse_z, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->pos_gsm_x, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->pos_gsm_y, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->pos_gsm_z, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->N_swe64, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->SWICS_flag, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SWESWI_data_12min_ptr->SWICS_n_err, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
}
int32 get_vgrp_id_sweswi_level2_data_12min() {return(vgrp_id_sweswi_level2_data_12min);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_sweswi_level2_data_12min(char *wr_strval)
{
  strcpy(wr_strval, "The file 'sweswi_level2_data_12min.h' is shown below, it was used to create the data in the Vgroup named 'VG_SWESWI_data_12min'.\n\n");
  strcat(wr_strval,"/* Id: $ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"/* sweswi_level2_data_12min.h */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SWESWI_data_12min {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of the periods */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* SWEPAM/SWICS data */\n");
  strcat(wr_strval,"  float32 proton_density;\n");
  strcat(wr_strval,"  float32 proton_temp;\n");
  strcat(wr_strval,"  float32 He4toprotons;\n");
  strcat(wr_strval,"  float32 proton_speed;\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 x_dot_GSE;                  /* Solar Wind Velocity: x coord. GSE */\n");
  strcat(wr_strval,"  float32 y_dot_GSE;                  /* Solar Wind Velocity: y coord. GSE */\n");
  strcat(wr_strval,"  float32 z_dot_GSE;                  /* Solar Wind Velocity: z coord. GSE */\n");
  strcat(wr_strval,"  float32 x_dot_RTN;                  /* Solar Wind Velocity: r coord. RTN */\n");
  strcat(wr_strval,"  float32 y_dot_RTN;                  /* Solar Wind Velocity: t coord. RTN */\n");
  strcat(wr_strval,"  float32 z_dot_RTN;                  /* Solar Wind Velocity: n coord. RTN */\n");
  strcat(wr_strval,"  float32 x_dot_GSM;                  /* Solar Wind Velocity: x coord. GSM */\n");
  strcat(wr_strval,"  float32 y_dot_GSM;                  /* Solar Wind Velocity: y coord. GSM */\n");
  strcat(wr_strval,"  float32 z_dot_GSM;                  /* Solar Wind Velocity: z coord. GSM */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 pos_gse_x;                  /* Spacecraft position: x coord. GSE */\n");
  strcat(wr_strval,"  float32 pos_gse_y;                  /* Spacecraft position: y coord. GSE */\n");
  strcat(wr_strval,"  float32 pos_gse_z;                  /* Spacecraft position: z coord. GSE */\n");
  strcat(wr_strval,"  float32 pos_gsm_x;                  /* Spacecraft position: x coord. GSM */\n");
  strcat(wr_strval,"  float32 pos_gsm_y;                  /* Spacecraft position: y coord. GSM */\n");
  strcat(wr_strval,"  float32 pos_gsm_z;                  /* Spacecraft position: z coord. GSM */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int32 N_swe64;                      /* Number of SWEPAM 64-second records used */\n");
  strcat(wr_strval,"  int32 SWICS_flag;                   /* 1 if SWICS data used, 0 otherwise */\n");
  strcat(wr_strval,"  float32 SWICS_n_err;                /* n_err carried over from SWICS, if */\n");
  strcat(wr_strval,"                                      /* SWICS data are used, 0 otherwise */\n");
  strcat(wr_strval,"};\n");
  return(0);
}
