/* The RCS version of hdfgen.pl used to create this file is: */
/* $Id: hdfgen.pl,v 1.49 1999/11/04 17:17:13 asc Exp  */

  /* An RCS (Revision Control System) header */

  /* for the include file is not on the first line. */

#include "ss_level2_qdist_2hr.h"
#include "df.h"

int32 vgrp_id_ss_level2_qdist_2hr;
static int32 vdata_id_ss_level2_qdist_2hr;

  /* 1610 is the size of ss_level2_qdist_2hr.h + 1 added line */
char Vgrp_descrp_SS_qdist_2hr[1610];

/****----  init create function  ----****/

int32 init_cr_ss_level2_qdist_2hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{
  int32 retval=0;
  int32 vgrp_ref_w;
  int32 ann_id_w;
  int32 wr_Vgrp_desc_ss_level2_qdist_2hr();

  void print_ss_level2_qdist_2hr_error();

  /*         Setup a Vgroup         */
  if ((vgrp_id_ss_level2_qdist_2hr = Vattach(hdf_fp, -1, "w"))==FAIL) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> Vattach: Couldn't create Vgroup");
    retval = -1;
  }
  Vsetname(vgrp_id_ss_level2_qdist_2hr, "VG_SS_qdist_2hr"); 
  Vsetclass(vgrp_id_ss_level2_qdist_2hr, "VG_SS_LEVEL2_QDIST_2HR");


  /*      Get the Vgroup reference     */
  if ((vgrp_ref_w = Vfind(hdf_fp, "VG_SS_qdist_2hr" )) ==FAIL) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> Vfind: Couldn't get Vgrp reference");
    retval = -1;
  }
  /*      Add a description to the Vgroup      */
  wr_Vgrp_desc_ss_level2_qdist_2hr(Vgrp_descrp_SS_qdist_2hr);

  if ((ann_id_w = ANcreate(an_id, DFTAG_VG, vgrp_ref_w, AN_DATA_DESC)) ==FAIL) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> ANcreate: Can't create Vgrp description");
    retval = -1;
  }
  if ((ANwriteann(ann_id_w, Vgrp_descrp_SS_qdist_2hr, sizeof(Vgrp_descrp_SS_qdist_2hr))) ==FAIL) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> ANwriteann: Can't write Vgrp description");
    retval = -1;
  }
  ANendaccess(ann_id_w);

  /*        Setup a Vdata        */
  if ((vdata_id_ss_level2_qdist_2hr = VSattach(hdf_fp, -1, "w")) ==FAIL) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSattach: Couldn't attach to Vdata");
    retval = -1;
  }
  VSsetname(vdata_id_ss_level2_qdist_2hr, "SS_qdist_2hr");
  VSsetclass(vdata_id_ss_level2_qdist_2hr, classname);

  /*       Insert the Vdata into the Vgroup       */
  if ((Vinsert(vgrp_id_ss_level2_qdist_2hr, vdata_id_ss_level2_qdist_2hr)) ==FAIL) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> Vinsert: Couldn't insert Vdata into Vgroup");
    retval = -1;
  }

  /*    Define the fields in the Vdata    */
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "year", DFNT_INT32, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "day", DFNT_INT32, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define day");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "hr", DFNT_INT32, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define hr");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "min", DFNT_INT32, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define min");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "sec", DFNT_FLOAT32, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define sec");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "fp_year", DFNT_FLOAT64, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define fp_year");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "fp_doy", DFNT_FLOAT64, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define fp_doy");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "ACEepoch", DFNT_FLOAT64, (1) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define ACEepoch");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistC", DFNT_FLOAT32, (nqC) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistC");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistO", DFNT_FLOAT32, (nqO) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistNe", DFNT_FLOAT32, (nqNe) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistNe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistMg", DFNT_FLOAT32, (nqMg) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistMg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistSi", DFNT_FLOAT32, (nqSi) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistSi");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistFe", DFNT_FLOAT32, (nqFe) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistFe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistC_err", DFNT_FLOAT32, (nqC) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistC_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistO_err", DFNT_FLOAT32, (nqO) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistO_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistNe_err", DFNT_FLOAT32, (nqNe) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistNe_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistMg_err", DFNT_FLOAT32, (nqMg) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistMg_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistSi_err", DFNT_FLOAT32, (nqSi) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistSi_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qdistFe_err", DFNT_FLOAT32, (nqFe) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qdistFe_err");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qf_qdistC", DFNT_INT16, (nqC) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qf_qdistC");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qf_qdistO", DFNT_INT16, (nqO) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qf_qdistO");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qf_qdistNe", DFNT_INT16, (nqNe) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qf_qdistNe");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qf_qdistMg", DFNT_INT16, (nqMg) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qf_qdistMg");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qf_qdistSi", DFNT_INT16, (nqSi) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qf_qdistSi");
    retval = -1;
  }
  if (VSfdefine(vdata_id_ss_level2_qdist_2hr, "qf_qdistFe", DFNT_INT16, (nqFe) )) {
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSfdefine: Couldn't define qf_qdistFe");
    retval = -1;
  }

  if (VSsetfields(vdata_id_ss_level2_qdist_2hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, qdistC, qdistO, qdistNe, qdistMg, qdistSi, qdistFe, qdistC_err, qdistO_err, qdistNe_err, qdistMg_err, qdistSi_err, qdistFe_err, qf_qdistC, qf_qdistO, qf_qdistNe, qf_qdistMg, qf_qdistSi, qf_qdistFe")){
    print_ss_level2_qdist_2hr_error("init_cr_ss_level2_qdist_2hr -> VSsetfields: Couldn't set fields");
    retval = -1;
  }

  return(retval);
}

/* Included for backwards compatibility */

int32 init_wr_ss_level2_qdist_2hr(int32 hdf_fp, int32 sd_id, int32 an_id, char *classname)
{ return( init_cr_ss_level2_qdist_2hr(hdf_fp, sd_id, an_id, classname) ); }

/******---- write function ----******/

int32 write_ss_level2_qdist_2hr(struct SS_qdist_2hr SS_qdist_2hr_struc, int32 recnum)
{
  int32 retval = 0;
  uint8 *odata;

void print_ss_level2_qdist_2hr_error();
void pack_ss_level2_qdist_2hr();

  odata = (uint8 *) malloc(sizeof(struct SS_qdist_2hr));
  pack_ss_level2_qdist_2hr(odata, &SS_qdist_2hr_struc);

  if(recnum!=-1) {
	if(VSseek(vdata_id_ss_level2_qdist_2hr, recnum)==-1) {
		print_ss_level2_qdist_2hr_error("write_ss_level2_qdist_2hr -> VSseek: error.");
		retval = -1;
	}
  }
  if(VSwrite(vdata_id_ss_level2_qdist_2hr, (uint8 *)odata, 1, FULL_INTERLACE) == -1)
    print_ss_level2_qdist_2hr_error("write_ss_level2_qdist_2hr -> VSwrite: Couldn't write data.");

  memset(&SS_qdist_2hr_struc, 0, sizeof(struct SS_qdist_2hr));
  free(odata);
  return(retval);
}

/*----   close write function    ----*/

void close_wr_ss_level2_qdist_2hr()
{
  VSdetach(vdata_id_ss_level2_qdist_2hr);
  Vdetach(vgrp_id_ss_level2_qdist_2hr);
}

/*----     init access function    ----*/

int32 init_acc_ss_level2_qdist_2hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{
  int32 vdata_ref;
  int32 num_rec;

  void print_ss_level2_qdist_2hr_error();


  if ((vdata_ref = VSfind(hdf_fp, "SS_qdist_2hr")) <= 0 ) {
    print_ss_level2_qdist_2hr_error("init_acc_ss_level2_qdist_2hr -> VSfind: Found no vdata of specified type.");
    return(0);
  }
  if ((vdata_id_ss_level2_qdist_2hr = VSattach(hdf_fp, vdata_ref, access_mode)) ==FAIL) {
    print_ss_level2_qdist_2hr_error("init_acc_ss_level2_qdist_2hr -> VSattach: Couldn't attach to hdf file.");
    return(-1);
  }

  VSinquire(vdata_id_ss_level2_qdist_2hr, &num_rec, NULL, NULL, NULL, NULL);
  if (num_rec == 0) { return(0); }


  if (VSsetfields(vdata_id_ss_level2_qdist_2hr,"year, day, hr, min, sec, fp_year, fp_doy, ACEepoch, qdistC, qdistO, qdistNe, qdistMg, qdistSi, qdistFe, qdistC_err, qdistO_err, qdistNe_err, qdistMg_err, qdistSi_err, qdistFe_err, qf_qdistC, qf_qdistO, qf_qdistNe, qf_qdistMg, qf_qdistSi, qf_qdistFe")) {
      print_ss_level2_qdist_2hr_error("init_acc_ss_level2_qdist_2hr -> VSsetfields: Unable to set fields.");
      return(-1);
  }
  return(num_rec);
}

/* Included for backwards compatability */

int32 init_rd_ss_level2_qdist_2hr(int32 hdf_fp, int32 sd_id, char *access_mode)
{ return ( init_acc_ss_level2_qdist_2hr(hdf_fp, sd_id, access_mode) ); }

/******---- read function ----******/

int32 read_ss_level2_qdist_2hr(struct SS_qdist_2hr *SS_qdist_2hr_struc, int32 recnum_rd)
{
int32 maxrec;
static int32 last_recnum = -1;
int32 retval = 0;
uint8 *odata;

void print_ss_level2_qdist_2hr_error();
void unpack_ss_level2_qdist_2hr();

  if(recnum_rd==-1) recnum_rd=last_recnum+1;

  odata = (uint8 *) malloc(sizeof(struct SS_qdist_2hr));
  VSinquire(vdata_id_ss_level2_qdist_2hr, &maxrec, NULL, NULL, NULL, NULL);
  if (recnum_rd >= maxrec) return(-1);
  if (recnum_rd != last_recnum+1)
      if (VSseek(vdata_id_ss_level2_qdist_2hr, recnum_rd)==FAIL) {
          print_ss_level2_qdist_2hr_error("read_ss_level2_qdist_2hr -> VSseek unsuccessful");
          retval = -1;
    }
  last_recnum = recnum_rd;

  if(VSread(vdata_id_ss_level2_qdist_2hr, (uint8 *)odata, 1, FULL_INTERLACE) ==FAIL) {
    print_ss_level2_qdist_2hr_error("read_ss_level2_qdist_2hr -> VSread: Couldn't read data.");
    retval = -1;
  }
  unpack_ss_level2_qdist_2hr(odata, SS_qdist_2hr_struc);
  free(odata);
  return(retval);
}

/*----   close read function    ----*/

void close_rd_ss_level2_qdist_2hr()
{
  VSdetach(vdata_id_ss_level2_qdist_2hr);
}

/*----  Read V group description, function    ----*/
void rd_Vgrp_desc_ss_level2_qdist_2hr(int32 hdf_fp, int32 an_id)
{
  int32 ann_id_r;
  int32 num_ann;
  int32 *ann_list;
  int32 vgrp_ref_r;

void print_ss_level2_qdist_2hr_error();

  /*      Get the Vgroup reference     */
  if ((vgrp_ref_r = Vfind(hdf_fp, "VG_SS_qdist_2hr" )) ==FAIL)
    print_ss_level2_qdist_2hr_error("rd_Vgrp_ss_level2_qdist_2hr -> Vfind: Couldn't get Vgrp reference.");

  if ((num_ann = ANnumann(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r)) ==FAIL)
    print_ss_level2_qdist_2hr_error("rd_Vgrp_ss_level2_qdist_2hr -> ANnumann: Couldn't get number of annotations.");

    ann_list = HDmalloc(num_ann * sizeof(int32));
  if ((num_ann = ANannlist(an_id, AN_DATA_DESC, DFTAG_VG, vgrp_ref_r, ann_list)) ==FAIL)
    print_ss_level2_qdist_2hr_error("rd_Vgrp_ss_level2_qdist_2hr -> ANannlist: Couldn't");

  if ((ann_id_r = ANselect(an_id, (num_ann-1), AN_DATA_DESC)) ==FAIL)
    print_ss_level2_qdist_2hr_error("rd_Vgrp_ss_level2_qdist_2hr -> ANselect: Couldn't");

  if (ANreadann(ann_id_r, Vgrp_descrp_SS_qdist_2hr, HDstrlen(Vgrp_descrp_SS_qdist_2hr)) ==FAIL)
    print_ss_level2_qdist_2hr_error("rd_Vgrp_ss_level2_qdist_2hr -> ANreadann: Couldn't");

  printf("AN: %s\n", Vgrp_descrp_SS_qdist_2hr);
  ANendaccess(ann_id_r);
  ANend(an_id);
}

/*----   error function    ----*/

void print_ss_level2_qdist_2hr_error(int8 *mess)
{
  fprintf(stderr,"\nERROR in  hdf_ss_level2_qdist_2hr.c -> %s\n", mess);
  HEprint(stderr, 0);
}

/*----   pack function    ----*/

void pack_ss_level2_qdist_2hr(uint8 *data, struct SS_qdist_2hr *SS_qdist_2hr_ptr)
{
int32 ptr=0;

   memcpy(data+ptr, &SS_qdist_2hr_ptr->year, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->day, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->hr, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->min, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->sec, ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->fp_year, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->fp_doy, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->ACEepoch, ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistC[0], ((4)*(nqC)) );
   ptr+= ((4)*(nqC));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistO[0], ((4)*(nqO)) );
   ptr+= ((4)*(nqO));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistNe[0], ((4)*(nqNe)) );
   ptr+= ((4)*(nqNe));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistMg[0], ((4)*(nqMg)) );
   ptr+= ((4)*(nqMg));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistSi[0], ((4)*(nqSi)) );
   ptr+= ((4)*(nqSi));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistFe[0], ((4)*(nqFe)) );
   ptr+= ((4)*(nqFe));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistC_err[0], ((4)*(nqC)) );
   ptr+= ((4)*(nqC));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistO_err[0], ((4)*(nqO)) );
   ptr+= ((4)*(nqO));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistNe_err[0], ((4)*(nqNe)) );
   ptr+= ((4)*(nqNe));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistMg_err[0], ((4)*(nqMg)) );
   ptr+= ((4)*(nqMg));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistSi_err[0], ((4)*(nqSi)) );
   ptr+= ((4)*(nqSi));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qdistFe_err[0], ((4)*(nqFe)) );
   ptr+= ((4)*(nqFe));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qf_qdistC[0], ((2)*(nqC)) );
   ptr+= ((2)*(nqC));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qf_qdistO[0], ((2)*(nqO)) );
   ptr+= ((2)*(nqO));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qf_qdistNe[0], ((2)*(nqNe)) );
   ptr+= ((2)*(nqNe));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qf_qdistMg[0], ((2)*(nqMg)) );
   ptr+= ((2)*(nqMg));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qf_qdistSi[0], ((2)*(nqSi)) );
   ptr+= ((2)*(nqSi));
   memcpy(data+ptr, &SS_qdist_2hr_ptr->qf_qdistFe[0], ((2)*(nqFe)) );
   ptr+= ((2)*(nqFe));
}

/*----   unpack function    ----*/

void unpack_ss_level2_qdist_2hr(uint8 *data, struct SS_qdist_2hr *SS_qdist_2hr_ptr)
{
int32 ptr=0;

   memcpy(&SS_qdist_2hr_ptr->year, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_qdist_2hr_ptr->day, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_qdist_2hr_ptr->hr, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_qdist_2hr_ptr->min, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_qdist_2hr_ptr->sec, data+ptr,  ((4)*(1)) );
   ptr+= ((4)*(1));
   memcpy(&SS_qdist_2hr_ptr->fp_year, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_qdist_2hr_ptr->fp_doy, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_qdist_2hr_ptr->ACEepoch, data+ptr,  ((8)*(1)) );
   ptr+= ((8)*(1));
   memcpy(&SS_qdist_2hr_ptr->qdistC[0], data+ptr,  ((4)*(nqC)) );
   ptr+= ((4)*(nqC));
   memcpy(&SS_qdist_2hr_ptr->qdistO[0], data+ptr,  ((4)*(nqO)) );
   ptr+= ((4)*(nqO));
   memcpy(&SS_qdist_2hr_ptr->qdistNe[0], data+ptr,  ((4)*(nqNe)) );
   ptr+= ((4)*(nqNe));
   memcpy(&SS_qdist_2hr_ptr->qdistMg[0], data+ptr,  ((4)*(nqMg)) );
   ptr+= ((4)*(nqMg));
   memcpy(&SS_qdist_2hr_ptr->qdistSi[0], data+ptr,  ((4)*(nqSi)) );
   ptr+= ((4)*(nqSi));
   memcpy(&SS_qdist_2hr_ptr->qdistFe[0], data+ptr,  ((4)*(nqFe)) );
   ptr+= ((4)*(nqFe));
   memcpy(&SS_qdist_2hr_ptr->qdistC_err[0], data+ptr,  ((4)*(nqC)) );
   ptr+= ((4)*(nqC));
   memcpy(&SS_qdist_2hr_ptr->qdistO_err[0], data+ptr,  ((4)*(nqO)) );
   ptr+= ((4)*(nqO));
   memcpy(&SS_qdist_2hr_ptr->qdistNe_err[0], data+ptr,  ((4)*(nqNe)) );
   ptr+= ((4)*(nqNe));
   memcpy(&SS_qdist_2hr_ptr->qdistMg_err[0], data+ptr,  ((4)*(nqMg)) );
   ptr+= ((4)*(nqMg));
   memcpy(&SS_qdist_2hr_ptr->qdistSi_err[0], data+ptr,  ((4)*(nqSi)) );
   ptr+= ((4)*(nqSi));
   memcpy(&SS_qdist_2hr_ptr->qdistFe_err[0], data+ptr,  ((4)*(nqFe)) );
   ptr+= ((4)*(nqFe));
   memcpy(&SS_qdist_2hr_ptr->qf_qdistC[0], data+ptr,  ((2)*(nqC)) );
   ptr+= ((2)*(nqC));
   memcpy(&SS_qdist_2hr_ptr->qf_qdistO[0], data+ptr,  ((2)*(nqO)) );
   ptr+= ((2)*(nqO));
   memcpy(&SS_qdist_2hr_ptr->qf_qdistNe[0], data+ptr,  ((2)*(nqNe)) );
   ptr+= ((2)*(nqNe));
   memcpy(&SS_qdist_2hr_ptr->qf_qdistMg[0], data+ptr,  ((2)*(nqMg)) );
   ptr+= ((2)*(nqMg));
   memcpy(&SS_qdist_2hr_ptr->qf_qdistSi[0], data+ptr,  ((2)*(nqSi)) );
   ptr+= ((2)*(nqSi));
   memcpy(&SS_qdist_2hr_ptr->qf_qdistFe[0], data+ptr,  ((2)*(nqFe)) );
   ptr+= ((2)*(nqFe));
}
int32 get_vgrp_id_ss_level2_qdist_2hr() {return(vgrp_id_ss_level2_qdist_2hr);}

/*----   V group description function    ----*/

int32 wr_Vgrp_desc_ss_level2_qdist_2hr(char *wr_strval)
{
  strcpy(wr_strval, "The file 'ss_level2_qdist_2hr.h' is shown below, it was used to create the data in the Vgroup named 'VG_SS_qdist_2hr'.\n\n");
  strcat(wr_strval,"/* Id:$ */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"#include \"hdfi.h\"\n");
  strcat(wr_strval,"#include \"ss_qdist.h\"\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"struct SS_qdist_2hr {\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  /* UT time at the start of each record */\n");
  strcat(wr_strval,"  int32   year;                         /* integer year */\n");
  strcat(wr_strval,"  int32   day;                          /* integer day of year */\n");
  strcat(wr_strval,"  int32   hr;                           /* hour of day */\n");
  strcat(wr_strval,"  int32   min;                          /* min of hour */\n");
  strcat(wr_strval,"  float32 sec;                          /* seconds */\n");
  strcat(wr_strval,"  float64 fp_year;                      /* floating point year */\n");
  strcat(wr_strval,"  float64 fp_doy;                       /* floating point Day of YearDOY */ \n");
  strcat(wr_strval,"  float64 ACEepoch;                     /* UT time in sec since 1/1/96 */\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 qdistC[nqC];			/* charge-state distribution for carbon */\n");
  strcat(wr_strval,"  float32 qdistO[nqO];			/* charge-state distribution for oxygen */\n");
  strcat(wr_strval,"  float32 qdistNe[nqNe];\n");
  strcat(wr_strval,"  float32 qdistMg[nqMg];\n");
  strcat(wr_strval,"  float32 qdistSi[nqSi];\n");
  strcat(wr_strval,"  float32 qdistFe[nqFe];\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  float32 qdistC_err[nqC];			/* charge-state distribution for carbon */\n");
  strcat(wr_strval,"  float32 qdistO_err[nqO];			/* charge-state distribution for oxygen */\n");
  strcat(wr_strval,"  float32 qdistNe_err[nqNe];\n");
  strcat(wr_strval,"  float32 qdistMg_err[nqMg];\n");
  strcat(wr_strval,"  float32 qdistSi_err[nqSi];\n");
  strcat(wr_strval,"  float32 qdistFe_err[nqFe];\n");
  strcat(wr_strval,"\n");
  strcat(wr_strval,"  int16 qf_qdistC[nqC];		/* charge-state distribution quality factors for carbon */\n");
  strcat(wr_strval,"  int16 qf_qdistO[nqO];		/* charge-state distribution quality factors for oxygen */\n");
  strcat(wr_strval,"  int16 qf_qdistNe[nqNe];\n");
  strcat(wr_strval,"  int16 qf_qdistMg[nqMg];\n");
  strcat(wr_strval,"  int16 qf_qdistSi[nqSi];\n");
  strcat(wr_strval,"  int16 qf_qdistFe[nqFe];\n");
  strcat(wr_strval,"  \n");
  strcat(wr_strval,"};\n");
  return(0);
}
