#!/usr/bin/perl -w
#
$perlproc = "sfdu_split_recs.pl";
# 
#
#       - RJB - Mar 25, 2021 - initial release
#       - RJB - Dec 09, 2021 - Add test to see if byte reversed data
#       - RJB - Feb 07, 2022 - exit if number of find elements == 1
#
#  usage: sfdu2_split_recs.pl src_dir dest_dir datafile datafile_mod_file
#
#   Program to separate the records in a file created from the output
#   of program od on a Voyager telemetry datafile.
#  
#   Environment variables:
#    <none>
#
#   Input:
#       Output of a unix od command of an sfdu2 file
#
#   Output:
#       The resultant sfdu2 file with records delineated
#
#
#
#   Output:
#
#
use Env;
use POSIX qw(uname);
use Term::ANSIColor;
#use strict;
use warnings;

$argCount = scalar @ARGV;
if (($argCount eq 0)) {
    print color ("blue"), "\n";
    print "\n";
    print "    usage: $perlproc src_dir dest_dir    sfdu2_file         sfdu2_mod_file   ormat\n";
    print "            Ex:       ./       ./      datafile.b.hex    datafile.b.hexmod    hex \n";
    print "\n";
    print "Separate the records in a file created from the output of od on a Voyager afdu2 file\n";
    print "\n";
    print "\n", color("reset");
    exit(0);
}
if (($argCount == 1)) {
    if ($ARGV[0] =~ /-h/i || $ARGV[0] =~ /help/i || $ARGV[0] =~ /\?/i) {
        print color ("blue"), "\n";
        print "    Voyager Project program to Separate the records in a file created from the output of od on a Voyager sfdu2 file\n";
        print "\n";
        print "    usage: $perlproc src_dir dest_dir edr_file         edr_mod_file        format\n";
        print "                     ./       ./      datafile.b.hex    datafile.b.hexmod    hex \n";
        print "\n";
        print "where:\n";
        print "     src_dir is location of input od dump file \n";
        print "     dest_dir is where data is processed and products created\n";
        print "     sfdu2_file is sthe name of input od dump file \n";
        print "     sfdu2_mod_file is the name of the output file with the records separated\n";
        print "     format is the internal format produced by command od\n";
        print "           byte = octal byte format fom command 'od -b'";
        print "           hex  = hex byte format from command 'od -x'";
        print "\n";
        print "\n", color("reset");
        exit;
    }
}
if ($argCount < 5) {
    print color ("red"), "\n";
    print "\n";
    print "Did you forget something?\n\n", color("reset");
    exit(1);
}

#**
#** DECLARATIONS:
#**
#
$byte = "byte";
$data_rec = "   Data Rec ";
$hex = "hex";
$magic_hex = "4e4a";            # "NJ"  #next 2 bytes  504c";
$rev_magic_hex = "4a4e";       # "PN" 
$magic_byte = "116 112";        #120 114" next 2 bytes;   #"NJPL"
$rev_magic_byte = "112 116";    # "PN"
$return = "\n";

#**
#**  ENVIRONMENT
#**
#
#print "ARGV[0] = $ARGV[0]\n";          #src dir
#print "ARGV[1] = $ARGV[1]\n";          #dest dir
#print "ARGV[2] = $ARGV[2]\n";          #edr_file 
#print "ARGV[3] = $ARGV[3]\n";          #edr_mod_file file extension
#print "ARGV[4] = $ARGV[4]\n";          #byte or hex
#
#
$destpath = $ARGV[1];

if (-d $destpath) {
    #
} else {
    print color ("red"), "      ??E destpath = $destpath does NOT exist\n", color("reset");
    exit(1);
}
my $format = $ARGV[4];

if ($format =~ m/byte/ || $format =~ m/hex/ ) {
# print "format = $format\n";
 
} else {
    print color ("red"), "      ??E format not byte or hex";
     print "\n", color("reset");
}
# open that file and find magic 
my $magic_num = 0;          #number of total records
my $eng_num = 0;            #number of engineering records
my $count = 0;
open(INFILE,"$ARGV[2]") || die "Cannot find INFILE: $ARGV[2]\n";
open(OUTFILE,">$ARGV[3]") || die "Cannot open OUTFILE: $ARGV[3]\n";

LINEA: while (<INFILE>) {
    chop;
    $line = $_;
    $count++;
    @find = split (/\s+/, $line);           #split on spacea
    $findcnt = scalar @find;
    exit if ($findcnt == 1);
#    print "$count  = $find[0]: $findcnt:  $find[1]   $rev_magic_hex   $format\n";
    if ($find[1] =~ $rev_magic_hex && $format =~ m/$hex/ ) {
        print color ("red"), "\n";
        print "DATA SET is Byte reversed\n";
        print "PLEASE run byteswap program\n\n", color("reset");
        exit;
    }

    if ($find[1] =~ $rev_magic_byte && $format =~ m/$byte/ ) {
        print color ("red"), "\n";
        print "DATA SET is Byte reversed\n";
        print "PLEASE run byteswap program\n\n", color("reset");
        exit;
    }
  
#    next LINEA if($line =~ m/^\*/ );     # skip lines starting with *
    if ($format =~ m/$hex/ ) {
        if ($line =~ m/$magic_hex/ ) {
            $magic_num++;
#my @find = split / /, $str, 2;
            @find = split( /$magic_hex/, $line );       #split on string
            $nn = @find;
#my $result = index($string, $char);
            $ctr = $magic_num;
            $recid = $data_rec; 
            $posit = index($line,$magic_hex);
#            print "posit = $posit of $magic_hex\n";
# to get variable number of spaces -- perl -e 'print "4"x4; print "\n"'
            $filler = " "x$posit;
#            print "filler = <$filler>";
            if ($nn == 2 ) {
                 $outline = "$find[0]$return$filler$magic_hex$find[1]$recid$ctr\n";
            } else {
                 $outline = "$find[0]$return$filler$magic_hex$recid$ctr\n";
            }
            print OUTFILE $outline;
        } else {
            $outline = "$line$return";
            print OUTFILE $outline;
        }
     }
     if ($format =~ m/$byte/ ) { 
         if ($line =~ m/$magic_byte/ ) { 
                $magic_num++; 
                @find = split (/$magic_byte/, $line);
                $nn = @find;
                $ctr = $magic_num;
                $recid = $data_rec;
                my $posit = index($line,$magic_byte);
                my $filler = " "x$posit;
                if ($nn == 2) {
                    $outline = "$find[0]$return$filler$magic_byte$find[1]$recid$ctr\n";
                } else {
                    $outline = "$find[0]$return$filler$magic_byte$recid$ctr\n";
                }
                print OUTFILE $outline;
         } else {
            $outline = "$line$return";
            print OUTFILE $outline;
         }
     }
}
print "Number of data records   = $magic_num\n";
close (INFILE);
close (OUTFILE);
