/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: sedrate.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *                  add prototypes
 ******************************************************************/
/*
** MANUAL
**	VAXD2PR 3x "July 21, 1992"
** 
** NAME
**	vaxd2pr - VAX VMS double precision floating point format to 
**	parts.
**
** SYNOPSIS
**
**	  #include   "dofloat"
**
**	  void vaxd2pr(vax_float,parts);
**
**	  char        *vax_float;
**	  Float_Twos  *parts;
**
** PARAMATERS
**
**	INPUT
**
**	  vax_float - is a bytes stream of a single precision floating 
**	  point number in VMS VAX format.
**
**	OUTPUT
**
**	  parts - is a structure of parts of a floating point number.
**	  
** STRUCTURE
**
**	  typedef struct float_twos Float_Twos;
**
**	  struct float_twos
**	  {
**	       short int  characteristic;  power of twos characteristic
**	       BOOL	      sign_bit;    TRUE minus, FALSE positive.
**	       char       mantisa[7];      mantisa left adjsted no 
**	                                   implied leading one ala IEEE 
**	                                   standard.
**	  } ;
**
** EXTERNS
**
**	   1. int  mindx_0 - index for storing leading byte into proper
**	      place in int.
**	   2. int  mindx_1 - index for storing next byte into proper 
**	      place in int.
**
** DESCRIPTION
**
**	vaxs2pr takes a double precision floating point number, in VMS
**	VAX format and breaks it down into parts.
**
**	The VAX floating point format is
**	              1           2           3
**	 [01234567][89012345][67890123][45678901]
**	 [scharact][exxxxxxx][xxxxxxxx][xxxxxxxx]etc
**	           ^1
**
**	where 's' is the sign bit, characte is the 8 bit characteristic,
**	in powers of two, ^ is the implied decimal point, 1 is the 
**	implied leading one of the mantisa and xxx etc is the rest of 
**	the mantisa. The characteristic is biased at ?.
**
**	This all fine except that in the VMS system every other byte is
**	swapped so that the first two bytes from above look like
**
**	  [exxxxxxx][scharact]
**
**	The VAX VMS characteristic is biased at 0x80 in hex.
**
**	mindx_0 and mindx_1 are needed for two reasons
**
**	  1. All bit manipulations are done as if the int were two 
**	     bytes and not 4, this makes the calculations machine 
**	     indepentent.
**	  2. On some machines like the VMS VAX the bytes in the int are 
**	     swapped as compared to an IBM3090 or a SUN etc. mindx_0, 
**	     and mindx_1 are calculated in 'machistor' and account for 
**	     this difference.
**
**	The mantisa in parts is output in proper byte order not machine
**	dependent order, the characteristic is machine dependent 
**	short int.
**
*/
#endif /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"VCXD2PR0") csect(STATIC,"VCXD2PR1")
#endif

#include	<stdio.h>
#include	<dofloat.h>

#if (NOPROTO)
extern	void	partieee();
#else
extern	void	partieee();
#endif

void vaxd2pr(vax_float,parts)

char		*vax_float;
Float_Twos	*parts;

{

int	i;
Unn	un;
Unn	un1;

/* begin */

/*bring in [sxxxxxxx][scharact] in proper order*/
if (mindx_0 < 0)
{
	partieee();
}

un.uint = 0;
un.uchar[mindx_0] = vax_float[1];
un.uchar[mindx_1] = vax_float[0];
if (un.uint == 0)
{
        /*its all zero here*/
        parts->characteristic = 0;
        parts->sign_bit = FALSE;
        for ( i = 0 ; i < 7 ; i++)
        {
                parts->mantisa[i] = 0;
        }
        return;
}
/*now we have [scharact][exxxxxxx]*/
/*find sign bit*/
if (un.uint & 0x8000)
{
	/*minus*/
	parts->sign_bit = TRUE;
}
else
{
	/*positive*/
	parts->sign_bit = FALSE;
}
/*shift left by one*/
un.uint <<= 1;
un1.uint = 0;
un1.uchar[mindx_1] = un.uchar[mindx_0];
/*subtract bias from characteristic*/
parts->characteristic = un1.uint - VAXVMS_BIAS;
un.uint = 0;
/*bring in first byte of mantisa [exxxxxxx]*/
un.uchar[mindx_1] = vax_float[0];
/*place implied one*/
un.uint |= 0x80;
/*store in mantisa*/
parts->mantisa[0] = un.uchar[mindx_1];
/*ok now swap every other byte*/
un.uint = 0;
/*zero rest of mantisa*/
for (i = 2 ; i < 7 ; i += 2)
{
	parts->mantisa[i-1] = vax_float[i+1];
	parts->mantisa[i] = vax_float[i];
}
return;
}
