/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
/*                  1234567                  1234567 */
#pragma csect(CODE,"TCJLSTS0") csect(STATIC,"TCJLSTS1")
#endif

#include	<stdio.h>
#include	<sedrdspg.h>

char	*xlab[] = {
"E-P ","S-P ","5-P ","15-P","25-P","35-P","45-P","S-E ",        
"S-5 ","5-E ","5-15","5-25","5-35","5-45","S-6 "};               
char	*rlab[] = {
"E-P ","S-P ","S-E ","S-5 ","5-P ","5-15","5-25","5-35","5-45"};                                                         
char	*alab[] = {
"E-S-P","S-P-E","S-E-P","5-S-P","S-P-5","S-5-P","E-P-5","  SAA"
};                                                        
char	*clab1[] = {
/*123456","123456","123456","123456","123456","123456","123456*/
 "      ","JTO&S ","  JUP ","  JUP ","JUP MA","      " };                      
char	*clab2[] = {
/*123456","123456","123456","123456","123456","123456","123456*/
 "ECL50 ","UN PM ","SYS 1 ","SYS 3 ","G SYS ","      "};                      

void
trjlstsedr(rbuf)

float	*rbuf;

{

int	i;
int	j;
int	k;
int	n;
int	i1;
int	i2;
                                                                           
/*-----PRINT CARTESIAN STATES     */                                               
                                                                              
fprintf(fdout,
" ***CARTESIAN STATES                        X                ");
fprintf(fdout,
"Y                Z             VX          VY          VZ\n");         
/*-----ECL50 STATE VECTORS    */                                                   
i = 31;                                                                   
j = 36;                                                                   
k = 1;                                                                  
fprintf(fdout,
	" %s%s(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f%12.3f%12.3f%12.3f\n",
	clab1[k-1],clab2[k-1],i,j,xlab[k-1],
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);

for ( i = 37 ; i <= 109 ; i+=6)
{
	j = i+5;
	k = i/6 - 4;
	fprintf(fdout,
		" %s%s(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f%12.3f%12.3f%12.3f\n",
		clab1[5],clab2[5],i,j,xlab[k-1],
		rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);
}

/*-----PRINT JTO & PM IN SUN DIRECTION STATE VECTORS*/                          

i = 115;
j = 120;
k = 2;                                                                               
fprintf(fdout,
	" %s%s(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f%12.3f%12.3f%12.3f\n",
	clab1[k-1],clab2[k-1],i,j,xlab[k-1],
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);
for ( i = 121 ; i <= 139 ; i+=6)
{
	j = i+5;
	k = i/6 - 9;
	fprintf(fdout,
		" %s%s(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f%12.3f%12.3f%12.3f\n",
		clab1[5],clab2[5],i,j,xlab[k-1],
		rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);
}
                                                                              
/*-----PRINT SYS 1 & 3 STATE VECTORS & POSITIONS */                                

for ( n = 145 ; n <= 163 ; n+=18)
{
	j = n+5;
	k = n/18 - 5;                                                                               
	fprintf(fdout,
		" %s%s(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f%12.3f%12.3f%12.3f\n",
		clab1[k-1],clab2[k-1],n,j,xlab[2],
		rbuf[n-1],rbuf[n],rbuf[n+1],rbuf[n+2],rbuf[n+3],rbuf[n+4]);
	i1 = n+6;
	i2 = i1+9;
	for ( i = i1 ; i <= i2 ; i+=3)
	{
		j = i + 2;
		k = i/3 - n/3 + 9;
		fprintf(fdout,"             ");
		fprintf(fdout,
			"(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f\n",
			i,j,xlab[k-1],
			rbuf[i-1],rbuf[i],rbuf[i+1]);
	}                                                          
}
                                                                               
/*-----PRINT JUP MAG COORD STATE VECTORS*/                                         

for ( i = 249 ; i <= 255 ; i+=6)
{
	j = i+5;
	k = i/6 - 36;
	i1 = (i/252)*8 + 3;
	fprintf(fdout,
		" %s%s(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f%12.3f%12.3f%12.3f\n",
		clab1[k-1],clab2[k-1],i,j,xlab[i1-1],
		rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);
}
                                                                               
/*-----PRINT ECL50 SUN TO SATURN VECTOR  */                                        

i = 268;
j = 273;
fprintf(fdout,
	" %s%s(WDS %3d-%3d):  %s%17.3f%17.3f%17.3f%12.3f%12.3f%12.3f\n",
	clab1[0],clab2[0],i,j,xlab[14],
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);

                                                                               
/*-----PRINT SYS 1 & 3 LAT"S & LON"S */
i = 181;                                            
fprintf(fdout,
	" ***JUP LAT, SYS 1 & 3 LON (WDS 181-195):  P ");
fprintf(fdout,
	"%9.3f%9.3f%9.3f     15%9.3f%9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);
i +=6;
fprintf(fdout,
	"         25%9.3f%9.3f%9.3f     35%9.3f%9.3f%9.3f",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);
i += 6;                                                                               
fprintf(fdout,
	"     45%9.3f%9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1]);

/*-----PRINT RANGES */                                                             
fprintf(fdout,
	" ***RANGES (WDS 196-204):");
for (i  = 196 ; i <= 199 ; i++)
{
	fprintf(fdout,
		"    %s%17.3f ",
		rlab[i-196],rbuf[i-1]);
}
fprintf(fdout,"\n");
for (i  = 200 ; i <= 204 ; i++)
{
	fprintf(fdout,
		"   %s%17.3f  ",
		rlab[i-196],rbuf[i-1]);
}
fprintf(fdout,"\n");
                                                                               
/*-----PRINT ANGLES*/                                                              
fprintf(fdout,
	" ***ANGLES (WDS 205-212):    ");
for (i = 205 ; i <= 209 ; i++)
{
	fprintf(fdout,
		"%s%9.3f     ",
		alab[i-205],rbuf[i-1]);
}
fprintf(fdout,
	"\n                        ");
for ( i = 210 ; i <=212 ; i++)
{
	fprintf(fdout,
		"     %s%9.3f",
		alab[i-205],rbuf[i-1]);
}
fprintf(fdout,"\n");                                                                             
/*-----PRINT EARTH EME50 RA"S & DEC"S */                                           
i = 213;
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	" ***EARTH RA & DEC, EME50 (WDS 213-218):            P ");
fprintf(fdout,
	"%9.3f%9.3f     S %9.3f%9.3f     5 %9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);                                                                                
                                                                               
/*-----PRINT JUP RA & DEC OF DATE*/                                               
i = 219;
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	" ***JUP RA & DEC, JTE&E OF DATE (WDS 219-230):      P ");
fprintf(fdout,
	"%9.3f%9.3f     S %9.3f%9.3f     15%9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);                                                                                
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	"                                                    25");
i = 225;
fprintf(fdout,
	"%9.3f%9.3f     35%9.3f%9.3f     45%9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);                                                                                
	                                                                                                                                                              
/*-----PRINT SUN CELSTIAL LAT"S & LON"S*/                                         
i = 231;
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	" ***SUN CEL LAT & LON, ETE&E OF DATE (WDS 231-236): S ");
fprintf(fdout,
	"%9.3f%9.3f     E %9.3f%9.3f     5 %9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);                                                                                
                                                                               
/*-----PRINT SUN RA"S & DEC"S */                                                   

                                                                               
i = 237;
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	" ***SUN RA & DEC, STE&E OF DATE (WDS 237-242):      S ");          
fprintf(fdout,
	"%9.3f%9.3f     E %9.3f%9.3f     5 %9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);                                                                                
                                                                               
/*-----PRINT HELIOGRAPHIC LAT & LON*/                                              
i = 243;
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	" ***HELIO LAT & LON (WDS 243-248):                  S ");                                                                              
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	"%9.3f%9.3f     E %9.3f%9.3f     5 %9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3],rbuf[i+4]);                                                                                
                                                                               
/*-----PRINT JUP MAG INFO */                                                       

i = 261;
fprintf(fdout,
/*                1         2         3         4         5         6*/
/*       123456789012345678901234567890123456789012345678901234567890*/
	" ***JUP MAG RANGE, LAT & LON (WDS 261-265):        5-P ");
fprintf(fdout,
	"%17.3f     P %9.3f%9.3f     15%9.3f%9.3f\n",
	rbuf[i-1],rbuf[i],rbuf[i+1],rbuf[i+2],rbuf[i+3]);                                                                                
                                                                              
return;
}
