/*****************************************************************
 * TITLE: sedrate.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *                  add prototypes
 ******************************************************************
 *           */

#include	<stdio.h>
#include	<string.h>
#include	<math.h>
#include	<stdlib.h>
#include	<glbltme.h>
#include	<dictmerr.h>
#include	<streader.h>
#include	<scet2clk.h>
#include	<ahfreadr.h>
#include	<sedrgl.h>
#include	<mchdblst.h>
#include	<sedrdspg.h>
#include	<dofloat.h>

#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"SCDRULS0") csect(STATIC,"SCDRULS1")
#endif
#if (NOPROTO)
extern	void	dictmcnv();
extern	void	diclkcnv();
extern	int	cnvs2dbl();
extern	int	streader();
extern	int	ahfreadr();
extern	void	sedrinit();
extern	int	rateintrvl();
extern	int	prntsummary();
extern	int	dbl2fltsedr();
extern	void	crftnav();
#else
extern	void	dictmcnv(long int *,char *,char *,DBL *,char *,
			  char *,char *,char *,char *);
extern	void	diclkcnv(long int *,char *,DBL *,char *,char *,
			  char *,char *,char *);
extern	int	cnvs2dbl(char *,DBL *);
extern	int	streader(char *,char *);
extern	int	ahfreadr(char *,char *);
extern	void	sedrinit();
extern	int	rateintrvl();
extern	int	prntsummary(SFFPROTO);
extern	int	dbl2fltsedr(DBL *,int,float *,int,int);
extern	void	crftnav(DBL *,DBL *);

/* protoypes */
int sedruls(void);
static open_files(void);
static hdr_info(void);
static read_save_file(void);
static check_for_another_file(void);
static get_st_hdr_info(void);
static first_traj_rec(void);
static bgn_end_etc(void);
static flip_flop_buffers(void);
static get_sclk(void);
static get_ahf(void);
static create_old_sfdu_hdr(void);
static calcndx(void);
static chng2int(void);
static chng2flt(void);

#endif

static BOOL		alreadyeod = FALSE;

sedruls()

{


char	*pntr;
int	len;
int	len1;
int	i;
int	lpr;

rtc = open_files();
if (rtc < 0)
{
	exit(-1);
}

/*ok now do what is needed*/
/*find machine type for big or little indian ordering*/
rtc = hdr_info();
if (rtc < 0)
{
	exit(-1);
}
strcpy(STLR.group_id,"DATA");
strcpy(STLR.item,"VALUES");
STLR.rec_numbr = 0;
/*start at 1 not zero, a lot of routines were once FORTRAN and it's
  counting starts at 1 not zero*/
STLR.numbr_items = 409;
strcpy(option_traj,"READ");
strcpy(option_coef,"SCLK");
use_buf = 'A';
is_first_traj_rec = TRUE;
curr_traj_pntr = traj_recsa;
next_traj_pntr = traj_recsb;
onemore_traj_pntr = traj_recsc;
traj_pntr = traj_recsa;
/*set up for the constatns of the primary and secondary headers*/
create_old_sfdu_hdr();
/*get the powers too convert floating point to fixed point*/
calcndx();
strcpy(sclk_type_in,"DPSCLK");
AHFLR.eod = FALSE;
for (;;)
{
	rtc = read_save_file();
	if (rtc)
	{
		break;
	}
	/*get times etc*/
	traj_time = traj_pntr[1] - traj_pntr[6];
	if (is_first_traj_rec)
	{
		curr_traj_time = traj_time;
		is_first_traj_rec = FALSE;
		rtc = first_traj_rec();
		if (rtc)
		{
			break;
		}
	}
	curr_traj_time = curr_traj_pntr[1] - curr_traj_pntr[6];
	if (next_traj_pntr != NULL)
	{
		next_traj_time = next_traj_pntr[1] - next_traj_pntr[6];
                if (onemore_traj_pntr != NULL)
		{
			onemore_traj_time = onemore_traj_pntr[1] -
					    onemore_traj_pntr[6];
		}
		else
		{
			onemore_traj_time = 0.0;
		}
	}
	else
	{
		next_traj_time = 0.0;
	}
	rtc = bgn_end_etc();
	if (rtc)
	{	
		if (rtc == 1)
		{
			break;
		}
		flip_flop_buffers();
		prev_traj_time = curr_traj_time;
		continue;
	}
	rtc = sedrate();
	if (rtc)
	{
		if (next_traj_pntr == NULL)
		{
			break;
		}
		flip_flop_buffers();
		prev_traj_time = curr_traj_time;
		continue;
	}
	if (!n_traj_recs)
	{
		sttraj = curr_traj_time;
	}
	entraj = curr_traj_time;
	n_traj_recs++;
	if (!numtrjp)
	{
		intrvl_sttraj = curr_traj_time;
	}
	numtrjp++;
	/*get time here*/
	dptimes[CFLS.time_indx] = curr_traj_time;
	dictmcnv(tarray,NULL,NULL,dptimes,NULL,CFLS.time_type,
		 time_type_out,&hdr_buf[10],rtcode);
	/*get sclk here*/
	get_sclk();
	get_ahf();
	/*compute angle rotations etc for traj record*/
	crftnav(curr_traj_pntr,sedr_rec);
	/*convert to whatever and write out*/
	chng2int();
	chng2flt();
	/*set up double buffering*/
	if (next_traj_pntr == NULL)
	{
		break;
	}
	flip_flop_buffers();
	prev_traj_time = curr_traj_time;
}

rtc = streader("CLOSE",(char *)&STLC);
rtc = scet2clk("CLOSE",(char *)&CFLC);
if (start_intrvals != NULL)
{
	prev_traj_time = curr_traj_time;
        lasrate = currate;
	rtc = rateintrvl();
}
prntsummary(sumfd);
SFFCLOSE(sumfd);
if (use_file)
{
	SFFCLOSE(fdout);
}
return(0);
}

/**************************************************************/
static
open_files()


{

STMULT	*curr_m;

curr_m = (STMULT *)start_mult;
curr_mult = start_mult;
strcpy(STLO.filename,curr_m->filename);
/*open trajectory twista save file*/
rtc = streader("OPEN",(char *)&STLO);
if (rtc < 0)
{
	return(-1);
}
STLR.stfd = STLO.stfd;
STLC.stfd = STLO.stfd;

/*open coefficient file*/

rtc = scet2clk("OPEN",(char *)&CFLO);
if (rtc < 0)
{
	return(-1);
}
CFLS.cffd = CFLO.cffd;
CFLC.cffd = CFLO.cffd;

rtc = ahfreadr("OPEN",(char *)&AHFLO);
if (rtc < 0)
{
	return(-1);
}
AHFLC.ahffd = AHFLO.ahffd;
AHFLR.ahffd = AHFLO.ahffd;
SFFOPEN(sumfd,summary_file,SFWRTONLY);
if (SFFERROPEN(sumfd))
{
	fprintf(fdout,
		"Error in opening summary file %s\n",
		summary_file);
	exit(-1);
}

SFFOPEN(fixfd,fixed_file_name,SFWRTONLYB);
if (SFFERROPEN(fixfd))
{
	fprintf(fdout,
		"Error in opening fixed file %s\n",
		fixed_file_name);
	exit(-1);
}
SFFOPEN(fltfd,float_file_name,SFWRTONLYB);
if (SFFERROPEN(fltfd))
{
	fprintf(fdout,
		"Error in opening float file %s\n",
		float_file_name);
	exit(-1);
}
return(0);
}
/**************************************************************/
static
hdr_info()

{

char	*pntr;

strcpy(type_in,"CURR");
strcpy(type_out,"MDY");
/*get time here*/
dictmcnv(tarray,mon,dow,dptimes,end_time,type_in,
		 type_out,strng,rtcode);
if (rtcode[3] == 'X')
{
	fprintf(fdout,"error in getting current time. Error is %s\n",
		rtcode);
}
else
{
	pntr = strchr(strng,'.');
	if (pntr != NULL);
	pntr[0] = '\0'; /*stop at period. No milliseconds printed*/
	fprintf(fdout,"\nCurrent time for SEDR is %s %s\n\n",
		dow,strng);
	/*compute yyddd*/
	sedrgen_yyddd = (YEAR%100 )*1000 + DOY;
	/*compute hhmmss*/
	sedrgen_hhmmss = HOUR*10000 + MINUTE*100 + SECOND;
}
get_st_hdr_info();
if (bgn_time[0] != '\0')
{
	/*there is a begin time*/
	strcpy(type_in,"CHAR");
	strcpy(type_out,"DOY");
	/*get time here*/
	dictmcnv(tarray,NULL,NULL,dptimes,bgn_time,type_in,
		 type_out,strng,rtcode);
	if (rtcode[3] == 'X')
	{
		fprintf(fdout,"error in begin time %s. Error is %s\n",
			bgn_time,rtcode);
		exit(-1);
	}
	start_time = dptimes[time_indx]; /*double precision seconds past EPOCH*/
	fprintf(fdout,
		"Start at %s\n",strng);
}
else
{
	fprintf(fdout,
		"Start at record number 1\n");
}
use_this_time_4_start = start_time;
if (end_time[0] != '\0')
{
	/*there is an end time*/
	strcpy(type_in,"CHAR");
	strcpy(type_out,"DOY");
	/*get time here*/
	dictmcnv(tarray,NULL,NULL,dptimes,end_time,type_in,
		 type_out,strng,rtcode);
	if (rtcode[3] == 'X')
	{
		fprintf(fdout,"error in end time %s. Error is %s\n",
			end_time,rtcode);
		exit(-1);
	}
	stop_time = dptimes[time_indx]; /*double precision seconds past EPOCH*/
	fprintf(fdout,
		"End at %s\n",strng);	
}
else
{
	fprintf(fdout,"Until End of file\n");
}
return(0);
}
/*************************************************************************/
static
read_save_file()

{
rtc = 0;
if (onemore_traj_pntr == NULL)
{
	next_traj_pntr = NULL;
}
else
{
	STLR.buf = (char *)&traj_pntr[1];
	rtc = streader(option_traj,(char *)&STLR);
	if (rtc < 0)
	{
		return(-1);
	}
	if (rtc == 0   ||   STLR.eod)
	{
		rtc = check_for_another_file();
		if (rtc)
		{
			return(rtc);
		}
	}
}
return(0);
}
/**************************************************************************/
static
check_for_another_file()

{

char	*save_buf;
STMULT	*curr_m;
DBL	time_to_check;
DBL	*new_traj_pntr;

/*eof here*/
/*get next file if any*/
curr_m = (STMULT *)curr_mult;
if (curr_m->next != NULL)
{
	/*close old file here*/
	save_buf = STLR.buf;
	rtc = streader("CLOSE",(char *)&STLC);	
	/*set up open here*/
	curr_mult = curr_m->next;
	curr_m = (STMULT *)curr_m->next;
	strcpy(STLO.filename,curr_m->filename);
	fprintf(fdout,
		"\nSecond file %s is about to be opened\n",
		second_st_file);
	/*open trajectory twista save file*/
	rtc = streader("OPEN",(char *)&STLO);
	if (rtc < 0)
	{
		fprintf(fdout,"File cannot be opened\n\n");
		return(-1);
	}
	second_st_file[0] = '\0';
	STLC.stfd = STLO.stfd;
	STLR.stfd = STLO.stfd;
	use_this_time_4_start = 0;
	get_st_hdr_info();
	strcpy(STLR.group_id,"DATA");
	strcpy(STLR.item,"VALUES");
	STLR.rec_numbr = 0;
	/*start at 1 not zero, a lot of routines were once FORTRAN and it's
	  counting starts at 1 not zero*/
	STLR.numbr_items = 409;
	STLR.buf = save_buf;
	for (;;)
	{
		/*check on times*/
		rtc = streader(option_traj,(char *)&STLR);

		if (rtc < 0)
		{
			return(-1);
		}
		if (rtc == 0   ||   STLR.eod)
		{
			switch (n_traj_recs)
			{
				case 0:
					fprintf(fdout,
					"EOD found for TWIST SAVE file\n");
					return(1);
				break;
				case 1:
					next_traj_pntr = NULL;
					onemore_traj_pntr = NULL;
				break;
				default:
					onemore_traj_pntr = NULL;
				break;
			}
		}
		new_traj_pntr = (DBL *)STLR.buf;
		if (new_traj_pntr[0] + new_traj_pntr[5] > onemore_traj_time)
		{
			break;
		}
	}
}
else
{
	switch (n_traj_recs)
	{
		case 0:
			fprintf(fdout,
			"EOD found for TWIST SAVE file\n");
			return(1);
		break;
		case 1:
			next_traj_pntr = NULL;
			onemore_traj_pntr = NULL;
		break;
		default:
			onemore_traj_pntr = NULL;
		break;
	}
}
return(0);
}

/**************************************************************/
static
get_st_hdr_info()

{

strcpy(STLR.group_id,"ID");
strcpy(STLR.item,"FILE-NAME");
STLR.rec_numbr = 0;
STLR.buf = traj_other;
STLR.numbr_items = 0;
rtc = streader("READ",(char *)&STLR);
if (rtc < 0)
{
	exit(-1);
}
fprintf(fdout,"\n%s  %s\n",STLR.item,traj_other);
strcpy(STLR.item,"FINGERPRINTS");
rtc = streader("READ",(char *)&STLR);
if (rtc < 0)
{
	exit(-1);
}
fprintf(fdout,"\n%s  %s\n",STLR.item,traj_other);
STLR.buf = (char *)&julian_date;
strcpy(STLR.item,"REF-JDATE");
rtc = streader("READ",(char *)&STLR);
if (rtc < 0)
{
	exit(-1);
}
/*set up times here*/
if (julian_date <= 2433283.5) /*julian date of 1950 + 1 day*/
{
	/*this is 1950*/
	CFLS.time_indx = 0; /*first dp slot*/
	strcpy(CFLS.time_type,"DP50");
	AHFLR.time_indx = 0; /*first dp slot*/
	time_indx = 0;
	strcpy(AHFLR.time_type,"DP50");
	strcpy(time_type_in,"DP50");
	strcpy(time_type_out,"CCSDSBUNSG5");
}
else
{
	/*2000 here*/
	CFLS.time_indx = 1;
	strcpy(CFLS.time_type,"DP2000");
	AHFLR.time_indx = 1;
	time_indx = 1;
	strcpy(AHFLR.time_type,"DP2000");
	strcpy(time_type_in,"DP2000");
	strcpy(time_type_out,"CCSDSBUNSG2");
}
return(0);
}
/********************************************************************/
static
first_traj_rec()

{

/*do second record here*/
traj_pntr = traj_recsb;
STLR.buf = (char *)&traj_pntr[1];
rtc = streader(option_traj,(char *)&STLR);
if (rtc < 0)
{
	exit(-1);
}
if (rtc == 0)
{
	next_traj_pntr = NULL;
	onemore_traj_pntr = NULL;
	/*eof here*/
	return(1);
}
if (STLR.eod)
{
	fprintf(fdout,
		"EOD found for TWIST SAVE file\n");
	next_traj_pntr = NULL;
	onemore_traj_pntr = NULL;
	return(1);;
}
/*do third record here for whatever*/
traj_pntr = traj_recsc;
STLR.buf = (char *)&traj_pntr[1];
rtc = streader(option_traj,(char *)&STLR);
if (rtc < 0)
{
	exit(-1);
}
if (rtc == 0)
{
	/*eof here*/
	return(1);
}
if (STLR.eod)
{
	fprintf(fdout,
		"EOD found for TWIST SAVE file\n");
	onemore_traj_pntr = NULL;
	return(1);;
}
return(0);
}
/*****************************************************************/
static
bgn_end_etc()

{

if (use_this_time_4_start > 0)
{
	/*check start time here*/
	if (curr_traj_time < use_this_time_4_start)
	{
		/*it is to early*/
		return(2);
	}
}
if (stop_time > 0)
{
	if (stop_time < curr_traj_time)
	{
		fprintf(fdout,"Stop time %s found",
			end_time);
		return(1);
	}
}
return(0);
}
/*********************************************************************/
static
flip_flop_buffers()

{

switch (use_buf)
{
	case 'A': /*traj_recsa is current*/
		traj_pntr = traj_recsa; /*this will now be onemore*/
		use_buf = 'B';
		curr_traj_pntr = traj_recsb;
		if (next_traj_pntr == NULL)
		{
			break;
		}
		next_traj_pntr = traj_recsc;
		if (onemore_traj_pntr == NULL)
		{
			break;
		}
		onemore_traj_pntr = traj_recsa;
	break;
	case 'B': /*traj_recsb is current*/
		traj_pntr = traj_recsb; /*this will now be onemore*/
		use_buf = 'C';
		curr_traj_pntr = traj_recsc;
		if (next_traj_pntr == NULL)
		{
			break;
		}
		next_traj_pntr = traj_recsa;
		if (onemore_traj_pntr == NULL)
		{
			break;
		}
		onemore_traj_pntr = traj_recsb;
	break;
	case 'C': /*traj_recsc is current*/
		traj_pntr = traj_recsc; /*this will now be onemore*/
		use_buf = 'A';
		curr_traj_pntr = traj_recsa;
		if (next_traj_pntr == NULL)
		{
			break;
		}
		next_traj_pntr = traj_recsb;
		if (onemore_traj_pntr == NULL)
		{
			break;
		}
		onemore_traj_pntr = traj_recsc;
	break;
	default:
		fprintf(stderr,
			"Error in flip flop\n");
		exit(-1);
}
return;
}
/*****************************************************************/
static
get_sclk()

{


CFLS.scet = curr_traj_time;
rtc = scet2clk(option_coef,(char *)&CFLS);
if (rtc < 0)
{
	exit(-1);
}
if (CFLS.eod)
{
	if (!alreadyeod)
	{
		alreadyeod = TRUE;
		fprintf(fdout,
			"EOD found for coefficient file\n");
	}
}
diclkcnv(carray,"ULS",&CFLS.sclk,tstrng,sclk_type_in,NULL,
	                NULL,rtcode);
/*carray[4,5] 6 bytes of raw clock*/
memcpy(&hdr_buf[32],&carray[4],6);
return(0);
}
/**********************************************************************/
static
get_ahf()


{

int	rtc;
int	i;
double	ra;
double	dec;
double	eps;
double	lattitude;
double	longitude;
double	sinlam;
double	coslam;

AHFLR.traj_time = curr_traj_time;
rtc = ahfreadr("READ",(char *)&AHFLR);
if (rtc < 0)
{
	exit(-1);
}
if (rtc  &&  !AHFLR.interpolate)
{
	/*set for no attitude history info*/
	for ( i = 1 ; i <= 4 ; i++)
	{
		hdr_buf_li[i+18] = 0;
		sedr_rec[i+25] = 1000.0;
	}
	return;
}
/*is ok here*/
hdr_buf_li[19] = AHFLR.ahfst_yyddd;
hdr_buf_li[20] = AHFLR.ahfst_hhmmss;
hdr_buf_li[21] = AHFLR.ahfen_yyddd;
hdr_buf_li[22] = AHFLR.ahfen_hhmmss;
hdr_buf_li[23] = AHFLR.ahfind;
sedr_rec[26] = AHFLR.ahfra;
sedr_rec[27] = AHFLR.ahfdec;
/********************************************************************
-----COMPUTE CELESTIAL LONGITUDE AND LATITUDE                          00310000
C                                                                       00320000
      RA = SEDRBUF(26)/RADEG                                            00330000
      DEC = SEDRBUF(27)/RADEG                                           00340000
      EPS = 23.00 + 26.0/60.0 + 44.84/3600.00                           00350000
      EPS = EPS/RADEG                                                   00360000
***********************************************************************/
ra = AHFLR.ahfra/raddeg;
dec = AHFLR.ahfdec/raddeg;
eps = (23.00 + 26.0/60.0 + 44.84/3600.00)/raddeg;
/********************************************************************
      LAT = ASIN(SIN(DEC)*COS(EPS) - COS(DEC)*SIN(RA)*SIN(EPS))         00370000
      SINLAM = (SIN(DEC)-SIN(LAT)*COS(EPS))/(COS(LAT)*SIN(EPS))         00380000
      COSLAM = COS(DEC)*COS(RA)/COS(LAT)                                00390000
      LONG = ATAN2(SINLAM,COSLAM)                                       00400000
***********************************************************************/
lattitude = asin(sin(dec)*cos(eps) - cos(dec)*sin(ra)*sin(eps));
sinlam = (sin(dec) - sin(lattitude)*cos(eps))/
	 (cos(lattitude)*sin(eps));
coslam = cos(dec)*cos(ra)/cos(lattitude);
longitude = atan2(sinlam,coslam);
sedr_rec[28] = lattitude*raddeg;
longitude *= raddeg;
for (;;)
{
	if (longitude >= 0.0 && longitude < 360.0)
	{
		break;
	}
	if (longitude < 0.0)
	{
		longitude += 360.0;
	}
	else
	{
		longitude -= 360.0;
	}
}
sedr_rec[29] = longitude;
return;
}
/******************************************************************************/	
static
create_old_sfdu_hdr()

{

int	i;
union {

	long	int	li;
	char	ci[4];
} u;

hdr_buf[0] = 0x10; /*label version 0001 + character set 00
			unit structure type 00 */
hdr_buf[1] = 100;  /*start of message pointer, bytes*/
hdr_buf[2] = 0x14; /*control auth 000101 + system class 00;010 (00010100)*/
hdr_buf[3] = 0x42; /*system class (00);010  + 2ndary Hdr id 00010 
			(0100 0010)*/
u.li = 1152;
/*least sig first*/
hdr_buf[5] = u.ci[li_byte_indx[0]];
hdr_buf[4] = u.ci[li_byte_indx[1]]; /*total length of record in bytes*/
hdr_buf[6] = 0x43; /*originator id*/
hdr_buf[7] = 0x43; /*last modifier id*/
hdr_buf[8] = 0x6; /*major type*/
hdr_buf[9] = type_sedr; /*minor 0 for predict,1 final, 2 special*/
/*hdr_buf[10,11,12,13,14,15] scet*/
/*zero fill unused portion*/
for (i = 16 ; i <= 23; i++)
{
	hdr_buf[i] = 0;
}
hdr_buf[23] = 1; /*Message content status*/ 
hdr_buf[24] = 0x03; /*mission id Ulysses*/
hdr_buf[25] = 55; /*spacecraft id*/
hdr_buf[26] = 0;
hdr_buf[27] = 0;
hdr_buf[28] = 0x03; /*tertiary header id*/
hdr_buf[29] = 1; /*number data groups*/
hdr_buf[30] = 0;
hdr_buf[31] = 0;
/*hdrbuf[32,33,34,35,36,37] raw sclk*/
/*end of secondary header*/
for (i = 38 ; i < 100; i++)
{
	hdr_buf[i] = 0;
}
/*bring in package id and genration time*/
hdr_buf_li[12] = package_id;
hdr_buf_li[13] = sedrgen_yyddd;
hdr_buf_li[14] = sedrgen_hhmmss;
return;
}
/*****************************************************************************/
static
calcndx()

{                                               


int	i;
int	j;
int	jj;
                                                                       
/* calculate index once and for all here  */                               
                                             
/*calculate the powers of 10 for scaling floating point to                
  integers  */
                                                              
          for (i = 1 ; i <= 288 ; i++)
          {                                              
              iscale[i] = 0;                                           
          }                                                        
          for (i = 26 ; i <= 274 ; i++)
          {                                                
            iscale[i] = 0;                                              
          }                                                        
          for (i = 26 ; i <= 29 ; i++)
          {                                                 
            iscale[i] = -4;                                             
          }                                                        
          for ( i = 34 ; i <= 145 ; i+= 6)
          {                                                 
            for (j = 1 ; j <= 3 ; j++)  
            {                                             
              jj = i-1 + j;                                            
              iscale[jj] = -6;                                         
            }                                                      
          }                                                        
          for (i = 148 ; i <= 150 ; i++)
          {                                               
            iscale[i] = -4;                                            
          }                                                        
          for (i = 166 ; i <=168 ; i++)
          {                                               
            iscale[i] = -4;                                             
          }                                                        
          for (i = 181 ; i <= 195 ; i++)
          {                                               
            iscale[i] = -4;                                            
          }                                                        
          for (i = 205 ; i <= 248 ; i++)
          {                                              
            iscale[i] = -4;                                             
          }                                                        
          for (i = 252 ; i <= 260 ; i += 6)
          {                                             
             for (j = 1 ; j <= 3 ; j++)
             {                                               
               jj = i-1 + j;                                           
               iscale[jj] = -6;                                        
             }                                                     
          }                                                        
          for (i = 262 ; i <= 267 ; i++)
          {                                               
            iscale[i] = -4;                                             
          }                                                        
          for (i = 271 ; i <= 273 ; i++)
          {                                               
            iscale[i] = -6;                                             
          }                                                        
      return;                                                           
}                                                           
		
/**********************************************************************/
static
chng2int()

{

int	i;
int	j;
DBL	sign;
DBL	out;
double	x10 = 10.;
DBL	scafac;
union {
	long	int	scaled_float;
	char	sc_flt_chr[sizeof(long int)];
} u; 

union {
	long	int	li;
	char	ci[sizeof(long int)];
} uo;
int	wrt;
                                           
/* chng2int ouputs intiger for floating formats                             
  -----compute integer format record*/                                     
 if (first_fixed_wrt)
{
	first_fixed_wrt = FALSE;
	hdr_buf_li[24] = 1;           
	wrt = SFFWRITE(fixfd,hdr_buf,buf_wrt_len);
	if (wrt <= 0)
	{
		fprintf(fdout,"Error in writing hdr record to file %s\n",
			fixed_file_name);
	}
	wrt = SFFWRITE(fixfd,&iscale[26],sedr_wrt_len);
	if (wrt <= 0)
	{
		fprintf(fdout,"Error in writing index record to file %s\n",
			fixed_file_name);
	}
}
      hdr_buf_li[24] = 2;                                                  
      for ( i = 26 ; i <= 274 ; i++)
      {  
         fix_rec[i] = 0;              
         sign = 0.;                                                      
         scafac = (DBL)pow(x10,(double)iscale[i]);                                       
         if(fabs((double)sedr_rec[i]) > 1.e-6)
         {                            
            sign = 1.;                                                   
            if (sedr_rec[i] < 0) 
            {                                 
               sign = -1.;                                               
            }                                                       
            out = sedr_rec[i]/scafac + sign * .5;                        
/*----------check for 'out' of bounds for ints*/
            if (fabs((double)out) > 2147483647.0)
            {
/*---------------out of intiger bounds*/
                u.scaled_float = -1111111111;
            }
            else
            {
                u.scaled_float = out;
            }
            /*check the byte order of ints*/
            if (type_byte_ordr)
            {
            	/*this is backwards */
            	for (j = 0 ; j < sizeof(long int) ; j++)
            	{
            		uo.ci[j] = u.sc_flt_chr[li_byte_indx[j]];
            	}
            	fix_rec[i] = uo.li;
            }
            else
            {
            	/*this is proper order ala IBM main frame MAC SUNS etc*/
            	fix_rec[i] = u.scaled_float;
            }
            	
         }                                                          
      }                                                            
wrt = SFFWRITE(fixfd,hdr_buf,buf_wrt_len);
if (wrt <= 0)
{
	fprintf(fdout,"Error in writing hdr record to file %s\n",
		fixed_file_name);
}
wrt = SFFWRITE(fixfd,&fix_rec[26],sedr_wrt_len);
if (wrt <= 0)
{
	fprintf(fdout,"Error in writing fixed record to file %s\n",
		fixed_file_name);
}

      return;                                                            
}
/***********************************************************************/
static
chng2flt()

{

int	i;
int	wrt;

hdr_buf_li[24] = 0;                                                  
/*change from double precision to single in IBM format*/
if (type_of_dbl != type_flt_out)
{
	/*change from double precision to single in IBM format*/
	dbl2fltsedr(&sedr_rec[26],type_of_dbl,
		&flt_rec[26],type_flt_out,nflts);
}
else
{
	for (i = 26 ; i <= 274 ; i++)
	{
		flt_rec[i] = (float)sedr_rec[i];
	}
}
wrt = SFFWRITE(fltfd,hdr_buf,buf_wrt_len);
if (wrt <= 0)
{
	fprintf(fdout,"Error in writing hdr record to file %s\n",
		float_file_name);
}
wrt = SFFWRITE(fltfd,&flt_rec[26],sedr_wrt_len);
if (wrt <= 0)
{
	fprintf(fdout,"Error in writing float record to file %s\n",
		float_file_name);
}

return;
}

                                                            
static
useage()

{

printf("'stdspl' can be run by command line or interactively.\n\n");
printf("For command line \n\n");
printf("  >stdspl <twist_file> [b:s:e:t:o:k:]\n\n");
printf("  Where <> is required and [] is optional.\n\n");
printf("Required input.\n\n");
printf("     1. twist_file is name of Twist file to display.\n\n");
printf("Optional inputs.\n\n");
printf("   1. b - begin time for display. Default is start time \n");
printf("      of file.\n");
printf("   2. s - start at byte. Default is at start of file.\n");
printf("   3. e - end time of file. Default is EOF.\n");
printf("   4. t - total bytes to dump. Default is all.\n");
printf("   5. o - option. Options is either 'SCAN' or 'DUMP'.\n");
printf("      Default is 'DUMP'\n");
printf("   6. k - number of records to skip.\n");
printf("For interactive. If no arguments are input 'stdspl' goes \n");
printf("into the interactice mode. 'stdspl' prompts the user for \n");
printf("input.\n\n");
return;
}

