/*****************************************************************
 * TITLE: prntsummary.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  added prototypes                 
 ****************************************************************/

#include        <stdio.h>
#include        <string.h>
#include        <stdlib.h>
#include        <sedrgl.h>
#include	<glbltme.h>
#include	<sffile.h>

#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"PCNTSUM0") csect(STATIC,"PCNTSUM1")
#endif
#if (NOPROTO)
extern  void    dictmcnv();
#else
extern  void    dictmcnv(long int *,char *,char *,DBL *,char *,
                          char *,char *,char *,char *);
int prntsummary(SFFOPDEF (sumfd));
static print_intervals(SFFOPDEF (sumfd));
static print_misc(SFFOPDEF (sumfd));
#endif

/*****************************************************************/
int prntsummary(sumfd)

SFFOPDEF(sumfd);

{

fprintf(sumfd,
	"\n\nSEDR SUMMARY\n\n");
fprintf(sumfd,

/*3456789012345678901234567890123456789 */
	"\tPROJECT ID . . . . . . . . ULS\n");
fprintf(sumfd,
	"\tFILE ID  . . . . . . . . . SEDR\n");
fprintf(sumfd,
	"\tSPACECRAFT ID  . . . . . . 55\n");
fprintf(sumfd,
	"\tSEDR PACKAGE ID  . . . . . %d\n",
	package_id);
fprintf(sumfd,
	"\tTYPE OF SEDR . . . . . . . ");
switch (type_sedr)
{
	case 0: /*predict*/
		fprintf(sumfd,
			"PREDICT\n");
	break;

	case 1: /*final*/
		fprintf(sumfd,
			"FINAL\n");
	break;
	case 2: /*special*/
		fprintf(sumfd,
			"SPECIAL\n");
	break;
	default: /*unknown*/
		fprintf(sumfd,
			"UNKNOWN\n");
	break;
}
fprintf(sumfd,
/*3456789012345678901234567890123456789 */
	"\tSEDR GENERATION DATE . . . %ld\n",
	sedrgen_yyddd);
fprintf(sumfd,
/*3456789012345678901234567890123456789 */
	"\tSEDR GENERATION TIME . . . %ld\n\n",
	sedrgen_hhmmss);
fprintf(sumfd,
/*3456789012345678901234567890123456789 */
	"\tAHF SCET . . . . ");
strcpy(type_out,"CCSDSDOY");
dptimes[time_indx] = stahfs; /*start of ahf records*/
dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,type_out,strng,rtcode);
fprintf(sumfd,
	"%s -to- ",
	strng);
dptimes[time_indx] = enahfs; /*end of ahf records*/
dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,type_out,strng,rtcode);
fprintf(sumfd,
	"%s\n",
	strng);
fprintf(sumfd,
/*3456789012345678901234567890123456789 */
	"\tSCET . . . . . . ");
dptimes[time_indx] = sttraj; /*start of traj records*/
dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,type_out,strng,rtcode);
fprintf(sumfd,
	"%s -to- ",
	strng);
dptimes[time_indx] = entraj; /*end of traj records*/
dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,type_out,strng,rtcode);
fprintf(sumfd,
	"%s\n",
	strng);
fprintf(sumfd,
/*3456789012345678901234567890123456789 */
	"\tTOTALS . . . . . AHF RECORDS USED %d  DATA RECORDS GENERATED %d\n",
	n_ahf_recs,n_traj_recs);
if (start_intrvals != NULL)
{
	print_intervals(sumfd);
}
else
{
	fprintf(sumfd,
	/*3456789012345678901234567890123456789 */
		"\tRATE . . . . . . %d\n",
		currate);
}	
if (start_misc != NULL)
{
	print_misc(sumfd);
}
return;
}
/******************************************************************************/
static
print_intervals(sumfd)

SFFOPDEF(sumfd);

{


INTERVALS *CURR_I;

fprintf(sumfd,
	"\nINTERVALS\n\n");

CURR_I = (INTERVALS *)start_intrvals;
while (CURR_I != (INTERVALS *)NULL)
{	
	fprintf(sumfd,
		"%3d   RATE = %d\n",
		CURR_I->interval,CURR_I->rate);
	fprintf(sumfd,
	/*3456789012345678901234567890123456789 */
		"\tAHF  . . . . . . ");
	dptimes[time_indx] = CURR_I->stahfs; /*start of ahf records*/
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"%s -to- ",
		strng);
	dptimes[time_indx] = CURR_I->enahfs; /*end of ahf records*/
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"%s\n",
		strng);
	fprintf(sumfd,
	/*3456789012345678901234567890123456789 */
		"\tSCET . . . . . . ");
	dptimes[time_indx] = CURR_I->sttraj; /*start of traj records*/
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"%s -to- ",
		strng);
	dptimes[time_indx] = CURR_I->entraj; /*end of traj records*/
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"%s\n",
		strng);
	fprintf(sumfd,
		/*3456789012345678901234567890123456789 */
		"\tTOTALS . . . . . AHF RECORDS %d  ",
		CURR_I->nahfs);
	fprintf(sumfd,
		"DATA RECORDS %d\n\n",
		CURR_I->ntraj);
 	CURR_I = (INTERVALS *)CURR_I->next;
}
return;
}
/*********************************************************************/
static
print_misc(sumfd)

SFFOPDEF(sumfd);

{

MISCINFO *CURR_I;
BOOL	is_first;

is_first = TRUE;
/*do for ahf gaps*/
CURR_I = (MISCINFO *)start_misc;
while (CURR_I != (MISCINFO *)NULL)
{
	if (CURR_I->type_rec_info != 'A')
	{
		CURR_I = (MISCINFO *)CURR_I->next;
		continue;
	}
	if (is_first)
	{
		fprintf(sumfd,
			"\nSEDR RECORDS WITH NO ATTITUDE HISTORY DATA\n\n");
		is_first = FALSE;
	}
	dptimes[time_indx] = CURR_I->traj_time;
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"\tNO AHF DATA AT %s\n",
		strng);
	CURR_I = (MISCINFO *)CURR_I->next;
}
/*do for missing records*/
is_first = TRUE;
CURR_I = (MISCINFO *)start_misc;
while (CURR_I != (MISCINFO *)NULL)
{
	if (CURR_I->type_rec_info != 'M')
	{
		CURR_I = (MISCINFO *)CURR_I->next;
		continue;
	}
	if (is_first)
	{
		fprintf(sumfd,
			"\nMISSING SEDR RECORDS\n\n");
		is_first = FALSE;
	}
	dptimes[time_indx] = CURR_I->traj_time;
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"\tMISSING RECORD AT %s\n",
		strng);
	CURR_I = (MISCINFO *)CURR_I->next;
}
/*do for discontinuous records*/
is_first = TRUE;
CURR_I = (MISCINFO *)start_misc;
while (CURR_I != (MISCINFO *)NULL)
{
	if (CURR_I->type_rec_info != 'D')
	{
		CURR_I = (MISCINFO *)CURR_I->next;
		continue;
	}
	if (is_first)
	{
		fprintf(sumfd,
			"\nDISCONTINUOUS SEDR DATA RECORDS\n\n");
		is_first = FALSE;
	}
	dptimes[time_indx] = CURR_I->traj_time;
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"\tDISCONTINUOUS RECORD AT %s\n",
		strng);
	CURR_I = (MISCINFO *)CURR_I->next;
}
/*do for singular records*/
is_first = TRUE;
CURR_I = (MISCINFO *)start_misc;
while (CURR_I != (MISCINFO *)NULL)
{
	if (CURR_I->type_rec_info != 'S')
	{
		CURR_I = (MISCINFO *)CURR_I->next;
		continue;
	}
	if (is_first)
	{
		fprintf(sumfd,
			"\nSINGULAR SEDR DATA RECORDS\n\n");
		is_first = FALSE;
	}
	dptimes[time_indx] = CURR_I->traj_time;
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"\tSINGULAR RECORD AT %s\n",
		strng);
	CURR_I = (MISCINFO *)CURR_I->next;
}
/*do for duplicate records*/
is_first = TRUE;
CURR_I = (MISCINFO *)start_misc;
while (CURR_I != (MISCINFO *)NULL)
{
	if (CURR_I->type_rec_info != 'E') /*records with equal time found*/
	{
		CURR_I = (MISCINFO *)CURR_I->next;
		continue;
	}
	if (is_first)
	{
		fprintf(sumfd,
			"\nDUPLICATE SEDR DATA RECORDS\n\n");
		is_first = FALSE;
	}
	dptimes[time_indx] = CURR_I->traj_time;
	dictmcnv(tarray,mon,dow,dptimes,tstrng,time_type_in,
		type_out,strng,rtcode);
	fprintf(sumfd,
		"\tDUPLICATE RECORD AT %s\n",
		strng);
	CURR_I = (MISCINFO *)CURR_I->next;
}
return;
}
