/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*****************************************************************
 * TITLE: mchintst.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *****************************************************************
 * 
** MANUAL
**	MCHINTST 3x "December 28, 1993"
**
** NAME
**	mchintst - find the byte order of an integer for this CPU or 
**	machine.
**
** SYNOPSIS
**
**	  
**	  int mchintst(int *short_int_byte_indx_array,
**	               int *long_int_byte_indx_array);
**
** PARAMETERS
**
**	  1. short_int_byte_indx_array - int * - an integer array
**	     of indicies for proper ordering for an 'short int'. 
**	     Output. Ignored if NULL.
**	  2. long_int_byte_index_array - int * - an integer array 
**	     of indicies for proper ordering for an 'long int'. 
**	     Output. Ignored if NULL.
**	  
**
** DESCRIPTION
**
**	The byte order in an integer is different between various types
**	of CPU's. The difference is only important if data from one 
**	platform is imported to another platform. If the imported data 
**	is described in some document then the byte order for integers, 
**	and the bit patterns will be known apriori. But the program that 
**	processes these integers and bit patterns should be portable
**	to multiple platforms, therefore it is essential that there 
**	is a procedure to find the byte order.
**
**	For purposes of this discussion assume that the size of a
**	long integer is four bytes and a short integer is two bytes.
**
**	In a stream ordered integer byte zero is the most signifigant
**	byte, byte one the next etc. with byte 3 being the least 
**	signifigant byte. In a VAX byte zero is the least signifigant
**	with byte 3 being th most signifigant.
**
**	'mchintst' finds the byte order of short int and long int. It
**	returns zero for stream ordered and one for not stream ordered. It
**	It also can return an array of indicies for short and/or long
**	integers where long_int_byte_index_array[0] and
**	short_int_byte_indx_array[0] are the index to the least 
**	signifigant byte in an integer [1] is the next and so on.
**	This is done so that long_int_byte_index_array[0] and
**	short_int_byte_index_array[0] both point to the least
**	signifigant byte.
**	
**	Once the order is found the next order of business is to find 
**	where to place consecutive ordered bytes in an int for 
**	shifting etc.  
**
**	Here is a union (all of the members of the union start at the
**	same byte boundry).
**
**	  union  {
**	          long   int test_long_int;
**	          int    *test_int;
**	          short  *int test_short_int;
**	          char   *test_chr;
**	  } mach;
**
**	Set nl to the size of a long integer.
**
**	For purposes of clarity each i in the next loop is shown.
**
**	  for ( i = 0 ; i < nl ; i++) (loop nl times)
**	  {
**	      if i equals to zero (first time) then
**	           mach.test_long_int is set to 8
**	      if i equals to one (second time thru loop) then
**	           add 4*256 to mach.test_long_int
**	      if i equals to two (third time thru) then
**	           add 2*256*256 to mach.test_long_int
**	      if i equals to three (fourth time thru) then
**	           add 256*256*256 to mach.test_long_int
**	  } (end of for loop.)
**
**	This places an 8 in the least signifigant byte a 4 in 
**	in the next byte and if sizeof(long int) is 4 a 2 in
**	the next byte and a 1 in the most signifigant byte.
**
**
**	The byte order, in hex, for a stream ordered long integer is
**
**	 byte 0   1   2   3
**	    [01][02][04][08]
**
**	The byte order for the VAX is
**	
**	 byte 0   1   2   3
**	    [08][04][02][01]
**
**	In a machine whos long integer is stream ordered 
**	mach.test_chr[nl-1] will always be equal to 8.  Where nl
**	is the size of a long integer. If it is not 8 then it is
**	not stream ordered.
**
**	To always be able to know the least signifigant to the most
**	signifigant byte there needs to be an array of indicies such
**	that if
**
**	  index_0 = long_int_byte_indx_array[0];
**	  index_1 = long_int_byte_indx_array[1];
**	  index_2 = long_int_byte_indx_array[2];
**	  index_3 = long_int_byte_indx_array[3];
**
**	given a long integer, mach.test_long_int, the least signifigant
**	byte is (using the union described above)
**
**	  mach.test_chr[index_0]
**
**	the most signifigant byte is
**
**	  mach.test_chr[index_3]
**
**	For stream ordered bytes the array, for long integers, is
**
**	   long_int_byte_indx_array[0] = 3
**	   long_int_byte_indx_array[1] = 2
**	   long_int_byte_indx_array[2] = 1
**	   long_int_byte_indx_array[3] = 0
**
**	For the VAX it is
**
**	   long_int_byte_indx_array[0] = 0
**	   long_int_byte_indx_array[1] = 1
**	   long_int_byte_indx_array[2] = 2
**	   long_int_byte_indx_array[3] = 3
**
**	For stream ordered bytes the array, for short integers, is
**
**	   long_int_byte_indx_array[0] = 1
**	   long_int_byte_indx_array[1] = 0
**
**	For the VAX it is
**
**	   long_int_byte_indx_array[0] = 0
**	   long_int_byte_indx_array[1] = 1
**
**	This array is output for a short integer and a long integer if
**	short_int_byte_indx_array and/or long_int_byte_indx_array are 
**	not NULL but point to the array of integers.
**
** RETURN
**
**	'mchintst' returns zero for stream ordered, and one for none
**	stream ordered.
**
** EXAMPLE

EXAMPLE

DISCLAIMER: There are other methods for accomplishing the
following example. This is just one such method. 

The following hex bytes are from a Supplementary Experiment Data 
Record (SEDR) output file.

Byte   0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15 
     [10][64][14][42][04][80][43][43][00][00][52][4a][10][80][00][00] 

The bytes that will be used are, 2,3,10,11,12,13,14,15, where
  1. bits 0-5 of byte 2 are Control Authority ID and should be, in 
     binary, 000101 
  2. bits 6,7 of byte 2 plus bits 0-2 of byte 3 are System 
     Classification and should be, in binary, 00010. 
  3. bits 3-7 of byte 3 are Secondary Header Identifier and should be
     binary, 00010.
  4. bytes 10,11,12 and 13 are integer seconds past 1950. Stream 
     ordered.
  5. bytes 14 and 15 are the fractional seconds. Stream ordered.

int rtc;  
int lng_ary[sizeof(long int)];
int srt_ary[sizeof(short int)];
int inta[sizeof(int)];
union  {
       long   int l_i;
       int    *i;
       short  *int s_i;
       char   *chr;
} mc;
char	sedr_bytes[16]; contains hex bytes from SEDR.
int control_authority;
int system_classification;
int secondary_header_id;
long int secs_past_50;
long int fractional_seconds.

rtc = mchintst(lng_ary,srt_ary); set up indexes for short long integers
if (sizeof(int) == sizeof(long int))
{
	place long integers indexes in 'inta'
}
else
{
	place short integers indexes in 'inta'
}
mc.i = sedr_bytes[2]; 14 in hex, 00010100 in binary.
control_authority = mc.i >> 2; shift right by 2 which is 00000101
mc.i = 0; clear bits
mc.chr[inta[1]] = sedr_bytes[2]; the most signifigant portion
                                 14 in hex, 00010100 in binary
mc.chr[inta[1]] &= 0xfc; which leaves the last two bits 00
mc.chr[inta[0]] = sedr_bytes[3] 42 in hex, 01000010 in binary
                                the least signifigant.
system_classification = mc.i >> 5; shift right 5 which is
                                   00000010
secondary_header_id = sedr_byte[3]; 42 in hex, 01000010 in binary
secondary_header_id &= 0x1f; which leaves 00000010
mc.chr[lng_ary[3]] = sedr_bytes[10]; the most signifigant portion of 
                                     seconds past 1950. 52 in hex.
mc.chr[lng_ary[2]] = sedr_bytes[11]; 4a in hex.
mc.chr[lng_ary[1]] = sedr_bytes[12]; 10 in hex.
mc.chr[lng_ary[0]] = sedr_bytes[13]; the least signifigant portion of
                                     seconds past 1950. 80 in hex.
seconds_past_50 = mc.l_i;
mc.l_i = 0; clear bits.
mc.chr[lng_ary[1]] = sedr_bytes[14]; the most signifigant portion of
                                     fractional seconds. 00 in hex
mc.chr[lng_ary[0]] = sedr_bytes[15]; the least signifigant portion of
                                     fractional seconds. 00 in hex.                                     
fractional_seconds = mc.l_i;

seconds past 1950 is 1380585600.000 and is October 1 1993 00:00:00.000

*/  
#endif /*  Header */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"MCHINTS0") csect(STATIC,"MCHINTS1")
#endif

#include	<stdio.h>

int	
mchintst(short_int_byte_indx_array,long_int_byte_indx_array)

int	*short_int_byte_indx_array;
int	*long_int_byte_indx_array;

{
int	rtc;
int	sizeoflint;
union {
	long	int	test_lint;
	char	test_chr[4];
} mach;
int	i;
long int j;

/*begin mchintst*/
sizeoflint = sizeof(long int);
/*place 8 in least signifigant byte and 4 in next byte*/
mach.test_lint = 8 + 4*256;
if (sizeoflint == 4)
{
	j = 65536;
	/*place 1 in most signifigant byte and 2 in next*/
	mach.test_lint += 2*j + 256*j;
}
/***************************************************************
**	The byte order, in hex, for a stream ordered long integer is
**
** mach.test_chr 0   1   2   3
**	       [01][02][04][08]
**
**	The byte order for the VAX is
**	
** mach.test_chr 0   1   2   3
**	       [08][04][02][01]
***************************************************************/
if (mach.test_chr[sizeoflint-1] == 8)
{
	/*this is stream ordered*/
	rtc = 0;
}
else
{
	/*this is not stream ordered*/
	rtc = 1;
}
if (long_int_byte_indx_array != (int *)NULL)
{		
/****************************************************************
**	For stream ordered bytes the array, for long integers, is
**
**	   long_int_byte_indx_array[0] = 3
**	   long_int_byte_indx_array[1] = 2
**	   long_int_byte_indx_array[2] = 1
**	   long_int_byte_indx_array[3] = 0
**
**	For the VAX it is
**
**	   long_int_byte_indx_array[0] = 0
**	   long_int_byte_indx_array[1] = 1
**	   long_int_byte_indx_array[2] = 2
**	   long_int_byte_indx_array[3] = 3
********************************************************************/
	for ( i = 0 ; i < sizeoflint ; i++)
	{
		switch (mach.test_chr[i])
		{
			case 8: /*least signifigant*/
				long_int_byte_indx_array[0] = i;
			break;
			case 4:
				long_int_byte_indx_array[1] = i;
			break;
			case 2:
				long_int_byte_indx_array[2] = i;
			break;
			case 1: /*most signifigant*/
				long_int_byte_indx_array[3] = i;
			break;
			default:
			break;
		} /*end of switch*/
	} /* end of for loop*/
}
if (short_int_byte_indx_array == (int *)NULL)
{
	return(rtc);
}
/*******************************************************************
**	For stream ordered bytes the array, for short integers, is
**
**	   long_int_byte_indx_array[0] = 1
**	   long_int_byte_indx_array[1] = 0
**
**	For the VAX it is
**
**	   long_int_byte_indx_array[0] = 0
**	   long_int_byte_indx_array[1] = 1
**
*******************************************************************/
for ( i = 0 ; i < sizeof(short int) ; i++)
{
	switch(mach.test_chr[i])
	{
		case 8:
		case 2: /*least signifigant*/
			short_int_byte_indx_array[0] = i;
		break;
		case 4:
		case 1: /*most signifigant*/
			short_int_byte_indx_array[1] = i;
		break;
		default:
		break;
	}
}	
return(rtc);
}
			
	
	
