/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"DCPRTAR0") csect(STATIC,"DCPRTAR1")
#endif

#include	<stdio.h>
#include	<sftypes.h>
#include	<sffile.h>

void
diprtarray(fd,tarray1,mon1,dow1,sfepoch1,strng_out)

SFFOPDEF(fd);
long	int	*tarray1;
char	*mon1;
char	*dow1;
DBL	*sfepoch1;
char	*strng_out;

{

union {
	long int fracl;
	unsigned short fracs[2];
} fracu;
long	int	julian_date;
long	int	mill;
DBL	mills;


fprintf(fd,"The outputs are:\n\n");
fprintf(fd,"%s %s %ld %ld\n\n",
	dow1,mon1,tarray1[5],tarray1[0]);
fprintf(fd,"Year        - tarray[0]  = %ld\n",tarray1[0]);
fprintf(fd,"DOY         - tarray[1]  = %ld\n",tarray1[1]);
fprintf(fd,"HOY         - tarray[2]  = %ld\n",tarray1[2]);
fprintf(fd,"Sec of Hr   - tarray[3]  = %ld\n",tarray1[3]);
fprintf(fd,"Month       - tarray[4]  = %ld\n",tarray1[4]);
fprintf(fd,"Day of mn   - tarray[5]  = %ld\n",tarray1[5]);
fprintf(fd,"Hours       - tarray[6]  = %ld\n",tarray1[6]);
fprintf(fd,"Minutes     - tarray[7]  = %ld\n",tarray1[7]);
fprintf(fd,"Seconds     - tarray[8]  = %ld\n",tarray1[8]);
fprintf(fd,"Millisecs   - tarray[9]  = %ld\n",tarray1[9]);
if (tarray1[10] < 0)
{
	fprintf(fd,"SP50        - tarray[10], is greater than\n");
	fprintf(fd,"              allowed by a 4 byte integer.\n");
}
else
{
	fracu.fracl = tarray1[10];
	fprintf(fd,"SP50        - tarray[10] = %ld, (in hex '%0X%0X')\n",
 		tarray1[10],fracu.fracs[0]&0xffff,fracu.fracs[1]&0xffff);
	fracu.fracl = tarray1[11];
	fprintf(fd,"Frac (1950) - tarray[11] = %ld, (in hex '%0X')\n",
		tarray1[11],fracu.fracs[1]&0xffff);
}
fracu.fracl = tarray1[12];
fprintf(fd,"SP2000      - tarray[12] = %ld, (in hex '%0X%0X')\n",
tarray1[12],fracu.fracs[0]&0xffff,fracu.fracs[1]&0xffff);
fracu.fracl = tarray1[13];
fprintf(fd,"Frac (2000) - tarray[13] = %ld, (in hex '%0X')\n",
	tarray1[13],fracu.fracs[1]&0xffff);
if (tarray1[14] < 0)
{
	fprintf(fd,"No Epoch of choice.\n");
}
else
{
	fracu.fracl = tarray1[14];
	fprintf(fd,"SPEPOCH     - tarray[14] = %ld, (in hex '%0X%0X')\n",
		tarray1[14],fracu.fracs[0]&0xffff,
		fracu.fracs[1]&0xffff);
		fracu.fracl = tarray1[15];
	fprintf(fd,"Frac (EPOCH)- tarray[15] = %ld, (in hex '%0X')\n",
		tarray1[15],fracu.fracs[1]&0xffff);
}
fprintf(fd,"DP50   - 'sfepoch[0]' = %.12E\n",sfepoch1[0]);
fprintf(fd,"DP2000 - 'sfepoch[1]' = %.12E\n",sfepoch1[1]);
if (tarray1[14] >= 0)
{
	fprintf(fd,"DPEPOCH - 'sfepoch[2]' = %.12E\n",sfepoch1[2]);
}
julian_date = sfepoch1[3];
mills = sfepoch1[3] - (DBL)julian_date;
mill = (long int)(mills*1000 + .04);
fprintf(fd,"Julian Date - 'sfepoch[3]' = %ld.%03ld\n",
	julian_date,mill);
if (strng_out == NULL)
{
	return;
}
fprintf(fd,"'strng_out' is '%s'\n\n",strng_out);
return;
}
