/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*
** MANUAL
**	DIHDRSCEOWL 3x, "October, 26 1993"
**
** NAME
**	dihdrsceowl - read in sclk coeff or owlt SFDU. Get epoch.
**
** SYNOPSIS
**
**	  #include  <glowsce.h>
**	  #include  <sffile.h>
**
**	  int dihdrsceowl(fd,data_set_id,fdout,rtcode);
**
**	  SFFOPDEF(fd);
**	  char      *data_set_id;
**	  SFFDEFOPEN(fdout);
**	  char      *rtcode;
**
** PARAMETERS
**
**	 1. fd -SFFOPEDEF- file descriptor for coefficient
**	    or OLWT file.
**	 2. data_set_id - char * - data set ids which can be 
**	    1. 'DOUBLE_PRECISION_SCLK_SCET'
**	    2. 'DOUBLE_PRECISION_OWLT'
**	 3. fdout - SFFOPDEF - file descriptor for ouput file.
**	 3. rtcode - return code. 4 characters.
**
** DESCRIPTION
**
**	'dihdrsceowl' reads a double precision SCET/SCLK coefficient 
**	or OWLT file. It reads in the meta-data portion of the
**	file, parses the data to find the epoch then it finds the
**	start of the double precision data.
**
**	If 'fdout' is not NULL 'dihdrsceowl' outputs the meta data to
**	fdout.
**
**	The input double precision coefficient file header looks like
**	 CCSD3ZF0000100000001NJPL3KS0L015$$scet$$
**	 MISSION_NAME=ULYSSES;
**	 SPACECRAFT_NAME=ULS;
**	 DATA_SET_ID=DOUBLE_PRECISION_SCLK_SCET;
**	 FILE_NAME=uls.dp1coeff.data;
**	 PRODUCT_CREATION_TIME=1990-285T14:49:10;
**	 PRODUCT_VERSION_ID=1;
**	 PRODUCER_ID=DMT;
**	 APPLICABLE_START_TIME=1990-285T14:49:10;
**	 APPLICABLE_STOP_TIME=1999-12-30T12:00:00.000;
**	 MISSION_ID=3;
**	 SPACECRAFT_ID=55;
**	 TARGET_PARAMETER_NAME=SCET;
**	 TARGET_PARAMETER_EPOCH=1950-001T00:00:00.000;
**	 CCSD$$MARKER$$scet$$NJPL3IF004900000001
**
**	The input double precision owlt file header looks like
**	 CCSD3ZF0000100000001NJPL3KS0L015$$owlt$$
**	 MISSION_NAME=ULYSSES;
**	 SPACECRAFT_NAME=ULS;
**	 DATA_SET_ID=DOUBLE_PRECISION_OWLT;
**	 FILE_NAME=uls.dp1owlt.data;
**	 PRODUCT_CREATION_TIME=1990-285T14:49:10;
**	 PRODUCT_VERSION_ID=1;
**	 PRODUCER_ID=DMT;
**	 APPLICABLE_START_TIME=1990-285T14:49:10;
**	 APPLICABLE_STOP_TIME=1999-12-30T12:00:00.000;
**	 MISSION_ID=3;
**	 SPACECRAFT_ID=55;
**	 TARGET_PARAMETER_NAME=SCET_AND_ERT;
**	 TARGET_PARAMETER_EPOCH=1950-001T00:00:00.000;
**	 CCSD$$MARKER$$owlt$$NJPL3IF005000000001
** END MAN PAGES
*/
#endif
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"DCHDRSC0") csect(STATIC,"DCHDRSC1")
#endif
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<glbltme.h>
#include	<glowlsce.h>
#include	<dictmerr.h>
#include	<dihdrsco.h>

void
dihdrsceowl(fd,data_set_id,fdout,rtcode)

SFFOPDEF(fd);
char	*data_set_id;
SFFOPDEF(fdout);
char	*rtcode;

{


int	rt_code;

/*initia;ize here*/

is_coeff_file = FALSE;
is_owlt_file = FALSE;
if (strcmp(times_data_init,"YES"))
{
	ditminit();
}
/*malloc area for reading in SFDU labels plus meta-data*/
hdr_buf = malloc(80*15);
if (hdr_buf == NULL)
{
	/*error in mallocing*/
	strcpy(rtcode,"MALX");
	return;
}
/*set back to start of file
SFFSEEK(fd,0,SFSEEK_SET);
/* starting SFDU labels CCSD3ZS00001$$sclk$$NJPL3KS0L015$$scet$$ */
to_read = 40; /*read in two 20 byte SFDU labels*/
rdsceowl(fd,to_read,hdr_buf,&read,rtcode);
/*find end of it but first*/
if(strncmp(hdr_buf,"CCSD",4) ||  strncmp(&hdr_buf[20],"NJPL",4))
{
	/*this is not a proper file*/
	/*is not an SCLK/SCET file*/
	printf("This is not an SFDUfile\n");
	strcpy(rtcode,err_rtrn_code[CLN_INDX]);
	free(hdr_buf);
	return;
}
file_delimiter = hdr_buf[6];
metadatadelimiter = hdr_buf[26];
to_read = 80*15;
rdsceowl(fd,to_read,hdr_buf,&read,rtcode);
rt_code = sfnetcall_parser(
                   NULL,
                   0,
                   0,
                   hdr_buf, /*after labels to start of data*/
                   to_read,
                   pars_sceowl_kywrds,
                   sceowl_spc_chars,0);
if (rt_code < 0)
{
	/*this is not a proper file*/
	/*is not an SCLK/SCET file*/
	printf("This is not an SFDU file\n");
	strcpy(rtcode,err_rtrn_code[CLN_INDX]);
	return;
}
if (is_coeff_file)
{
	strcpy(data_set_id,COEFF_DATA_SET_ID);
	if (fdout != SFFNULL)
	{
		/*printout*/
		to_read = (int)clkoffset - 80;
		hdr_buf[to_read] = '\0';
		fprintf(fdout,"%s\n",hdr_buf);
	}
        CLKEPS = CLOWEPS;
}
else
{
	strcpy(data_set_id,OWLT_DATA_SET_ID);
	if (fdout != SFFNULL)
	{
		/*printout*/
		to_read = (int)owloffset - 80;
		hdr_buf[to_read] = '\0';
		fprintf(fdout,"%s\n",hdr_buf);
	}
	OWLEPS = CLOWEPS;
}

free(hdr_buf);
return;
}
		
static
rdsceowl(fd,toread,buf,read,rtcode)

SFFOPDEF(fd);
int	toread;
char	*buf;
int	*read;
char	*rtcode;

{

read[0] = SFFREAD(fd,buf,toread);
if (read[0] !=  toread)
{
	strcpy(rtcode,err_rtrn_code[OWR_INDX]);
}
return;
}

pars_sceowl_kywrds(keyindx,key_len,key_buf,valueindx,value_len,
                        value_buf,runing_count)


int     keyindx;
int     key_len;
int     key_buf;
int     valueindx;
int     value_len;
int     value_buf;
long    runing_count;

{

char    *keywrd;
char    *value;
char	save4keywrd;
char	save4value;
int	rt_code;
long	int	offset;

/*begin*/
keywrd = &hdr_buf[keyindx];
if (valueindx < 0)
{
	if (keywrd[0] == ';')
	return(0); /*get next*/
	/*this is the end*/
	if (!is_coeff_file  &&  !is_owlt_file)
	{
		/*this is not one or the other*/
		return(-1);
	}
	if (metadatadelimiter == 'S')
	{
		/*this is marker*/
		if (strncmp(keywrd,"CCSDS",4))
		{
			/*error here*/
			return(-1);
		}
		/*this sould be ok*/
		
		offset = (long int)keyindx + 80;
		if (is_coeff_file)
		{
			clkoffset = offset;
		}
		else
		{
			owloffset = offset;
		}
	}
	/*else is other TBD*/	
	return(1); /*thus it is ended*/
}

/*ok now find out what it is*/
value = &hdr_buf[valueindx];
/*this is a write to fdsclk_out file*/
save4keywrd = keywrd[key_len];
keywrd[key_len] = '\0';
save4value = value[value_len];
value[value_len] = '\0';
switch(keywrd[0])
{
	case 'D': /*dataset id*/ 
		if (!strcmp(COEFF_DATA_SET_ID,value))
		{
			/*this is a coefficient file*/
			is_coeff_file = TRUE;
		}
		else if (!strcmp(OWLT_DATA_SET_ID,value))
		{
			/*this is OWLT file*/
			is_owlt_file = TRUE;
		}
		else
		{
			return(-1);
		}
	break;
	case 'T':
		if (!strcmp(meta_data[TP_EPOCH_INDX],keywrd))
		{
			/*this is epoch*/
			strcpy(CLOWEPS.epoch,value);
			rt_code = d2epoch(value);
			if (rt_code)
			{
				return(-1);
			}
			
		}
	break;
	case 'M': /*a loot of stuff*/
		if (!strcmp(meta_data[MSN_ID_INDX],keywrd))
		{
			/*this is mission id 0,1,2  etc.*/
			sscanf(value,"%d",&msn_case_nmbr);
		}
	break;
	case 'S': /*spacecraft data*/
		if (!strcmp(meta_data[SC_NAME_INDX],keywrd))
		{
			/*this is SC name i.e. MGN, ULS etc*/
			strcpy(msn,value);
		}
	break;
	default:
	break;
}
keywrd[key_len] = save4keywrd;
value[value_len] = save4value;
return(0);
}
static
d2epoch(value)

char *value;

{
char	rtcode[5];

if (!strncmp(value,"1950",4))
{
	CLOWEPS.epoch_indx = DP50_INDX;
	strcpy(CLOWEPS.epoch_type,EPOCH_1950);
}
else if (!strncmp(value,"2000",4))
{
	CLOWEPS.epoch_indx = DP2000_INDX;
	strcpy(CLOWEPS.epoch_type,EPOCH_2000);
}
else
{
	g2epoch(value,rtcode);
	if (rtcode[3] == 'X')
	{
		/*error*/
		return(-1);
	}
	CLOWEPS.epoch_indx = DPEP_OF_CHOICE;
	strcpy(CLOWEPS.epoch_type,EPOCH_CHOICE);
}
return(0);
}


static
g2epoch(value,rtcode)

char	*value;
char	*rtcode;

{

/**********************************************************
struct	epoch_struct {
	char	char_epoch[24];
	long	int	epoch_tarray[SIZE_OF_TARRAY];
	DBL	epoch_dptimes[SIZE_OF_DPS];
	char	epoch_mon[4];
	char	epoch_dow[4];
	char	new_epoch[4];
	BOOL	find_epoch_times;
};
typedef struct epoch_struct EPOCH_STRUCT;

EPS is EPOCH_STRUCT in 'glbltme.h'

struct clowep_struct {	
	int	epoch_indx;
	char	epoch_type_in[12];
	char	epoch[24];
	EPOCH_STRUCT	clow_ep_save;
};

typedef	struct	clowep_struct CLOWEP_STRUCT;

CLOWEPS is CLOWEP_STRUCT see 'glowlsce.h'
******************************************************************/
char	*pntr;
EPOCH_STRUCT	SAVEME;

SAVEME = EPS;
/*set 'type_in' as 'EPOCH CHAR"*/
strcpy(type_in,"EPOCH CHAR");
/*find time string, entered after EPOCH*/
/*get new epoch*/
dictmcnv(tarray,NULL,NULL,dptimes,value,type_in,NULL,NULL,rtcode);
CLOWEPS.clow_ep_save = EPS;
EPS = SAVEME;
return;
}

