/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
* 
*/
#ifndef Header
/*****************************************************************
 * TITLE: dictprs.c 
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 ***************************************************************
 **
** MANUAL
**	DCCTPRS 3x "April 22, 1990"
**
** NAME
**	dictprs - parse keyword equal to value or just word.
**
** SYNOPSIS
**
**	   int  dictprs(
**	                buf,
**	                buflen,
**	                pars_func,
**	                spcl_chars);
**
** PARAMETERS
**
**	    1. buf - points to the buffer containing the information to 
**	       parse.
**	    2. buflen - length of buf.
**	    3. pars_func - pointer to user supplied function to call,
**	       for processing words.
**	    4. spcl_chars - NULL terminated list of characters
**	       that need special proceessing.
**
** FUNCTION
**
**	'pars_func' points to a user supplied function.
**
**	The function must have the following attributes.
**
**	  int  (*pars_func)(indx_of_wrd,len_wrd,is_spcl_char);
**
**	  int  indx_of_wrd;   index in buffer of word or special
**	                      character.
**	  int  len_wrd;       length, in bytes, of word. or 1 for
**	                      special character.
**	  BOOL is_spcl_char   TRUE for this is a special character.
**	                      FALSE this is a standard word.
**
** DESCRIPTION
**
**	dictprs parses the buffers input in 'buf' for all the words 
**	(these 'words' are seperated by blanks '\n','\0' etc and any
**	characters input in 'spcl_chars').
**
**	'dictprs' does not check
**	for comments or for double or single quotes. The words
**	are bounded by any non ascii character i.e. '\n', '\0'
**	etc.
**
**
**	When a word has been found, 'dictprs' calls
**
**	  int  (*pars_func)(indx_of_1st_wrd,len_1st_wrd);
**
**	where 'indx_of_1st_wrd' is the index into buf of word found.
**	len_1st_wrd is the lenght in bytes.
**
**	'spcl_chars' is a list terminated by '\0'.
**	When one of these characters are found 'pars_func'
**	is called as a single word. 
**
**	If the user does not know the length of the buffer
**	then the length should be set to -1 BUT beware
**	if the 'sfparser' does not find what the user wants
**	it will parse until the cow comes home or until it
**	core dumps!!!!!!
**
** RETURN
**
**	'dictprs' returns '0' for success and a '-1' for error.
**
** SEE ALSO
**
** EXAMPLE

  This is a set of examples.

  EXAMPLE 1. use special characters with 'sfetcall_parser'

   char   *spcl_list '\0','\032','\0' };

   This will call (*pars_func) with an index for '\0' and for '\032'
   which is a control Z.
   '\0' needs to be the first character if it is one of the special
   characters.

** END MAN PAGES
**
*/
#endif /*  Header  */
#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"DCCTPRS0") csect(STATIC,"DCCTPRS1")
#endif

#include	<stdio.h>
#include	<ctype.h>
#include	<sftypes.h>
#include	<dictprs.h>

/******************************************************************/
dictprs(buf,
        buflen,
	pars_func,
	spcl_chars)

char	*buf;
int	buflen;
int	(*pars_func)();
char	*spcl_chars;

{

int	rt_code;
register	char	*pntr;
register	int	i;
register	int	len;
int	blen;

/*begin*/

buf_pntr = buf;
buf_len = buflen;
i = 0;
pntr = buf;

if (spcl_chars == NULL)
	use_spcl = FALSE;
else
	use_spcl = TRUE;
is_keyword = FALSE;
start_word = FALSE;
start_indx = -1;
word_count = 0;
len = 0;
for (;;)
{
	if (i == buf_len)
	{
		/*this is the end of this buffer*/
		if (start_word)
		{
			start_word = FALSE;
		}
		if (word_count)
		{
			rt_code = 0;
			if (!rt_code)
			{
				rt_code = (*pars_func)(
					  start_indx,
					  len, FALSE);
			}
		}
		else
		{
			i--;
			rt_code = (*pars_func)(
				  i,
				  -1, FALSE);
		}
		if (rt_code < 0)
			return(rt_code);
		return(0);
	}
	is_spcl = FALSE;
	if (use_spcl)
	{
		spcl_i = 0;
		for (;;)
		{
			if (spcl_i  &&
			    spcl_chars[spcl_i] == '\0')
				break;
			if (spcl_chars[spcl_i] == pntr[0])
			{
				is_spcl = TRUE;
				break;
			}
			spcl_i++;
		}
	}
	if (*pntr != ' '   &&
	    *pntr != ','   &&
	    *pntr != ';'   &&
	    !is_spcl       &&
	    !iscntrl(pntr[0]))
	{
		if (start_word)
		{
			pntr++;
			i++;
			len++;
			continue;
		}
		word_count++;
		start_word = TRUE;
		start_indx = i;
		len = 1;
		pntr++;
		i++;
		continue;
	}
	/*this is 'white'spaces*/
	if (start_word)
	{
		/*finish up start word here*/
		start_word = FALSE;
		word_count = 0;
		is_keyword = FALSE;
		rt_code = (*pars_func)(
			start_indx,
			len, FALSE);
		if (rt_code)
		{
			if (rt_code < 0)
				return(rt_code);
			return(0);
		}
		word_count = 0;
	}
	if (is_spcl)
	{
		start_indx = i;
		len = 1;
		rt_code = (*pars_func)(start_indx,
				       1, is_spcl);
		if (rt_code)
		{
			if (rt_code < 0)
				return(rt_code);
			return(0);
		}
		word_count = 0;
		pntr++;
		i++;
		continue;
	}
	i++;
	pntr++;
} /*end of inner for loop*/
}

