/*
         1         2         3         4         5         6         7
123456789012345678901234567890123456789012345678901234567890123456789012
*/
#ifndef Header
/*
*****************************************************************
 * TITLE: ahfreadr.c
 *
 * AUTHOR:  Unknown
 *          Aug 31, 1994
 *
 * MODIFIED:    Ray Bambery
 *          Aug 24, 2020 -  removed label after #ENDIF Header 
 *                          added prototypes to fix error:
 *                          error: static declaration of 'ahf_open' follows non-static declaration
 **************************************************************
**
** MANUAL
**	AHFREADR 3x,"March 25, 1994"
**
** NAME
**	ahfreader - open, close and read attitude history file
**	
** SYNOPSIS
**	
**	  #include <ahfreadr.h>
**
**	  int ahfreadr(option,struct_pntr);
**
**	  char  *option;
**	  char  *struct_pntr;
**
** PARAMETERS
**
**	  1. option - "OPEN","READ"."CLOSE"
**	  2. struct_pntr - address of structure for the 
**	     differnet options.
**
** STRUCTURES
**
**	  structure for option of "OPEN"
**
**	  struct ahfopen
**	  {
**	      SFFOPDEF(ahffd); 
**	      char   filename[100];
**	  };
**
**	  typedef struct ahfopen AHFOPEN;
**
**	  structure for option of "CLOSE"
**
**	  struct ahfclose
**	  {
**	     SFFOPDEF(ahffd);
**	  };
**
**	  typedef struct ahfclose AHFCLOSE;
**
**	  struct ahfred 
**	  {
**	     SFFOPDEF(ahffd);
**	     DBL    ahfst;
**	     DBL    ahfen;
**	     DBL    ahfra;
**	     DBL    ahfdec;
**	     long   int    ahfind;
**	     BOOL   eod;
**	  };
**	  
**	  typedef struct ahfred AHFRED;
**
*/
#endif /*  Header  */

#if (IBM_MAIN_FRAME)
/*place pragma to allow for entry points for JTPM*/
#pragma csect(CODE,"ACFREAD0") csect(STATIC,"ACFREAD1")
#endif
#include	<stdio.h>
#include	<string.h>
#include	<stdlib.h>
#include	<glbltme.h>
#include	<sedrgl.h>


#if (NOPROTO)
extern	void	dictmcnv();
extern	void	dictmcnv();
extern	int	cnvs2dbl();
#else
extern	void	diclkcnv(long int *,char *,DBL *,char *,char *,
			  char *,char *,char *);
extern	int	cnvs2dbl(char *,DBL *);

int ahfreadr(char *option,char *struct_pntr);
static ahf_open(void);
static ahf_fndrec(void);
static  do_interpolation(void);
int do_regular(void);
static findslot(void);
int ahf_close(void);
static find_start_next_rec(SFFOPDEF (ahffd), int start_at, int len_read);
int find_ahf_gap(void);
static interpolate_ra_dec(void); 


#endif

static	AHFOPEN	*AHFO;
static	AHFCLOSE *AHFC;
static	AHFRED	*AHFR;
static	char	buf[85];
static	int	rdlen;
static	int	toread;
static	int	rec_len;
static	BOOL	is_first;
static	DBL	m_ra; /*slope of right asencion*/
static	DBL	m_dec;/*slope of declination*/
static	DBL	end_last_rec;
static	DBL	start_cur_rec;
static	DBL	end_cur_rec;
static	long	int	ahfst_yyetc;
static	long	int	ahfst_hhetc;
static	long	int	last_yyetc;
static	long	int	last_hhetc;
static	long	int	ahfen_yyetc;
static	long	int	ahfen_hhetc;
static	long	int	ahfst_cur_yyetc;
static	long	int	ahfst_cur_hhetc;
static	long	int	ahfen_cur_yyetc;
static	long	int	ahfen_cur_hhetc;
static	DBL	delta_t;
static	DBL	last_ra;
static	DBL	last_dec;
static	DBL	curr_ra;
static	DBL	curr_dec;
static	char	last_rec[120];
/************************************************************************/
int 
ahfreadr(option,struct_pntr)

char	*option;
char	*struct_pntr;

{

int	rtrn;
char	*pntr;

if (strcmp(times_data_init,"YES"))
{
	ditminit();
}
/*get opiton*/
switch (option[0])
{
	case 'O':
	case 'o': /*open*/
		AHFO = (AHFOPEN *)struct_pntr;
		rtrn = ahf_open();
	break;
	case 'C':
	case 'c':
		AHFC = (AHFCLOSE *)struct_pntr;
		rtrn = ahf_close();
	break;
	case 'R':
	case 'r':
		AHFR = (AHFRED *)struct_pntr;
		rtrn = ahf_fndrec();
	break;
	default:
		fprintf(stderr,
			"%s is an unknown option\n",
			option);
		return(-1);
}

return(rtrn);
}
/**************************************************************/
static
ahf_open()

{

long	int	len;

/*open files for attitude history in*/
SFFOPEN(AHFO->ahffd,AHFO->filename,SFRDONLY);
if (SFFERROPEN(AHFO->ahffd))
{
	fprintf(stderr,
		"Error in opening %s\n",
		AHFO->filename);
	return(-1);
}
/*set to start of records here*/
/* read until we find $$EOH*/
rec_len = 84;
buf[85] = '\0';
rdlen = SFFREAD(AHFO->ahffd,buf,rec_len);
if (rdlen <= 0)
{
	fprintf(stderr,
	  "Error in reading record from attitude history file.\n");
	 return(-1);
}
find_start_next_rec(AHFO->ahffd,0,rdlen);
is_first = TRUE;
m_ra = 0; /*set slope of rigth ascension to zero*/
m_dec = 0; /*set slope of declination to zero*/
start_cur_rec = 0;
end_last_rec = 0;
end_cur_rec = 0;
last_ra = 0;
last_dec = 0;
curr_ra = 0;
curr_dec = 0;
last_yyetc = 0;
last_hhetc = 0;
ahfst_yyetc = 0;
ahfst_hhetc = 0;
ahfen_yyetc = 0;
ahfen_hhetc = 0;
ahfst_cur_yyetc = 0;
ahfst_cur_hhetc = 0;
ahfen_cur_yyetc = 0;
ahfen_cur_hhetc = 0;
last_rec[0] = '\0';
return(0);
}
/*********************************************************************/
static
ahf_fndrec()

{

int	rtrn;

/*************************************************************
          1         2         3         4         5         6         7    
0123456789012345678901234567890123456789012345678901234567890123456789012345678
90 279 22 07 44     90 284 17 15 06     110.244  27.720 0.7166    0.0000    001 
start               end                 ra       dec              ind
**********************************************************/
rtrn = 0;
if (AHFR->interpolate)
{
	rtrn = do_interpolation();
}
else
{
	rtrn = do_regular();
}
return(rtrn);
}
/*********************************************************************/
static	do_interpolation()

{

int	rtrn;

rtrn = 0;
if (AHFR->eod)
{
	interpolate_ra_dec();
	return(0);
}
if (AHFR->traj_time >= start_cur_rec  &&  
    AHFR->traj_time <= end_cur_rec)
{
	/*inbetween slot here*/
	AHFR->ahfst_yyddd = ahfst_cur_yyetc;
	AHFR->ahfst_hhmmss = ahfst_cur_hhetc;
	AHFR->ahfen_yyddd = ahfen_cur_yyetc;
	AHFR->ahfst_hhmmss = ahfen_cur_hhetc;
	AHFR->ahfra = curr_ra;
	AHFR->ahfdec = curr_dec;
	return(0);
}
if (AHFR->traj_time > end_cur_rec)
{
	rtrn = findslot();
}
if (AHFR->traj_time < start_cur_rec  ||  AHFR->eod)
{
	interpolate_ra_dec();
}
return(rtrn);
}
/**********************************************************************/	

do_regular()

{

int	rtrn;

rtrn = 0;
if (AHFR->eod)
{
	return(1);
}

if (AHFR->traj_time > AHFR->ahfen)
{

}
rtrn = findslot();
if (rtrn < 0)
{
	return(rtrn);
}
if (AHFR->eod)
{
	rtrn = find_ahf_gap();
	numahfp = 0;
	intrvl_stahfs = 0.0;
	intrvl_enahfs = 0.0;
	return(1);
}
if (AHFR->traj_time < AHFR->ahfst)
{
	rtrn = find_ahf_gap();
}
if (!numahfp)
{
	numahfp = 1;
	intrvl_stahfs = AHFR->ahfst;
	intrvl_enahfs = AHFR->ahfen;
}
return(rtrn);
}
/*************************************************************/
static
findslot()

{

int	rtrn;

strcpy(typein,"CHAR");
/*type out is in AHFSR->time_type i.e. DP50 or DP2000*/
if (AHFR->interpolate)
{
	end_last_rec = end_cur_rec;
	ahfst_yyetc = ahfen_cur_yyetc;
	ahfst_hhetc = ahfen_cur_hhetc;
	last_ra = curr_ra;
	last_dec = curr_dec;
}
for (;;)
{
	rdlen = SFFREAD(AHFR->ahffd,buf,rec_len);
	if (rdlen < 0)
	{
		fprintf(stderr,
 "Error in reading record from attitude history file.\n");
		 return(-1);
	}
	if (!rdlen)
	{
		AHFR->eod = TRUE;
		return(1);
	}
/*************************************************************
          1         2         3         4         5         6         7
01234567890123456789012345678901234567890123456789012345678901234567890123456789
90 279 22 07 44     90 284 17 15 06     110.244  27.720 0.7166    0.0000    001 
start               end                  ra      dec                        ind
**********************************************************/
 	buf[35] = '\0'; /*make a string*/
	dictmcnv(tarray,mon,NULL,dptimes,&buf[20],typein,
		NULL,NULL,rtcode);
	if (rtcode[3] == 'X')
	{
		/*error*/
		fprintf(stderr,
			"Error in time for %s err code is %s\n",
			&buf[20],rtcode);
		return(-1);
	}
	/*find start of next record*/
	find_start_next_rec(AHFR->ahffd,79,rdlen);
	if (AHFR->traj_time <= dptimes[AHFR->time_indx])
	{
		/*we found it*/
		break;
	}
	else if (AHFR->interpolate)
	{
		end_last_rec  = dptimes[AHFR->time_indx];
		/*compute yyddd*/
		ahfst_yyetc = (YEAR%100 )*1000 + DOY;
		/*compute hhmmss*/
		ahfst_hhetc = HOUR*10000 + MINUTE*100 + SECOND;
		/*convert to double precision*/
		buf[47] = '\0';
		/*start at pntr[39]*/
		rtrn = cnvs2dbl(&buf[39],&last_ra);
		buf[55] = '\0';
		/*start at pntr[48]*/
		rtrn = cnvs2dbl(&buf[48],&last_dec);
		buf[79] = '\0';
	}
}

AHFR->ahfen  = dptimes[AHFR->time_indx];
/*compute yyddd*/
AHFR->ahfen_yyddd = (YEAR%100 )*1000 + DOY;
/*compute hhmmss*/
AHFR->ahfen_hhmmss = HOUR*10000 + MINUTE*100 + SECOND;
buf[15] = '\0'; /*make a string*/
dictmcnv(tarray,mon,NULL,dptimes,&buf[0],typein,
		NULL,NULL,rtcode);
if (rtcode[3] == 'X')
{
	/*error*/
	fprintf(stderr,
		"Error in time for %s err code is %s\n",
		&buf[0],rtcode);
	return(-1);
}
AHFR->ahfst = dptimes[AHFR->time_indx];
AHFR->ahfst_yyddd = (YEAR%100 )*1000 + DOY;
/*compute hhmmss*/
AHFR->ahfst_hhmmss = HOUR*10000 + MINUTE*100 + SECOND;
buf[47] = '\0';
/*start at pntr[39]*/
rtrn = cnvs2dbl(&buf[39],&AHFR->ahfra);
buf[55] = '\0';
/*start at pntr[48]*/
rtrn = cnvs2dbl(&buf[48],&AHFR->ahfdec);
buf[79] = '\0';
/*convert to double precision*/
/*start at pntr[76]*/
/*get indicator in int form*/
sscanf(&buf[76],"%ld",&AHFR->ahfind);
if (is_first)
{
	is_first = FALSE;
	stahfs = AHFR->ahfst;
}
enahfs = AHFR->ahfen;
if (AHFR->interpolate)
{
	start_cur_rec = AHFR->ahfst;
	ahfen_yyetc = AHFR->ahfst_yyddd;
	ahfen_hhetc = AHFR->ahfst_hhmmss;
	ahfst_cur_yyetc = AHFR->ahfst_yyddd;
	ahfst_cur_hhetc = AHFR->ahfst_hhmmss;
	ahfen_cur_yyetc = AHFR->ahfen_yyddd;
	ahfen_cur_hhetc = AHFR->ahfen_hhmmss;
	end_cur_rec = AHFR->ahfen;
	curr_ra = AHFR->ahfra;
	curr_dec = AHFR->ahfdec;
	/*computer slope M of right ascension and declination*/
	delta_t = start_cur_rec - end_last_rec;
	m_ra = (curr_ra - last_ra)/delta_t;
	m_dec = (curr_dec - last_dec)/delta_t;
}
n_ahf_recs++;
intrvl_enahfs = AHFR->ahfen;
if (!numahfp)
{
	intrvl_stahfs = AHFR->ahfst;
}
numahfp++;
return(0);
}
/********************************************************************/
ahf_close()

{

SFFCLOSE(AHFC->ahffd);

return(0);

}
/*******************************************************************/
static
find_start_next_rec(ahffd,start_at,len_read)

SFFOPDEF(ahffd);
int	start_at;
int	len_read;

{

char	year_2[3];
int	i;
int	year_2_i;
long	int	pos;

/*************************************************************
          1         2         3         4         5         6         7    
0123456789012345678901234567890123456789012345678901234567890123456789012345678
90 279 22 07 44     90 284 17 15 06     110.244  27.720 0.7166    0.0000    001 
start               end                 ra       dec              ind
**********************************************************/
/*looking for YY DOY*/
for ( i =  start_at ;  i < len_read ; i++)
{
	/*buf[i] will be first part of year*/
	if (!isalnum(buf[i]))
	{
		continue;
	}
	if (isalpha(buf[i]))
	{
		continue;
	}
	/*buf[i+2] should be blank if i is YY*/
	if (buf[i+2] != ' ')
	{
		continue;
	}
	/*second part of year*/
	if (!isalnum(buf[i+1]))
	{
		continue;
	}
	if (isalpha(buf[i+1]))
	{
		continue;
	}
	memcpy(year_2,&buf[i],2);
	sscanf(year_2,"%d",&year_2_i);
	if (year_2_i >= 90 && year_2_i <= 99)
	{
		break; /*found it*/
	}
}
/* i has where we want to be*/

pos = i - len_read; /*negative*/
/*ok now close this up*/
SFFSEEK(ahffd,pos,SFSEEK_CUR);
return(0);
}
/****************************************************************/
find_ahf_gap()

{

MISCINFO *AHFG;
MISCINFO *AHFP;
char	*curr_ahf_pntr;

curr_ahf_pntr = malloc(sizeof(MISCINFO));
if (curr_ahf_pntr == NULL)
{
	fprintf(stderr,
		"Error in mallocing for ahf gaps\n");
	return(-1);
}
AHFG = (MISCINFO *)curr_ahf_pntr;
if (start_misc == NULL)
{
	start_misc = curr_ahf_pntr;
	AHFG->prev = NULL;
}
else
{
	AHFP = (MISCINFO *)prev_misc_pntr;
	AHFP->next = curr_ahf_pntr;
	AHFG->prev = prev_misc_pntr;
}
AHFG->next = NULL;
AHFG->traj_time = AHFR->traj_time;
AHFG->type_rec_info = 'A';
prev_misc_pntr = curr_ahf_pntr;
return(1);
}
/********************************************************************/
static
interpolate_ra_dec()

{

	/*m_ra = (curr_ra - last_ra) / (start_cur_time - end_last_time)*/
	delta_t = AHFR->traj_time - end_last_rec;
	AHFR->ahfra = m_ra*delta_t + last_ra;
	/*m_dec = (curr_dec - last_dec) / (start_cur_time - end_last_time)*/
	AHFR->ahfdec = m_dec*delta_t + last_dec;
	AHFR->ahfst_yyddd = ahfst_yyetc;
	AHFR->ahfst_hhmmss = ahfst_hhetc;
	AHFR->ahfen_yyddd = ahfen_yyetc;
	AHFR->ahfen_hhmmss = ahfen_hhetc;
	return;
}
