#include	<sftlserr.h>
#include	<sftypes.h>
#include	<sfdusio.h>
#include	<sffile.h>
#include	<sfbufmgr.h>

#define		LBL_LNGTH	20
#define		CCSD_INDX	0
#define		NJPL_INDX	1
#define		ZJPL_INDX	2
#define		ERR_INDX	3
#define		CAID_SET_TOT	3
#define		CAID_LNGTH	4
#define		DDID_LNGTH	4
#define		SPARES_LNGTH	2
#define		LN_VAL_FLD_L	8
#define		VERSION_ID_LNGTH 1
#define		CLASS_ID_LNGTH	1
#define		VERSION_ID_OFF	CAID_LNGTH	/*offset to version id*/
#define		CLASS_ID_OFF	VERSION_ID_OFF+CLASS_ID_LNGTH
#define		SPARE_OFF	CLASS_ID_OFF+VERSION_ID_LNGTH
#define		V3DELIMTYPE_OFF	SPARE_OFF
#define		DDID_OFF	SPARE_OFF+SPARES_LNGTH /*offset to ddid*/
#define		LNGTH_VAL_OFF	DDID_OFF+DDID_LNGTH /*offset to length field*/
#define		MAXCNTBLS	100
#define		V3MARKER_OFF	LNGTH_VAL_OFF
#define		MAXNESTLEVEL	25
#define		LEVEL_ZERO	0
#define		ABRV_CLASS_ID_OFF	CAID_LNGTH
#define		ABRV_DDID_OFF		ABRV_CLASS_ID_OFF+CLASS_ID_LNGTH
#define		ABRV_LABEL_LNGTH	9

#define		SFFILE_LNGTH		180

#define		ADIS_LNGTH	sizeof(struct adis)
#define		TOT_ADIS	10
#define		MAXLBLS		1024
#define		LINES_PER_PAGE	20

#define		DELIMITER_INDX		0
#define		TYPE_INDX		1
#define		REFERENCE_INDX		2
#define		LENGTH_INDX		4
#define		PROTOCOL_INDX		3
#define		PRODUCT_INDX		5
#define		REFTYPE_INDX		6
#define		REFLABEL_INDX		7

#define		DELIM_SMARKER		'S'
#define		DELIM_EMARKER		'$'
#define		DELIM_ASCII_LNGTH	'A'
#define		DELIM_BINARY_LNGTH	'B'
#define		DELIM_EOFS		'F'
#define		DELIM_SEQ_EOFS		'E'
#define		DELIM_CEOFS		'C'
#define		DELIM_SPARES		'0'

#define		DLM_END_TYPE		'$'

#define		DLM_BY_ASCII_LNGTH	'A'
#define		DLM_BY_BINARY_LNGTH	'B'
#define		DLM_BY_V3_MRKR		'M'
#define		DLM_BY_R3_MRKR		'R'
#define		DLM_BY_EOFS		'F'
#define		DLM_BY_SEQ_EOFS		'E'
#define		DLM_BY_CEOFS		'C'
#define		DLM_BY_LABEL		'L'

/*format types*/

#define		CRLFSEMI_INDX		1
#define		CRLF_INDX		2
#define		LFSEMI_INDX		3
#define		LF_INDX			4
#define		NOFRMT_INDX		5

#define		MAX_NUMBER_FORMATS	4

#define		ADI_INDX		0

#define		RTRN_ERROR		-1
#define		RTRN_FINI		0
#define		RTRN_MID_ACTION		1
#define		RTRN_FINI_ACTION	2
#define		RTRN_LBL_ERROR		3
#define		RTRN_NOJOY		4

#define		PERCENT_SEARCH		15
#define		MINPRCNTBYTS		6

#define		MAXANDSOR	10	/*max & | for strings*/
#define		NANDORTYPES	2
#define		NBFRAFT		2
#define		MAXORS		MAXANDSOR*NBFRAFT*NANDORTYPES
#define		MAXLENSTR	50

#define		FILENAME	1
#define		FIND_NEXT	2
#define         SELECT		4
#define		FETCH_I_BUF	8	/*FETCH Into Buf (malloc area)*/
#define		GET_INFO	0x10
#define		RESET		0x20
#define		FIND_ALL	0x40
#define		RETRIEVE	0X80
#define		FINI		0x100
#define		FIND_PREV	0x200
#define		FETCH_U_BUF	0x400	/*FETCH using existing buffer*/

#define		RETRIEVE_TLVO		0
#define		RETRIEVE_OBJECT		1

/*indexes into 'pars_cmd_keywrds'*/
#define		INDX_GO_TO		0
#define		INDX_BEGIN_W		1
#define		INDX_END_W		2
#define		INDX_SELECT_W		3
#define		INDX_DISCARD_W		4
#define		INDX_RETRIEVE		5
#define		INDX_SAMPLE_E		6
#define		INDX_START_A		7
#define		INDX_COLLECT		8
#define		INDX_WRITE		9
#define		INDX_READ		10
#define		INDX_SAVE		11
#define		INDX_STORE		12
#define		INDX_DELETE		13
#define		INDX_MODIFY		14
#define		INDX_ADD		15
#define		INDX_VIEW		16
#define		INDX_PRINT		17
#define		INDX_HEX		18
#define		INDX_STOP		19

/*indexes inrto 'pars_slct_keywrds'*/
#define		INDX_CLASS_ID		0
#define		INDX_DDID		1
#define		INDX_LABEL		2
#define		INDX_VERSION_ID		3
#define		INDX_CAID		4

/*indexes into 'pars_event_keywrds'*/
#define		INDX_BOF		0
#define		INDX_EOF		1
#define		INDX_TLVO		2
#define		INDX_VALUE		3
#define		INDX_DATA		4
#define		INDX_KEYWORD		5
#define		INDX_NEXT		6
#define		INDX_PREVIOUS		7
#define		INDX_FILE		8
#define		INDX_DATABASE		9
#define		INDX_CONTENTS		10
#define		INDX_LABEL_E		11
#define		INDX_BUFFER		12
#define		INDX_MOST		13
#define		INDX_EVERY		14
#define		INDX_ONLY		15

/*indexes for 'pars_additional_keywrds'*/
#define		INDX_AFTER		0
#define		INDX_AT 		1
#define		INDX_WHERE		2
#define		INDX_TO			3
#define		INDX_VERBOSE		4
#define		INDX_OBJECT		5
#define		INDX_AND		6
#define		INDX_NAMED		7
#define		INDX_FOR		8
#define		INDX_FROM		9

#define		PARS_CMD_CMP_LNGTH	5	/*compare length */

#define		INDX_BEGIN_PVL		0
#define		INDX_END_PVL		1

#define		SFTIME_NAV_INDX		0
#define		SFTIME_UNIX_INDX	1
#define		SFTIME_VAX_INDX		2
#define		SFTIME_SFDU_DOY_INDX	3
#define		SFTIME_SFDU_MMDD_INDX	4

#define		BLD_NAME_INDX		0
#define		BLD_OF_INDX		1
#define		BLD_PRO_INDX		2
#define		BLD_DDID_INDX		3
#define		BLD_RET_INDX		4
#define		BLD_VAL_INDX		5
#define		BLD_FROM_INDX		6
#define		BLD_FILE_INDX		7
#define		BLD_KEY_INDX		8
#define		BLD_READ_INDX		9
#define		BLD_SC_INDX		10
#define		BLD_MOD_INDX		11
#define		BLD_SAVE_INDX		12
#define		BLD_TO_INDX		13
#define		MAXSTACKLEN		2*1024

#define		OFFSETBUFRLEN		80

#define		MAXSFSTACK		100
#define		MAP_LABEL_STRNG		"NJPL1S00MAP100000000"
#define		AGG_LEVEL_MASK		3  /*binary 0011*/

#define		SRC_UNKNOWN		0
#define		SRC_BUF_INDX		1
#define		SRC_FILE_INDX		2
#define		SRC_GUI_INDX		3
#define		SRC_USER_INDX		4
#define		SRC_ADI_INDX		5
#define		SRC_EXADI_INDX		6

#define		INBUFFILE_INDX		1
#define		INROADMAP_INDX		2
#define		INMAP_INDX		3
#define		KHDRBUF_INDX		4
#define		SOURCEBUF_INDX		5

#define		BUF_INPUT_FILE		"INBUFFILE"
#define		CRLF_BUFFER_NAME	"crlf_buffer"
#define		KHDR_BUFFER_NAME	"KHDR_BUFFER"
#define		PDS_BUFFER_NAME		"PDS_BUFFER"

#define		MAXKEYWORDSIZE		44
#define		MAXVALUESIZE		120

struct	malloced_areas {
	char	*area_pntr;
	char	*next_malloced_area;
	char	*prev_malloced_area;
} ;

struct	named_buffers {
	char	name_of_buf[24];	/*name of buffer*/
	char	*buf_pntr;		/*address of buffer*/
	int	buf_lngth;		/*length of buffer*/
	char	*next;			/*pointer to next buffer struct*/
	char	*prev;			/*pointer to previous buffer struct*/
};

struct	adibybuf {
	int	buf_indx;	/*The buffer number of where tlvo is*/
	int	indx_in_buf;	/*the number of bytes from start */
	char	*rdinfo_pntr;	/*points to rdinfo used for this buf*/
} ;

struct	srcbybuf {
	char	*buf;
	int	buflen;
	char	name_of_buf[24];
} ;

struct	srcbyfile {
	char	file_name[SFFILE_LNGTH];
	long	start_at_byte;
	long	tot_bytes;
} ;

struct	sfsrcin {
	int	type_of_source;	/*type of source ie. BUFFERS, FILE etc*/
	union {
		struct	adibybuf adibybuf;
		struct  srcbyfile srcbyfile;
		struct	srcbybuf srcbybuf;
	} srcin;
	char	*prev_srcin;
	char	*next_srcin;
} ;

struct	mgn_r3 {
	char	delim_type[12];
	int	delim_indx;
	char	cr3type[LBL_LNGTH+1];
	char	protocol[12];
	char	lngth_val[LN_VAL_FLD_L+1];
	long	lngth;
} ;

struct r3 {
	char	referencetype[SFFILE_LNGTH];
	char	label[LBL_LNGTH+1];
	char	*start_ref_adis;
} ;

struct	ccsdr3	{
	BOOL	by_the_book;
	char	reference_name[SFFILE_LNGTH];
	union {	
		struct	mgn_r3	mgn_r3;
		struct	r3	r3;
	} ref;
	char	*next_ccsdr3;
	char	*prev_ccsdr3;
};

struct	lbladis	{
	char	label[LBL_LNGTH+1];		/*entire SFDU label*/
	char	caid[CAID_LNGTH+1];		/*caid of label*/
	char	version_id;			/*version id of label*/
	char	class_id;			/*class id of label*/
	char	ddid[DDID_LNGTH+1];		/*ddid of label*/
	union	{		
		char	spares[SPARES_LNGTH+1];	/*for versions 1 and 2*/
		char	delim_type;		/*for version 3*/
	} dlsp;		/*used for different versions*/
	union	{
		char	lngth_val_field[LN_VAL_FLD_L+1]; /*version 1 ASCII*/
		char	marker[LN_VAL_FLD_L+1];	/*version 3, depnds on delim
						  type*/
	} lvf;	/*used for divferent versions*/
};

struct	adis	{
	struct	lbladis	la; /*label structure*/
	int	caid_indx;	/*i.e. CCSD_INDX,NJPL_INDX,ZJPL_INDX*/
	int	iddid;		/*ddid number (if not ALPHA)*/
	long	lngth_val;	/*converted length value from label length*/
	long	lngth_found;	/*Length found from sffndval */
	int	nesting_level;	/*1 (for outer) 2, etc */
	int	seq_in_union;	/*sequence number in current nesting level*/
	int	dtrmn_level;	/*priority for aggregation. The lower the
				  dtrmn_level the higher the priority*/
	int	delim_type_indx; /*i.e. length, marker, eof etc*/
	BOOL	ignore_for_fier; /*ignore for finding sfdu flavor*/
	long	lngth_to_next;	/*number of bytes to next TLVO, from
				  beginning of this TLVO*/
	long	tot_frm_start;	/*total bytes from start of file*/
	long	tlvo_size;	/*size of this TLVO including label*/
	char	*source;	/*points to struct sfsrcin tells 
				  where source is for this TLVO*/
	BOOL	data_object;	/*TRUE this is a data object, must follow
				  CCSDR0003 by sequence, else FALSE.*/
	int	error;		/*error number if tlvo has a warning error*/
	char	*err_msg;	/*ponts to message other than standard*/
	char	*ccsdr3;        /*points to struct ccsdr3*/
	long	ccsdr3_value_lngth;	/*length of val of CCSDR0003*/
	char	*prev_adi;	/*link list backwards*/
	char	*next_adi;	/*link list forward*/
	char	*next_tlvo_adi;	/*points to next tlvo (not necessarily
				  next label)*/
	char	*dlmtr_in_stk;	/*points to where in delimiter stack*/
} ;
struct	keyvals {
	char	*keyword;
	int	keylen;
	int	key_buf_indx;	/*The buffer number of where keyword is*/
	int	key_indx_in_buf;/*the number of bytes from start */
	char	*value;
	int	vallen;
	int	val_buf_indx;	/*The buffer number of where value is*/
	int	val_indx_in_buf;/*the number of bytes from start */
	char	*next;
	char	*prev;
	char	*rdinfo_pntr;
	BOOL	found;
};

struct	skl_adis {
	char	*adis_pntr;	/*structure of adis*/
	char	*next;
	char	prev;
};

struct	trans {
	int	type;	/*type of transformation. 's' strip, 'i' insert,
			  'r' replace this string with that string */
	char	*str;	/*string to strip, insert, replace*/
	union   {
		char	*bfr;	/*string for before (NULL means none)*/
		char	*repl;  /*string to replace found string*/
	} br;
	char	*aft;	/*string for after (NULL means none)*/
	int	skip;	/*number of 'hits' to skip*/
	int	n;	/*number to do , zero means all*/
};


struct	andsor	{
	int	type;	/*'s','i','r'*/
	int	oper;	/*'b','a' or zero for original find*/
	int	nchars;	/*number of characters in str*/
	char	str[MAXLENSTR];	/*string for all seasons*/
};

struct	lvls {
	long	lngth_of_level;
	long	running_count;
	char	label[LBL_LNGTH+1];
};

/*let us make a stack containing objects, these objects can are structures
  of variable lengths, containing varius things.
  One of these things are end markers and the type of end markers
  i.e. type_em = "CCSD3RE00000namemark"
       type_em = "CCSD?R000003xxxxxxxx" where ? is either 1 or 2 and
       xxxxxxxx is who cares?
       type_em = "EOF" TBD at this point
*/
struct	dlm_stack {
	char	*stack_pntr;		/*pointer to start of stack*/
	int	stack_len;		/*number of bytes in stack*/
	int	stack_len_left;		/*number of bytes left in stack*/
	char	*curr_entry;		/*current entry on stack*/
	char	*next_entry;		/*next available spot in stack*/
	char	*next_stack;		/*If more than one stack whats next?*/
	char	*prev_stack;		/*if more than one stack last stack*/
} ;

struct	dlmtr {
	int	dlm_type;
	char	dlm_mrkr[LBL_LNGTH+1];
	int	n_eofs;
	char	*adis_pntr;
		char	*prev_entry;
};

struct	strules {
	char	rules[2][20];
};

extern	char	version_ids[];
extern	char	class1_ids[];
extern	char	class3_ids[];
extern	char	class4_ids[];
extern	char	class5_ids[];
extern	char	class9_ids[];
extern	char	classn_ids[];
extern	char	*ccsdr3_ky_wrds[];
extern	char	*ccsdc4_ky_wrds[];
extern	char	*h_caid_labels[];
extern	char	**caid_labels;
extern	char	*ccsdr3_delim_wrds[];
extern	char	v3delim_types[];
extern	char	standard_white_chars[];
extern	char	expanded_white_chars[];
extern	char	*pars_cmd_keywrds[];
extern	char	*pars_slct_keywrds[];
extern	char	*pars_additional_keywrds[];
extern	char	*pars_event_keywrds[];
extern	int	n_print_lines;
extern	BOOL	paging;
extern	char	*curr_dlm_stack;
extern	char	*pntr_to_dlm_stack;
extern	int	n_eofs;
extern	int	n_ceofs;
extern	char	*v3emarker[];
extern	char	*ccsdr3marker[];
extern	char	*caid_dlmbyl[];
extern	int	caid_indx;
extern	int	ddid_number;
extern	int	dtrmn_level;
extern	int	curr_buf_indx;
extern	char	zjplr3_label[LBL_LNGTH+1];
extern	char	*start_adis_pntr;
extern	char	*road_map_adis;
extern	char	*start_map_adis;
extern	char	*expanded_ignore_list[];
extern	char	*standard_ignore_list[];
extern	char	*txt_envelope_list[];
extern	char	semi_colon_list[];
extern	char	*rtrn_curr_adis;
extern	char	*rtrn_next_adis;
extern	int	rtrn_curr_buf_indx;
extern	int	rtrn_curr_indx_in_buf;
extern	BOOL	adi_eof;
extern	int	prnt_adi_offset_indx;
extern	char	prnt_adi_offset[OFFSETBUFRLEN];
extern	char	prnt_adi_save_char;
extern	U_INT	sfstack[MAXSFSTACK];
extern	U_INT	*curr_stack_pntr;
extern	char	operating_system[SFFILE_LNGTH];
extern	char	date_time[SFFILE_LNGTH];
extern	char	*pvl_begin_end[];
extern	BOOL	use_road_map;
extern	char	set_dtrm_levels[];
extern	BOOL	sfinteractive;
extern	BOOL	sfcorinteract;
extern	BOOL	gdrvax;
extern	char	sfdatain_dostart[12];
extern	BOOL	ccsdr3_start_marker;
extern	BOOL	file_need_more_reads;
extern	BOOL	map_need_more_reads;
extern	char	*sfdu_work_space1;
extern	char	*sfdu_work_space2;
extern	char	*sfdu_work_space3;
extern	char	*khdr_buf_area;
extern	BOOL	unknown_buf_lngth;
extern	char	*start_skl_adis;
extern	char	*start_of_named_bufs;
extern	int	adis_source_type;
extern	char	*adis_source_name;
extern	char	*adis_rdinfo_pntr;
extern	SFFOPDEF(sfdu_fd);
extern	char	sfdu_file_name[SFFILE_LNGTH];
extern	char	object_file_name[SFFILE_LNGTH];
extern	char	*sfdu_init_list[];
extern	int	sfdu_caid_indx;
extern	int	ccsd_caid_indx;
extern	char	*sfoc_pds_named_buffer;
extern	char	*sfoc_khdr_named_buffer;
extern	int	tot_dataids_4_crlfs;
extern	char	**add_crlfs_todata;
extern	char	chosen_data_set_id[MAXKEYWORDSIZE+1];
extern	U_INT	size_of_workspace;
extern	BOOL	no_warning_flag;
extern	int	number_warns;
extern	char	*start_chngkyw_keyval;
extern	BOOL	length_is_suspect;
extern	int	sfdu_format_number;
extern	BOOL	sfdu_format_start_with_nl;
extern	BOOL	sfdu_format_blanks_ba;
extern	char	**end_markers;
extern	char	*malloced_area_pntr;
extern	char	*pds_style_pntr;
extern	int	pds_style_lngth;

