/* byteswap.c  */
/* from: https://stackoverflow.com/questions/21358762/swapping-2-bytes-of-integer   
*  dated  Asked 7 years, 10 months ago from today                                  
* 2021-12-12 - Ray Bambery                                                       
*              initial release                                                  
* 2022-06-01 - Ray Bambery                                                          
*              changed array size from 5 MB to 1 MB                                
*              added prompt if no parameters                                       
* 2022-06-06 - Ray Bambery
*               put in master loop (j index) to avoid Segmentation fault (core dumped)              
*

* program to byte swap data                                                        */
/*                                                                                  */

#include <stdlib.h>
#include <stdio.h>
#include <ncurses.h>

/* prototypes   */
unsigned short int swapBytes(unsigned short int data);
short int byteSwap(short int x, int n, int m);
int maxrec = 10000000;
int MAXSIZE = 1000000;

int main(int argc, char* argv[])
{
int inerr, outerr, result, recnum;
int i, j;
FILE* in_fd;
FILE* out_fd;
unsigned short int   datax[1000000],datay[1000000];
//    printf ("byteswap: argc = %d\n",argc);

    if (argc < 2 ){
        printf("usage:  byteswap infile outfile \n");
        exit(0);
    }  

/* open input file */
    if ((in_fd = fopen(argv[1],"rb")) == NULL) {
         printf (" can't open input file %s \n",argv[1]);
        exit(0);
    }

/* open output file */
    if ((out_fd = fopen(argv[2],"wb")) == NULL) {
         printf (" can't open output file %s \n",argv[2]);
        exit(0);
    }
//    printf ("READ\n");

    for (j=0;j<maxrec;j++) {

        inerr=fread(&datax,1,MAXSIZE,in_fd);    /* read up to 5MB */
        if(inerr != 0) 
        {
            printf("\n");
            printf("cycle %d   %d RECORDS Byteswapped.\n ",j,inerr);

        } else {
            if(feof(in_fd)) {   //if file pointer reach to end it will break{
                printf ("reached end of file\n");
              exit(0);
            } else {
                printf ("ERROR on fread \n");
                exit(1);
            }
        }
//        printf ("> %0X %0X  %0X %0X   %0X\n",datax[0],datax[1],datax[2],datax[3],datax[MAXSIZE]);

        for (i=0;i<inerr; i++) {
//            printf ("i = %d\n",i);
            datay[i] = swapBytes(datax[i]);
        }
 //       printf (" %X %X  %X %X\n",datay[0],datay[1],datay[2],datay[3]);

        outerr = fwrite (&datay,1,inerr,out_fd);
        if (outerr == 0) {
            printf ("ERROR on write\n");
        }
    }
fclose (in_fd);
fclose (out_fd);
}
/***************************************************************/ 
/* You can recombine by masking x with a value that is all FF 
 * except for bytes m and n You can compute the mask by left 
 * shifting 0xFF m times and n times and combining the result 
 * and then XOR it with 0xFFFFFFFF.         
 *
 * FYI when you right shift a signed value, it may or may not 
 * propagates 1s instead of 0 into the high order bit and is 
 * implementation defined. 
 * Either way 0xFF will protect against that.
*/
short int byteSwap(short int x, int n, int m)
{
int xm = x;
int xn = n;
short int mask = 0;
short int mask_m = 0xFF << (m << 3);
short int mask_n = 0xFF << (n << 3);

mask = (mask_m | mask_n) ^ 0xFFFF;

short int x_swapped = (x & mask) | (xm << (n <<3)) | (xn << (m <<3));
return x_swapped;

}
/*****************************************************************/
unsigned short int swapBytes(unsigned short int data)
{
unsigned short int data_swapped;

data_swapped = ((data << 8) & 0xff00) | ((data >> 8) & 0x00ff);
}



