/***********************************************************************
   TITLE:	sfdu.h -- common header file for sfdu lib
   CIN: sfdu.h,v 1.1.1.1 1994/08/31 19:22:02 root Exp

   CHANGE HISTORY
      DATE           AUTHOR       ID        REASON FOR CHANGE
      ----           ------       --     --------------------------
 sfdu.h,v
 * Revision 1.1.1.1  1994/08/31  19:22:02  root
 * Initial Release
 *
 * Revision 1.6  1992/12/31  04:17:12  kevin
 * corrected RCS keywords
 *
 * Revision 1.5  1991/10/08  17:01:35  dsfa
 * moved MAX_LT_FILES from ifdef block.
 *
 * Revision 1.4  1991/10/07  22:41:18  dsfa
 * added lt_data_struc, MAX_LT_FILES.
 *
 * Revision 1.3  1991/04/01  15:45:39  dsfa
 * *** empty log message ***
 *
 * Revision 1.2  1991/03/28  22:46:17  dsfa
 * added DEBUG_PRS
 *
 * Revision 1.1  1991/03/15  15:47:32  dsfa
 * Initial revision
 *

FILE NAME:	sfdu.h
AUTHOR:		David Wagner
CREATED: 	June 16, 1989
LAST UPDATE: 	1994/08/31 19:22:02
VERSION:	1.1.1.1
COMPILER:	cc
OS:		SunOS 4.0
REFERENCES: 
WARNINGS:
BUGS:
UNIT TEST:
WAIVERS:
***********************************************************************/
#ifndef	sfdu_h
#define sfdu_h
#include <stdio.h>

/* #ifdef BOZO  */
#ifdef DEBUG
# define DEBUG_PRS(f) fprintf(stderr, f)
# define DEBUG_MSG(s) fprintf(stderr, "%s\n", s)
# define DEBUG_PRN(f,s) fprintf(stderr, f, s)
# define DEBUG_PRN2(f,s,v) fprintf(stderr, f, s, v)
#else
# define DEBUG_PRS(f)
# define DEBUG_MSG(s)
# define DEBUG_PRN(f,s)
# define DEBUG_PRN2(f,s,v)
#endif
/* stuff that should be defined in stdio.h but isn't under Unix */
#ifndef SEEK_CUR
#define SEEK_CUR 1
#define SEEK_END 2
#define SEEK_SET 0
#endif
#define MAX_LT_FILES 4
#define SFDU_CAID_LEN		4
#define SFDU_VERSION_LEN	1
#define SFDU_CLASS_LEN		1
#define SFDU_LTYPE_LEN		1
#define SFDU_SPARE_LEN		1
#define SFDU_DDPID_LEN		4
#define SFDU_TYPE_LEN 		(SFDU_CAID_LEN+SFDU_VERSION_LEN+\
				SFDU_CLASS_LEN+SFDU_LTYPE_LEN+\
				SFDU_SPARE_LEN+SFDU_DDPID_LEN)
#define SFDU_LEN_LEN 		8
#define SFDU_HEADER_LEN 	SFDU_TYPE_LEN+SFDU_LEN_LEN

#define SFDU_CAID_POS		0
#define SFDU_VERSION_POS	4
#define SFDU_CLASS_POS		5
#define SFDU_LTYPE_POS		6
#define SFDU_SPARE_POS		7
#define SFDU_DDPID_POS		8
#define SFDU_LEN_POS		12

typedef int			SFDU_CLASS;

/* definitions for SDFU Class types */
#define SFDU_EOF		0	/* No more data objects */
#define SFDU_ERROR		(-1)	/* Malformed data object */

#define SFDUCID_CATALOG		'K'	/* Catalog Data */
#define SFDUCID_INFO		'I'	/* Main Data */
#define SFDUCID_SUPPL		'S'	/* Supplementary Data */
#define SFDUCID_TEXT		'T'	/* Text */
#define SFDUCID_DDP		'D'	/* Data Definition Package */
#define SFDUCID_DEDICT		'E'	/* Data Entity Dictionary */
#define SFDUCID_DFDESC		'F'	/* Data Format Description */
#define SFDUCID_DLANG		'L'	/* Language Description */
#define SFDUCID_OBJECT		'C'	/* Object Identification */
#define SFDUCID_AGR		'R'	/* Reference/Aggregation Marker */
#define SFDUCID_VOLUME		'V'	/* Physical Volume Info */
#define SFDUCID_UNCLAGR		'Z'	/* Unclassified Aggregation */

#define SFDU_AGR_CLASSES	"ZI"
#define SFDU_CLASSES		"KISTDEFLCRVZ"

/* define the version 3 delimiter types */
#define SFDUV3_SMARKER		'S'
#define SFDUV3_EMARKER		'E'
#define SFDUV3_EOFMARKER	'F'
/* ... */

#define CHARNULL		'\0'

#define ulong	unsigned long

typedef struct sfdu_t {
	char 	header[SFDU_HEADER_LEN+1];
	char	version;
	char	class;
	char	ddpid[SFDU_DDPID_LEN+1];
	ulong	len;
	ulong	unread;
	FILE *	fd;
} SFDU;

typedef struct sfdo_t {
	char	header[SFDU_HEADER_LEN+1];
	char	version;
	char	class;
	char	ddpid[SFDU_DDPID_LEN+1];
	ulong	startpos;
	ulong	len;
	ulong	unread;
	SFDU *	sfd;
} SFDO;

struct	lt_data_struc {
	SFDU	*sfdu;
	int	is_sfdu;
	} lt_data[MAX_LT_FILES];
/*
** Some macros for extracting info about open SFDU or SFDO objects 
*/
/*	char *	sfdu_label(SFDU * -or- SFDO *)		*/
#define sfdu_label(s)	(s)->header
/*	char	sfdu_version(SFDU * -or- SFDO *)	*/
#define sfdu_version(s) (s)->version
/*	SFDU_CLASS	sfdu_class(SFDU * -or- SFDO *)	*/
#define sfdu_class(s)	(s)->class
/*	u32	sfdu_len(SFDU * -or- SFDO *)		*/
#define sfdu_len(s)	(s)->len
/*	u32	sfdu_unread(SFDU * -or- SFDO *)		*/
#define sfdu_unread(s)	(s)->unread
/*	char *	sfdu_ddpid(SFDU * sfdu)		*/
#define sfdu_ddpid(s)	(s)->ddpid
/*	move fp to end of sfdo data object */
#define sfdo_end(s)	fseek((s)->sfd->fd, (s)->unread, SEEK_CUR)

/*	FILE *	sfdu_filep(SFDU *)		*/
#define	sfdu_filep(s)	(s)->fd
/*	FILE *	sfdo_filep(SFDO *)		*/
#define	sfdo_filep(s)	(s)->sfd->fd

/*	SFDU *	sfdo_parent(s)			*/
#define sfdo_parent(s)	(s)->sfd

/*
** Function Declarations
*/

#ifdef __STDC__
SFDU *		sfdu_open(char * filename, char * mode);
SFDU_CLASS	sfdu_next_sfdo(SFDU * sfdu, SFDO * sfdo);
SFDU_CLASS	sfdu_next_sub_sfdo(SFDO * parent_sfdo, SFDO * sfdo);
long		sfdu_sfdo_read(void * buffer, long size, long count, SFDO * sfdo);
/*
char *		sfdu_fgets(void * buffer, int length, SFDO * sfdo);
*/
char *		sfdu_fgets(char * buffer, int length, SFDO * sfdo);
int		sfdu_close(SFDU * sfdu);
#else
SFDU *		sfdu_open(/* char * filename, char * mode */);
SFDU_CLASS	sfdu_next_sfdo(/* SFDU * sfdu, SFDO * sfdo */);
SFDU_CLASS	sfdu_next_sub_sfdo(/* SFDO * parent_sfdo, SFDO * sfdo */);
long		sfdu_sfdo_read(/* void * buffer, long size, long count, SFDO * sfdo */);
char *		sfdu_fgets(/* void * buffer, int length, SFDO * sfdo */);
int		sfdu_close(/* SFDU * sfdu */);
#endif
#endif
