/***********************************************************************
   TITLE:       sclkscet.h -- common header file for sclkscet functions
   CIN: sclkscet.h,v 1.1.1.1 1994/08/31 19:22:02 root Exp

 CHANGE HISTORY
      DATE           AUTHOR       ID        REASON FOR CHANGE
     ----           ------       --     --------------------------
sclkscet.h,v
 * Revision 1.6 Centos 7/Solaris 10.2 - Ray Bambery
 * remove definition of extern    new_sclkscet_table
 * this definition no longer used, got message
 *  warning: type defaults to ‘int’ in declaration of ‘new_sclkscet_table
 *
 * Revision 1.1.1.1  1994/08/31  19:22:02  root
 * Initial Release
 *
 * Revision 1.5  1992/12/31  04:17:12  kevin
 * corrected RCS keywords
 *
 * Revision 1.4  1992/02/20  00:24:23  dsfa
 * Modified sclk_done() function.
 *
 * Revision 1.3  1991/07/03  19:54:24  dsfa
 * *** empty log message ***
 *
 * Revision 1.2  1991/04/09  18:58:42  dsfa
 * inserted comments
 *
 * Revision 1.1  1991/03/13  17:42:03  dsfa
 * Initial revision
 *

FILE NAME:      sclkscet.h
AUTHOR:         D. Flora-Adams
CREATED:        Jan 4, 1991
LAST UPDATE:    1994/08/31 19:22:02
LAST UPDATE:    Dec 07, 2021 - Ray Bambery
VERSION:    1.6
COMPILER:   gcc 7.2 on Centos 7 (pistol.jpl.nasa.gov)
OS:         Solaris 10.2 and Centos 7 

REFERENCES:
WARNINGS:
BUGS:
UNIT TEST:
WAIVERS:
***********************************************************************/

#include "sfdu.h"		/* routines for reading SFDU files */
#include <math.h>
#ifndef	sclkscet_h
#define sclkscet_h
typedef struct sclktable_t {
	double		scet0;   /* effective spacecraft event time */
	double		sclk0;   /* effective spacecraft clock */
	double		dbsclk0; /* spacecraft clock plus some (epoch) offset */ 
	double		sclkrate;/* effective sclk rate in seconds
				     per major sclk count */
	double		dut;     /* delta-UT in seconds, the difference
			            between UTC and Ephemeris time at SCET0 */
} sclktbl, * sclktblptr;

#define sclk_done()	free(SCLK_TABLE); SCLK_TABLE = NULL;

typedef struct new_sclkscet_struct_1 {
	 double          sclk0;   /* new effective spacecraft clock */
	 double          scet0;   /* new effective spacecraft event time */
	 double          dut;     /* new delta-UT in seconds */
	 double          sclkrate;/* new effective sclk rate */
}new_sclkscet_struct;

/* array table for new sclkscet rows */
#define	MAX_NEW_ROWS	3
//extern	new_sclkscet_table[MAX_NEW_ROWS];

/* global variables set by readsclk */
#define MAX_KEYWORD_SIZE        32
#define MAX_NUM_KEYWORDS        30
extern  sclktblptr      SCLK_TABLE;     /* sclk table ptr */
extern  int             sclk_rows;       /* number of rows in SCLK_TABLE */
extern	sclktblptr	last_sclkscet; /* point to last entry in SCLK_TABLE */
extern  int             sclk_mission;    /* mission id number derived from sclkscet file */
typedef struct keyword_struct {
	char    name[MAX_KEYWORD_SIZE];
	char    value[MAX_KEYWORD_SIZE];
} keyword_struct_1;
extern	struct	keyword_struct keyword[MAX_NUM_KEYWORDS];
extern  int     keyword_rows;

extern  struct keyword_struct   keyword[MAX_NUM_KEYWORDS]; /* keyword table structure */
extern  int             keyword_rows;   /* number of rows in keyword table (array) */

#ifdef __STDC__
/* common function to init the table */
int	readsclk(char * filename);
int	compare_scet(sclktblptr key, sclktblptr elem);
int	compare_dbsclk(sclktblptr key, sclktblptr elem);
sclktblptr	sclkfind(sclktblptr key, 
			int(* compar)(sclktblptr key, sclktblptr elem));
#else
/* common function to init the table */
int		readsclk(/* char * filename */);
int		compare_scet(/* sclktblptr key, sclktblptr elem */);
int		compare_dbsclk(/* sclktblptr key, sclktblptr elem */);
sclktblptr	sclkfind(/* sclktblptr key, 
			int(* compar)(sclktblptr key, sclktblptr elem) */);
#endif
#endif
