/**************************************************************************
TITLE:  vgr_edr.h

AUTHOR:         Judy Yin
modified:       R. Bambery - 2-24-2021
                added comments to structures
                R. Bambery - 10-4-2021 
                added documentation for Decommmutation map structure
CREATED:        Aug 4, 1994
COMPILER:       gcc 4.5.2
OS:             Solaris 10.2
****************************************************************************/
#ifndef VGR_EDR_H
#define VGR_EDR_H

#include "vgr_def.H"
#include "vgr_edr.H"

#define pra_subhdr_max  4            // edr - max number of indexes in structs
#define uvs_subhdr_max  7
#define crs_subhdr_max  16
#define lecp_subhdr_max 8
#define pls_subhdr_max  8
#define mag_subhdr_max  12
#define pws_subhdr_max  10
#define uvs_sub_sec_len 52              //in sfdu
#define crs_sub_sec_len  192
#define pls_sub_sec_len  0               //pls_subhdr_map not optimized
#define pws_sub_sec_len  128

#define MAX_DATA_MODE   2
// prepended const 9-11-2020 - Ray Bambery
const char*   file_name_maps[MAX_INSTR_NUM] =
        {
           "crs_edr", "lecp_edr",
           "pls_edr", "pra_edr",
           "pws_edr", "uvs_edr",
	       "eng_edr", "mag_edr"
        };

/*
char*   file_name_maps[MAX_INSTR_NUM] =  
        { 
	   "DATA/MAG/mag_edr","DATA/ENG/eng_edr","DATA/CRS/crs_edr", 
	   "DATA/LECP/lecp_edr","DATA/PLS/pls_edr", 
           "DATA/PRA/pra_edr", "DATA/PWS/pws_edr",  "DATA/UVS/uvs_edr"
        };
*/
REC_ID_STRUC rec_id_map[MAX_INSTR_NUM] =
    {
	 { CRS, 	0x01 },         //instrum, rec_id  (hdr_loc=3 in EDR Record)
     { LECP,	0x03 },
	 { PLS,	 	0x05 },
	 { PRA,		0x07 },
 	 { PWS,		0x08 },
	 { UVS,		0x09 },
	 { ENG,		0x0b },
	 { MAG,     0x04 }
    };

REC_ID_STRUC data_type_map[MAX_INSTR_NUM] =
    {
         { CRS,         0x21 },      //instrum, rec_id  (hdr_loc=236 354(octal) in EDR Record)
         { LECP,        0x22 },
         { PLS,         0x24 },
         { PRA,         0x26 },
         { PWS,         0x27 },
         { UVS,         0x28 },
	     { ENG,		    0x2D },		
         { MAG,         0x23 }
    };

int    	last_stat_items[MAX_LAST_STAT] =
    {
	item_3_SCID,
	item_7_SCPB_FLG
//	item_5_DT_MODE
    };

// mf = minor frame
INSTR_INFO instr_info[MAX_DATA_MODE][MAX_INSTR_NUM] =
    {
	{
         { 60,  5,      52,     40},    //CRS           mfs_per_seg, num_of_segs,mf_size,sub_hdr_size
         { 20,  15,     16,     4},     //LECP          
         { 20,  15,     20,     32},    //PLS
         { 40,  15,     7,      8},     //PRA
         { 20,  15,     11,     80},    //PWS
         { 25,  12,     6,      16},    //UVS ? gap between MF
	     { 300,	 1,	    12,	    20 },   //ENG
         { 20,  15,     52,     432}    //MAG  ?  25 in EDR doc
    	},

        { 
	 { 60, 	5, 	52,  40},  	//CRS
	 { 20, 	15,	16,	  4},	//LECP
	 { 20,  15,	20,	 32},	//PLS
	 { 40,	15,	7,	  8},	//PRA
	 { 20,	15,	11,	 80},	//PWS
	 { 5,	2,	640, 12},	//UVS ? gap between MF	
	 { 300,	1,	12,	 20},   //ENG
	 { 20,	15,	52, 432}	//MAG  ?  25 in EDR doc
        }
    };

// SFOC data position - corrected 4-2-2021
// sfdu_offset is computer from start of data CHDO - offset 242 from start of record
SFDU_INSTR_SUB_INFO subhdr_info[MAX_DATA_MODE][MAX_INSTR_NUM] =
    {
      {
	{ 83,	39},	//{ 79,   39},   //CRS     sfdu_offset, data_len   
	{ 142,	16},	//{ 138,  16},   //LECP
	{ 122,	20},	//{ 118,  20},   //PLS
	{ 158,	7},	    //{ 154,  7},    //PRA
	{ 165,	11},	//{ 161,  11},   //PWS
	{ 26,	6},	    //{ 22,   6},    //UVS
	{ 12,   12},	//{ 8,    12},   //ENG
	{ 32,	51}	    //{ 8,    12},   //MAG
     },

     {
        { 83,   39},   //{ 79,   39},    //CRS
        { 142,  16},   //{ 138,  16},    //LECP
        { 122,  20},   //{ 118,  20},    //PLS
        { 158,  7},    //{ 154,  7},     //PRA
        { 165,  11},    //{ 161,  11},    //PWS
        { 26,   6},    //{ 192,  400},   //UVS
	    { 12,   12},   //{ 8,	12},      //ENG
        { 32,   51}    //{ 28,   51}     //MAG
     }
   };
// EDR Header Format - See    618-306 - Rev D Chg 2
//            and Table C-9 CR-5 descriptions
// Item-34 - Word 10 Bits 3,2,1 gives Engineering Data Mode
//    000 - Launch
//    001 - Cruise                          passed as 02 into following struct
//    010 - Encounter
//    011 - Trajectrory Correction Maneuver (TCM)
//    100 - Special
//    101 - Science Maneuver                passed as 0b
//    110 - CCS Memory Readout              passed as 0c
//    111 - FDS Memory Readout              passed as 0e
// Item-34 - Word 10 Bit 0 gives Spacecraft ID
//    1 Flight 1 - Vgr-1 (31)
//    0 Flight 2 - Vgr-2 (32)  
// file_name is for files located in /home/nertops/31/dcom31.cr
//   or                              /home/nertops/32/dcom32.cr
DECOM_TBL_STRUC decom_tbl[MAX_DECOM_MAPS] =
    {
	{	0x02,	0x01,	"dcom31.cr"	    },  // Cruise             engineering data_mode, sc_id, file_name
	{	0x0b,   0x01,   "dcom31.cr"     },  // Science Maneuver
	{	0x0c,	0x01,	"dcom31.cr"     },  // CCS Memory Readout
	{	0x0e,	0x01,	"dcom31.cr"     },  // FDS Memory Readout
    {   0x02,   0x00,   "dcom32.cr"     },   
    {   0x0b,   0x00,   "dcom32.cr"     },
    {   0x0c,   0x00,   "dcom32.cr"     },
    {   0x0e,   0x00,   "dcom32.cr"     }
   };


SUBHDR_OPTMZ optmz_tbl[] = 
{ 
  {	60,	12,	192}, 		//CRS     MF_mod,  m60mod,  section_len
  {	1,	4,	0},		    //LECP
  {	10,	4,	52},		//UVS
  {	1,	8,	0},		    //PRA
  {	1,	4,	128}		//PWS
};
//mag_subhdr_max=12
SUBHDR_MAP mag_subhdr_map[mag_subhdr_max] =
{
  {	3,	0,	321,	161,	16},    //MF, mod60, ln_cnt, start_bit, bit_len
  {	4,	0,	481,	161,	16},
  {	6,	1,	  1,	161,	16},
  {	20,	3,	641,	161,	16},
  {	1,	0,	  1,	189,	12},
  {	1,	0,	  1,	201,	12},
  {	6,	1,	  1,	189,	12},
  {	6,	1,	  1,	201,	12},
  {	11,	2,	  1,	189,	12},
  {	11,	2,	  1,	201,	12},
  {	16,	3,	  1,	189,	12},
  { 16,	3, 	  1,	201,	12}
};
//pra_subhdr_max = 4 
SUBHDR_MAP pra_subhdr_map[pra_subhdr_max] =
{
  {     8,      1,      321,    161,    16}, //MF, mod60, ln_cnt, start_bit, bit_len
  {     9,      1,      481,    161,    16},
  {     28,     5,      321,    161,    16},
  {     29,     5,      481,    161,    16}
};
//uvs subhdr max = 7
SUBHDR_MAP uvs_subhdr_map[uvs_subhdr_max] =   // optimized map
{					      // condensed MF
  {     5,      0,    641,      161,    16},  //MF, mod60, ln_cnt, start_bit, bit_len
  {	    0,	    4,	  641,	    161,	16},
  {     1,      0,      1,      213,    9},  
  {     6,      1,      1,      213,    9},
  {     11,     2,      1,      213,    9},
  {     16,     3,      1,      213,    9},
  { 	21,	    4,	    1,	    213,	9}
};
//crs subhdr max = 16
SUBHDR_MAP crs_subhdr_map[crs_subhdr_max] =  // optimized map
{  					     // condensed MF
  {     19,     3,      481,    161,    16},  //MF, mod60, ln_cnt, start_bit, bit_len
  {     39,     7,      481,    161,    16},
  {     59,     11,     481,    161,    16},
  {	    0,	     0,	     0,	      0, 	 0},
  {     1,       0,      1,      177,    12},
  {     6,       1,      1,      177,    12},
  {     11,      2,      1,      177,    12},
  {     16,      3,      1,      177,    12},
  {     21,      4,      1,      177,    12},
  {     26,      5,      1,      177,    12},
  {     31,      6,      1,      177,    12},
  {     36,      7,      1,      177,    12},
  {     41,      8,      1,      177,    12},
  {     46,      9,      1,      177,    12},
  {     51,      10,     1,      177,    12},
  {     56,      11,     1,      177,    12}
};
//pls subhdr_max = 8
SUBHDR_MAP pls_subhdr_map[pls_subhdr_max] =               
{
  {	0,	0,	321,	161,	16},  //MF, mod60, ln_cnt, start_bit, bit_len
  {	0,	0,	481,	161,	16},
  {	0,	1,	  1,	161,	16},
  {	0,	3,	641,	161,	16},
  {	0, 	0, 	  1,	189,	24},
  {	0,	1,	  1,	189,	24},
  {	0,	2,	  1,	189,	24},
  {	0,	3,	  1,	189,	24}
};
//pws subhdr max =  10
SUBHDR_MAP pws_subhdr_map[pws_subhdr_max] =                // optimized map,
{					     // condensed to mod60
  {	1,	0,	  1,	161,	16},   //MF, mod60, ln_cnt, start_bit, bit_len
  {	1,	0,	  1,	177,	12},
  {	1,	0,	  1,	189,	12},
  {	1,	0,	  1,	201,	12},
  {	1,	0,	  1,	213, 	 9},
  {	1,	0,	  1,	222, 	 3},
  { 2,  0,  161,    161,    16},
  { 3,  0,  321,    161,    16},
  { 4,  0,  481,    161,    16},
  { 0,  0,  641,    161,    16}
};
//lecp subhdr max =1
SUBHDR_MAP lecp_subhdr_map[1] =
{	2,	0,	161,	161,	16};  //MF, mod60, ln_cnt, start_bit, bit_len

// EDR Header Format - See    618-306 - Figure C Rev D Chg 2
//            and Table C-1 descriptions
//
// compare with SFDU_EDR_HDR_MAP in vgr_sfdu.h
//
// EDR_STND_HDR edr_hdr_maps[EDRHDR_ITEMS_PART1]  =
EDR_STND_HDR edr_hdr_maps[]  =
{
 //item1 PRJid         put MJS
//                                 LOC    start_bit No of bits  PROCESSING 
 {"REC_ID",	    item_2_REC_ID,		0,	    7,	    4,  	 PROC_YES}, //CRS,IRIS.LEP,MAG,PLS,PPS,
                                                                        //PRA,PWS,UVS,RSS,ENG
 {"SC_ID ",	    item_3_SCID,		0,      3,      4,       INT_CONV}, //VGR-2,VGR-1
// 4   Physical Record Number
 {"PH_REC",	    item_4_PH_RECID,	1,      31,     16,      PROC_YES}, 
// 5   Data Mode - 00 thru 1F                                                     
 {"DT_MO",	    item_5_DT_MODE,		1,      15,     8,       PROC_YES}, 
// 6   Engineering Extraction Flag
 {"ENG_F",	    item_6_ENG_FLG,		1,      7,      2,       NOT_DEF },
// 7   S/C Playback 
 {"SCPB_",	    item_7_SCPB_FLG,	1,      5,      1,       PROC_NO },
 {"SERT_HR",	item_9_SERT_HR,		2,      31,     16,      PROC_YES},
 {"SERT_SEC",	item_10_SERT_SEC,	2,	    15,	    16,	     PROC_YES},
 {"SERT_MSEC",	item_11_SERT_MSEC,	3,	    31,	    16,	     PROC_YES},
 {"SERT_YR",	item_12_SERT_YR,	3,	    15,	    8,	     PROC_YES},
//      {8,     0,      16,     2,      15,     16      },
//      {9,     0,      16,     3,      15,     16      },
//      {19,    0,      8,      3,      15,     8       },
//      {0,     0,      0,      3,      7,      2       },
// 13  Data Source
 {"SOURCE",	    item_13_SOURCE,		3,	    7,	    2,	    PROC_YES},
// 14   Golay/Reed-Solomon Encoded Flag
 {"GOLAY ",	    item_14_GOLAY,		3,      5,      2,      PROC_YES},
// 15  Segment No.
 {"SEG_NO",	    item_15_SEG_NO,		3,	    3,	    4,	    PROC_YES}, 

 {"EERT_HR",	item_16_EERT_HR,	4,	    31,	    16,	    PROC_YES},
 {"EERT_SEC",	item_17_EERT_SEC,	4,	    15,	    16,	    PROC_YES},
 {"EERT_MSEC",	item_18_EERT_MSEC,	5,	    31,	    16,	    PROC_YES},
 {"EERT_YR",	item_19_EERT_YR,	5,	    15,	    8,	    PROC_YES},

// sdr_to_time
//      {0,     0,      0,      4,      31,     16      },  //item16, eERT ?
//      {0,     0,      0,      4,      15,     16      },  //item17       ?
//      {0,     0,      0,      5,      31,     16      },  //item18       ?
//      {0,     0,      0,      5,      15,     8       },  //item19 yr    ?
// 20 Software Version
 {"SF_VER",	    item_20_SF_VER,	    5,      7,      8,      NOT_DEF },

 {"SCET_HR",	item_21_SCET_HR,	6,	    31,	    16,	    PROC_YES},
 {"SCET_SEC",	item_22_SCET_SEC,	6,	    15,	    16,	    PROC_YES},
 {"SCET_MSEC",	item_23_SCET_MSEC,	7,	    31,	    16,	    PROC_YES},
 {"SCET_YR",	item_24_SCET_YR,	7,	    15,	    8,	    PROC_YES}, 

//      {12,    0,      16,     6,      31,     16      },  //item21 SCET yr
//      {13,    0,      16,     6,      15,     16      },  //item22      hr
//      {14,    0,      16,     7,      31,     16      },  //item23     msc
//      {0,     0,      0,      7,      15,     8       },  //item24 yr?
//      {0,     0,      0,      7,      7,      4       },  //item25 flag,fill?
        //  1 spare bit at word 7 bit 3
// 25  SCET Flag
 {"SCET_FLG",	item_25_SCET_FLG,	7,	    7,	    4,	    PROC_YES},
// 26  FDSC Correction Flag
 {"FDSC_F",	    item_26_FDSC_FLG,	7,      2,      3,      NOT_DEF },
// 27  MOD 16 MM subcom time word
 {"M16   ",	    item_27_M16,		8,      31,     16,     PROC_NO },
 {"M60   ",	    item_28_M60,		8,      15,     8,      PROC_NO },
// 29  Line Count word ISS (1-800)
 {"LN_CNT",	    item_29_LN_CNT,		8,      7,      16,     PROC_NO },
                                                        //item30,undefined
                                                        //item31,undefined
// 31  D/L TLM Rate
// 
 {"BIT_RA",	    item_32_BIT_RATE,	9,      23,     8,      PROC_YES},
// 33  Effective Rate 
 {"EF_BRA",	    item_33_EF_BRATE,   9,      15,     8,	    PROC_YES},  

// 34  FID - Format ID
 {"FMT_ID",	    item_34_FMT_ID,		9,      7,      8,      NOT_DEF },
// 35  Bit Error Tolerance
 {"BET   ",	    item_35_BET,		10,	    31, 	8,	    PROC_NO},
// 36  DSN Eauipment Configuration
{"DSN_CONF",	item_36_LOCK_CNF,	10,	    23,	    8, 	    PROC_NO},
 {"SIG_LVL",	item_37_AGC,		10,	    15,	    16,	    PROC_NO},

// {SEC_HDR_ID, 22,     0       8,      10,     31,     8       },
//      {0,     0,      0,      10,     23,     8       },  //item36 DSN conf?
//      {0,     0,      0,      10,     15,     16      },  //item37,AGC fill?

 {"DSN_ST",	    item_38_DSN_ST,		11,     31,     8,       PROC_NO },
                                                            //item39 spare
// add_bit_error_cnt  *** for every MF
 {"EBEC  ",	    item_40_EBEC,   	11,	    15,     16,	    PROC_YES}, 
// 41  Symbol SNR
 {"SNR   ",	    item_41_SNR,		12,     31,     16,      PROC_NO },
//      {0,     0,      0,      12,     15,     16      },  //item42,deSNR?

// 43  Physcal Record Number
// {0,    0,      0,      0,      13,     31,     16      },
// set_dqsw
//      {0,     0,      0,      13,     15,     8       },  //item44, DQSW ?
//      {29,    1,      1,      13,     4,      1       },  //item45 PN out
//      {29,    0,      1,      13,     3,      1       },  //item46 PN in
//      {0,     4,      1,      13,     1,      1       },  //item47 valid
//      {29,    2,      1,      13,     0,      1       },   //item48 GCFerr

 {"ITEM_99",	ITEM_99,		    0,	    0,	     0,	    PROC_NO}
};
#endif
